/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.diagram;

import com.harrand.coreclasses.element.IIdfAsIs;
import com.harrand.coreclasses.element.ISelectable;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.zoom.IZoomable;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.Icons;
import com.harrand.coregui.panel.viewport.ViewportMoveCtrl;
import com.harrand.dbwrench.diagram.DbDrawableOrderer;
import com.harrand.dbwrench.diagram.watermark.DbWatermarkTextEngine;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.command.DwrDeleteGlyphsCmdFactory;
import com.harrand.dbwrenchgui.diagram.DbwDiagramDropListener;
import com.harrand.dbwrenchgui.diagram.DiagramCmdBldr;
import com.harrand.dbwrenchgui.diagram.panel.scroll.DiagramScrollBarInitCtrl;
import com.harrand.dbwrenchnb.action.diagram.support.ZoomCmdDisp;
import com.harrand.dbwrenchnb.diagram.GlyphLocateMgr;
import com.harrand.dbwrenchnb.diagram.MouseEventTranslator;
import com.harrand.dbwrenchnb.diagram.NavigatorTopComponent;
import com.harrand.dbwrenchnb.diagram.Slider;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.GlyphLocator;
import com.harrand.sketch.glyph.interfaces.IGlyphLocator;
import com.harrand.sketch.glyph.mgr.GlyphSelectionMgr;
import com.harrand.sketch.interfaces.IDiagramContainer;
import com.harrand.sketch.interfaces.INavigator;
import com.harrand.sketch.interfaces.INavigatorSrc;
import com.harrand.sketch.j2d.DiagramKeyListener;
import com.harrand.sketch.j2d.DiagramPanel;
import com.harrand.sketch.panel.IViewportSrc;
import com.harrand.sketch.panel.diagram.IDiagramScroller;
import com.harrand.sketch.prefs.diagram.GlyphLocatePrefCtrl;
import com.harrand.sketch.zoom.IZoomToolbar;
import com.harrand.sketch.zoom.ZoomCtrlMgr;
import com.harrand.sketch.zoom.ZoomToolbarServer;
import com.harrand.sketch.zoom.disp.SetZoomDisp;
import com.harrand.util.MathUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DiagramTC
extends TopComponent
implements LookupListener,
INavigatorSrc,
MouseMotionListener,
MouseListener,
IObserver,
ChangeListener,
MouseWheelListener,
IIdfAsIs,
IViewportSrc,
ISelectable,
IZoomable,
IDiagramContainer,
IDiagramScroller,
IGlyphLocator {
    private DiagramPanel diagramPanel_;
    private Diagram diagram_;
    private INavigator navigator_;
    private JScrollPane scrollPane_;
    private JScrollBar vbar_;
    private JScrollBar hbar_;
    private Slider slider_;
    private GlyphLocator glyphLocator_;
    private ViewportMoveCtrl viewportMoveCtrl_;
    private GlyphLocateMgr glyphLocateMgr_ = GlyphLocateMgr.getInstance();
    private ZoomCtrlMgr zmCtrlMgr_ = new ZoomCtrlMgr(LookupUtil.getLookupDb());
    private Lookup.Result result;
    private boolean updateNvFlag_ = true;
    private boolean isSelected_ = false;
    private boolean activatingNv = false;

    public DiagramTC(Diagram diagram) {
        this.diagram_ = diagram;
        this.initComponents();
        this.buildPanel();
        CentralLookup.getDefault().addObserver(this);
        this.diagram_.setViewportSrc(this);
        this.diagram_.addObserver(this);
        this.initNavTC();
        this.glyphLocateMgr_.setDiagramScroller(this);
    }

    private void buildPanel() {
        this.initPanel();
        this.layoutPanel();
        this.addListeners();
        this.setNames();
        this.setCosmetics();
        this.slider_ = new Slider(this.scrollPane_, this.diagram_);
        Database db = (Database)CentralLookup.getDefault().lookup(Database.class);
        this.glyphLocator_ = new GlyphLocator(db);
    }

    private void addListeners() {
        this.scrollPane_.addMouseListener(this);
        this.scrollPane_.addMouseMotionListener(this);
        this.scrollPane_.addKeyListener(new DiagramKeyListener(this.diagramPanel_));
        this.scrollPane_.addMouseWheelListener(this);
        this.addScrollBarListeners();
        ActionListener lisDeleteSelected = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DiagramTC.this.diagramPanel_.deleteSelected();
            }
        };
        this.registerKeyboardAction(lisDeleteSelected, KeyStroke.getKeyStroke(127, 0, false), 2);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public int getPersistenceType() {
        return 2;
    }

    private void initNavTC() {
        this.glyphLocateMgr_.setDiagramScroller(this);
        if (!this.activatingNv) {
            this.activatingNv = true;
            NavigatorTopComponent navTc = (NavigatorTopComponent)NbUtil.activateOpenTopComponent("NavigatorTopComponent");
            if (navTc != null) {
                this.navigator_ = navTc.getNvPanel();
                this.navigator_.setNavigatorSrc(this);
                this.navigator_.setDiagram(this.diagram_);
                this.navigator_.clearObserversOfClass(this.getClass().getName());
                this.navigator_.addObserver(this);
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        DiagramTC.this.updateNavigatorPortal();
                        DiagramTC.this.updateZoomToolbar(DiagramTC.this.diagram_);
                    }
                });
            }
            this.requestActive();
            this.activatingNv = false;
        }
    }

    private void initPanel() {
        this.diagramPanel_ = new DiagramPanel(this.diagram_, new DbDrawableOrderer());
        this.diagramPanel_.setDiagramContainer(this);
        this.diagramPanel_.setWatermark(new DbWatermarkTextEngine());
        this.scrollPane_ = new JScrollPane(this.diagramPanel_, 22, 32);
        this.hbar_ = this.scrollPane_.getHorizontalScrollBar();
        this.vbar_ = this.scrollPane_.getVerticalScrollBar();
        this.viewportMoveCtrl_ = new ViewportMoveCtrl(this.scrollPane_.getViewport());
        this.viewportMoveCtrl_.addObserver(this);
        DbwDiagramDropListener dropListener = new DbwDiagramDropListener(this.diagramPanel_);
        this.diagramPanel_.setDropTargetListener(dropListener);
        this.diagramPanel_.setDiagramCmdBldr(new DiagramCmdBldr(this.diagram_));
        this.diagramPanel_.setDeleteGlyphsCmdFactory(new DwrDeleteGlyphsCmdFactory());
        this.diagramPanel_.setNavigatorSrc(this);
        this.diagramPanel_.addObserver(this);
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane_, "Center");
    }

    private void setCosmetics() {
        this.updateDisplayName();
        this.setToolTipText(Diagram.getClassName());
        this.setIcon(Icons.DIAGRAM.getImage());
        this.initScrollBars();
    }

    private void updateDisplayName() {
        this.setDisplayName(this.diagram_.getName());
    }

    private void setNames() {
        this.scrollPane_.setName("scrollPane");
        this.vbar_.setName("vbar");
        this.hbar_.setName("hbar");
        this.setName("DiagramTC");
    }

    private void initScrollBars() {
        DiagramScrollBarInitCtrl initCtrl = new DiagramScrollBarInitCtrl(this.vbar_, this.hbar_);
        initCtrl.initScrollBars();
    }

    private void selectGlyph(String glyphNm) {
        ArrayList<String> selectedGlyphNms = new ArrayList<String>();
        selectedGlyphNms.add(glyphNm);
        this.getGlyphSelectionMgr().setSelectedGlyphs(selectedGlyphNms);
        this.diagramPanel_.refresh();
    }

    private void unselectGlyphs() {
        this.getGlyphSelectionMgr().setSelectedGlyphs(new ArrayList());
        this.diagramPanel_.refresh();
    }

    private GlyphSelectionMgr getGlyphSelectionMgr() {
        return this.diagram_.getSelectionMgr();
    }

    @Override
    public void locateGlyph(String glyphNm) {
        if (this.isShowing()) {
            Diagram containingDiagram = this.glyphLocator_.getContainingDiagram(glyphNm, this.diagram_);
            if (containingDiagram != null) {
                if (this.diagram_.getName().equals(containingDiagram.getName())) {
                    this.locateGlyphDetails(this.diagram_, glyphNm);
                } else {
                    this.unselectGlyphs();
                }
            } else {
                this.unselectGlyphs();
            }
        }
    }

    private void locateGlyphDetails(Diagram glyphDiagram, String glyphNm) {
        Glyph glyph = glyphDiagram.getGlyphOrLink(glyphNm);
        boolean doSlide = GlyphLocatePrefCtrl.getInstance().getSlideToLocateFlag();
        this.selectGlyph(glyphNm);
        JViewport viewport = this.scrollPane_.getViewport();
        Dimension viewportSize = viewport.getSize();
        Point newViewPos = this.glyphLocator_.getViewPosition(glyph, glyphDiagram, viewportSize);
        int fontSz = glyphDiagram.getRenderConfig().getFont().getSize();
        this.viewportMoveCtrl_.setFontSize(fontSz);
        this.viewportMoveCtrl_.setZoomLevel(glyphDiagram.getZoom().getLevel());
        if (doSlide) {
            this.viewportMoveCtrl_.moveViewSlowly(newViewPos);
        } else {
            this.viewportMoveCtrl_.moveViewDirectly(newViewPos);
        }
        this.diagramPanel_.refresh();
        this.updateNvPosition();
        this.diagramPanel_.blinkSelectedGlyphs();
    }

    private void updateNvPosition() {
        if (this.updateNvFlag_) {
            this.updateNavigatorPortal();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Dimension maxSize = this.diagramPanel_.getPreferredSize();
        Rectangle maxRect = new Rectangle(0, 0, maxSize.width, maxSize.height);
        this.viewportMoveCtrl_.autoScrollToShowPoint(mouseEvent.getPoint(), maxRect);
        this.diagramPanel_.mouseDragged(this.getTranslatedEvent(mouseEvent));
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        boolean shift = mouseEvent.isShiftDown();
        if (shift) {
            this.slider_.mouseMoved(mouseEvent);
        } else {
            this.clearSlide();
            this.diagramPanel_.mouseMoved(this.getTranslatedEvent(mouseEvent));
        }
    }

    public void clearSlide() {
        this.slider_.clear();
    }

    private MouseEvent getTranslatedEvent(MouseEvent evt) {
        return MouseEventTranslator.getTranslatedEvent(this.scrollPane_, evt);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.diagramPanel_.mouseClicked(this.getTranslatedEvent(mouseEvent));
        this.scrollPane_.requestFocusInWindow();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.checkInitNavigator();
        this.diagramPanel_.mouseEntered(this.getTranslatedEvent(mouseEvent));
        this.scrollPane_.requestFocusInWindow();
    }

    private void checkInitNavigator() {
        INavigatorSrc navigatorSrc;
        if (this.navigator_ != null && (navigatorSrc = this.navigator_.getNavigatorSrc()) == null) {
            this.initNavTC();
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.diagramPanel_.mouseExited(this.getTranslatedEvent(mouseEvent));
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.checkInitNavigator();
        this.scrollPane_.requestFocusInWindow();
        this.diagramPanel_.mousePressed(this.getTranslatedEvent(mouseEvent));
        this.scrollPane_.requestFocusInWindow();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        MouseEvent transEvent = this.getTranslatedEvent(mouseEvent);
        this.diagramPanel_.mouseReleased(transEvent);
    }

    public DiagramPanel getDiagramPanel() {
        return this.diagramPanel_;
    }

    @Override
    public Diagram getDiagram() {
        return this.diagramPanel_.getDiagram();
    }

    @Override
    public JScrollPane getScrollPane() {
        return this.scrollPane_;
    }

    @Override
    public IRefreshable getRefreshable() {
        return this.diagramPanel_;
    }

    private void addScrollBarListeners() {
        this.hbar_.getModel().addChangeListener(this);
        this.vbar_.getModel().addChangeListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.zmCtrlMgr_.clearIdealRect(this.getDiagram());
        this.updateNvPosition();
    }

    public void resultChanged(LookupEvent ev) {
        Lookup.Result r = (Lookup.Result)ev.getSource();
        Collection c = r.allInstances();
        if (!c.isEmpty()) {
            Table table1 = (Table)c.iterator().next();
            String dotNote = table1.getDotNote();
            this.locateGlyph(dotNote);
        }
    }

    protected void componentHidden() {
        this.result.removeLookupListener((LookupListener)this);
        this.result = null;
    }

    protected void componentShowing() {
        Lookup.Template tpl = new Lookup.Template(Table.class);
        this.result = Utilities.actionsGlobalContext().lookup(tpl);
        this.result.addLookupListener((LookupListener)this);
        this.initNavTC();
    }

    protected void componentActivated() {
        this.setSelected(true);
        this.initNavTC();
    }

    protected void componentClosed() {
        super.componentClosed();
        if (this.navigator_ != null) {
            this.navigator_.setNavigatorSrc(null);
        }
        this.diagramPanel_.close();
        this.diagramPanel_ = null;
    }

    protected void componentDeactivated() {
        this.setSelected(false);
    }

    private void updateZoomToolbar(Diagram diagram) {
        IZoomToolbar toolbar = ZoomToolbarServer.getInstance().getZoomToolbar();
        if (toolbar != null) {
            toolbar.setDiagram(diagram);
        }
    }

    @Override
    public Rectangle2D getPortal() {
        Rectangle vpRect = this.scrollPane_.getViewport().getViewRect();
        return GeometryHelper.getRect2D(vpRect);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.updateNavigatorPortal();
    }

    private void updateNavigatorPortal() {
        if (this.isNavigatorSet()) {
            this.navigator_.setPortalInDiaCoords(this.getPortal());
        }
    }

    private boolean isNavigatorSet() {
        return this.navigator_ != null;
    }

    @Override
    public void update(UpdateChain chain) {
        if (this.navigator_ != null && chain.hasInteface(INavigator.class.getName())) {
            Dimension size;
            this.updateNvFlag_ = false;
            Rectangle2D portal = this.navigator_.getPortalInDiaCoords();
            Point pt = new Point(MathUtil.round(portal.getX()), MathUtil.round(portal.getY()));
            ITestResult result = this.viewportMoveCtrl_.checkMoveOk(pt, size = this.diagramPanel_.getPreferredSize());
            if (result.getPassed()) {
                this.viewportMoveCtrl_.moveViewDirectly(pt);
            }
            this.updateNvFlag_ = true;
        }
        if (this.navigator_ != null && chain.hasClassName(ViewportMoveCtrl.class.getName())) {
            this.updateNavigatorPortal();
        }
        this.updateDisplayName();
    }

    @Override
    public void doZoom(int direction) {
        ZoomCmdDisp disp = new ZoomCmdDisp();
        disp.doZoom(null, direction);
    }

    @Override
    public Zoom getZoom() {
        if (this.getDiagram() != null) {
            return new Zoom(this.getDiagram().getZoom().getLevel());
        }
        return new Zoom(1.0);
    }

    @Override
    public void setZoom(Zoom zoom) {
        if (this.getDiagram() != null) {
            SetZoomDisp zoomDisp = new SetZoomDisp(this.diagramPanel_, this.scrollPane_);
            zoomDisp.setZoom(zoom);
        }
    }

    @Override
    public Identifiable getIdfAsIs() {
        return this.diagram_;
    }

    @Override
    public Collector getCollector() {
        return null;
    }

    @Override
    public Rectangle getViewportRect() {
        return this.scrollPane_.getViewport().getViewRect();
    }

    @Override
    public void setSelected(boolean selected) {
        this.isSelected_ = selected;
    }

    @Override
    public boolean getSelected() {
        return this.isSelected_;
    }
}

