/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.action.edit;

import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.dbwrenchnb.nb.NbUtil;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public class UndoRedoPresenter
extends CallableSystemAction
implements IObserver {
    private CommandChain cmdChain_ = CommandChainMgr.getCmdChain();
    private JButton btnUndo_;
    private JButton btnRedo_;

    public UndoRedoPresenter() {
        this.initBtns();
        this.updateBtns();
        this.cmdChain_.addObserver(this);
    }

    public Component getToolbarPresenter() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(this.btnUndo_);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.btnRedo_);
        return panel;
    }

    private void initBtns() {
        this.btnUndo_ = new JButton(Icons.UNDO);
        this.btnRedo_ = new JButton(Icons.REDO);
        this.btnUndo_.setEnabled(false);
        this.btnRedo_.setEnabled(false);
        this.btnUndo_.setName("btnUndo");
        this.btnRedo_.setName("btnRedo");
    }

    public void performAction() {
    }

    private void updateBtn(JButton btn, Command cmd) {
        if (cmd != null) {
            btn.setEnabled(true);
            String tooltip = (String)cmd.getValue("Name");
            cmd.putValue("Name", null);
            btn.setAction(cmd);
            btn.setToolTipText(tooltip);
        } else {
            btn.setEnabled(false);
        }
    }

    private void updateBtns() {
        if (this.cmdChain_ != null) {
            Command undoCommand = this.cmdChain_.getUndoCommand();
            Command redoCommand = this.cmdChain_.getRedoCommand();
            this.updateBtn(this.btnUndo_, undoCommand);
            this.updateBtn(this.btnRedo_, redoCommand);
        } else {
            NbUtil.logMsg("UndoRedoPanel Command Chain is null.");
        }
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateBtns();
    }

    public String getName() {
        return "Undo Redo Panel";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

