/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchnb.action.edit;

import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.dataEntry.IEditorActionFactory;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrenchgui.panel.ProcEditPanel;
import com.harrand.dbwrenchgui.panel.TriggerEditPanel;
import com.harrand.dbwrenchgui.panel.ViewEditPanel;
import com.harrand.dbwrenchnb.action.edit.ShowEditor;
import javax.swing.AbstractAction;
import javax.swing.JPanel;

public class EditorActionFactory
implements IEditorActionFactory {
    private static EditorActionFactory instance__ = new EditorActionFactory();

    private EditorActionFactory() {
    }

    public static EditorActionFactory getInstance() {
        return instance__;
    }

    @Override
    public AbstractAction getAddEditorAction(Collector coll, String idfClzNm) {
        JPanel dataEditor;
        ShowEditor action = null;
        if (coll instanceof Schema) {
            Schema schema = (Schema)coll;
            if (idfClzNm.equals(View.getClassName())) {
                dataEditor = new ViewEditPanel(schema);
                action = new ShowEditor(dataEditor, "Add View");
            } else if (idfClzNm.equals(Proc.getClassName())) {
                dataEditor = new ProcEditPanel(schema);
                action = new ShowEditor(dataEditor, "Add Procedure");
            }
        }
        if (coll instanceof Table) {
            Table table = (Table)coll;
            if (idfClzNm.equals(Trigger.getClassName())) {
                dataEditor = new TriggerEditPanel(null, table);
                action = new ShowEditor(dataEditor, "Add Trigger");
            }
        }
        return action;
    }

    @Override
    public AbstractAction getUpdateEditorAction(Collector coll, Identifiable idf) {
        ShowEditor action = null;
        JPanel editorPanel = null;
        if (idf instanceof View) {
            editorPanel = new ViewEditPanel((View)idf);
        } else if (idf instanceof Proc) {
            editorPanel = new ProcEditPanel((Proc)idf);
        } else if (idf instanceof Trigger) {
            Table table = (Table)coll;
            editorPanel = new TriggerEditPanel((Trigger)idf, table);
        }
        if (editorPanel != null) {
            action = new ShowEditor(editorPanel, null);
        }
        return action;
    }
}

