/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.text.line;

import com.harrand.dbwrenchgui.text.lexer.range.TextRange;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Utilities;

public final class LineStartFinder {
    public List<Integer> getSelectedTextLineStarts(JEditorPane editorPane) {
        TextRange textRange = this.getSelectedRange(editorPane);
        ArrayList<Integer> lineStarts = new ArrayList<Integer>();
        for (int i = textRange.getStart(); i <= textRange.getEnd(); ++i) {
            try {
                int start = Utilities.getRowStart(editorPane, i);
                if (lineStarts.contains(start)) continue;
                lineStarts.add(start);
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return lineStarts;
    }

    private TextRange getSelectedRange(JEditorPane editorPane) {
        TextRange textRange = new TextRange(editorPane.getSelectionStart(), editorPane.getSelectionEnd());
        return textRange;
    }
}

