/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.text.lexer.lexer;

import com.harrand.dbwrenchgui.text.lexer.lexer.BackTickLexer;
import com.harrand.dbwrenchgui.text.lexer.lexer.DoubleQuoteLexer;
import com.harrand.dbwrenchgui.text.lexer.lexer.ILexer;
import com.harrand.dbwrenchgui.text.lexer.lexer.KeywordLexer;
import com.harrand.dbwrenchgui.text.lexer.lexer.MultilineCommentLexer;
import com.harrand.dbwrenchgui.text.lexer.lexer.NumberLexer;
import com.harrand.dbwrenchgui.text.lexer.lexer.SingleLineCommentLexer;
import com.harrand.dbwrenchgui.text.lexer.lexer.SingleQuoteLexer;
import com.harrand.dbwrenchgui.text.lexer.token.IToken;
import java.util.ArrayList;
import java.util.List;

public final class LexerCtrl {
    private final ILexer numberLexer = new NumberLexer();
    private final ILexer keywordLexer = new KeywordLexer();
    private final ILexer singleQuoteLexer = new SingleQuoteLexer();
    private final ILexer doubleQuoteLexer = new DoubleQuoteLexer();
    private final ILexer backTickLexer = new BackTickLexer();
    private final ILexer singleLineCommentLexer = new SingleLineCommentLexer();
    private final ILexer multilinecommentLexer = new MultilineCommentLexer();

    public List<IToken> lex(String text) {
        String[] words = text.split("\\s+");
        ArrayList<IToken> wordTokens = new ArrayList<IToken>();
        wordTokens.addAll(this.numberLexer.lex(text));
        wordTokens.addAll(this.keywordLexer.lex(text));
        wordTokens.addAll(this.singleQuoteLexer.lex(text));
        wordTokens.addAll(this.doubleQuoteLexer.lex(text));
        wordTokens.addAll(this.backTickLexer.lex(text));
        wordTokens.addAll(this.singleLineCommentLexer.lex(text));
        wordTokens.addAll(this.multilinecommentLexer.lex(text));
        return wordTokens;
    }
}

