/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.text.keystroke;

import com.harrand.coregui.keyStroke.IKeyStrokeActionMapper;
import com.harrand.dbwrenchgui.sub.editor.DbwEditor;
import com.harrand.dbwrenchgui.sub.editor.key.KeyStrokeActionCtrl;
import com.harrand.dbwrenchgui.text.action.CommentAction;
import com.harrand.dbwrenchgui.text.action.DeleteLineAction;
import com.harrand.dbwrenchgui.text.action.IndentAction;
import com.harrand.dbwrenchgui.text.action.UncommentAction;
import com.harrand.dbwrenchgui.text.action.UnindentAction;
import com.harrand.dbwrenchgui.text.keystroke.CodeCompleteKeyStrokeMapper;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;

public final class DbwEditorKeyStrokeMapper
implements IKeyStrokeActionMapper {
    private final JEditorPane editorPane;
    private final CodeCompleteKeyStrokeMapper codeCompleteKeyStrokeMapper;
    private final DbwEditor dbwEditor;

    public DbwEditorKeyStrokeMapper(DbwEditor dbwEditor) {
        this.dbwEditor = dbwEditor;
        this.editorPane = dbwEditor.getEditorPane();
        this.codeCompleteKeyStrokeMapper = new CodeCompleteKeyStrokeMapper(dbwEditor);
    }

    @Override
    public void checkInvokeAction(KeyEvent event) {
        AbstractAction action = this.codeCompleteKeyStrokeMapper.getCodeCompletePopupAction(event);
        if (action == null) {
            if (this.matches(event, 47, false, true, false)) {
                action = new CommentAction(this.editorPane);
            } else if (this.matches(event, 69, false, true, false)) {
                action = new DeleteLineAction(this.editorPane);
            } else if (this.matches(event, 47, false, true, true)) {
                action = new UncommentAction(this.editorPane);
            } else if (this.matches(event, 9, false, false, false)) {
                action = new IndentAction(this.editorPane);
            } else if (this.matches(event, 9, false, false, true)) {
                action = new UnindentAction(this.editorPane);
            } else if (this.matches(event, 9, false, false, true)) {
                action = new UnindentAction(this.editorPane);
            } else if (this.matches(event, 10, false, true, false)) {
                this.dbwEditor.executeCommand();
            } else if (KeyStrokeActionCtrl.matches(event, 10, false, false, false, true)) {
                this.dbwEditor.executeCommand();
            }
        }
        if (action != null) {
            action.actionPerformed(null);
        }
    }

    private boolean matches(KeyEvent event, int keyCode, boolean altDown, boolean ctrlDown, boolean shiftDown) {
        return KeyStrokeActionCtrl.matches(event, keyCode, altDown, ctrlDown, shiftDown);
    }
}

