/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.text.completion.popupMenu;

public final class CurrentWordFinder {
    private String docText;
    private int caretPosition;
    private Integer wordStart;
    private Integer wordEnd;
    private Integer phraseStart;
    private Integer phraseEnd;

    public String getCurrentWord(String docText, int caretPosition) {
        this.wordStart = null;
        this.wordEnd = null;
        this.docText = docText;
        this.caretPosition = caretPosition;
        if (docText.length() > 0 && caretPosition > 0) {
            this.wordStart = this.calcWordStart(true);
            this.wordEnd = this.calcWordEnd();
            if (this.wordStart != null && this.wordEnd != null) {
                String currentWord = docText.substring(this.wordStart, this.wordEnd);
                return currentWord;
            }
        }
        return null;
    }

    public String getCurrentPhrase(String docText, int caretPosition) {
        this.phraseStart = null;
        this.phraseEnd = null;
        this.docText = docText;
        this.caretPosition = caretPosition;
        if (docText.length() > 0 && caretPosition > 0) {
            this.phraseStart = this.calcWordStart(false);
            this.phraseEnd = this.calcWordEnd();
            if (this.phraseStart != null && this.phraseEnd != null) {
                String currentPhrase = docText.substring(this.phraseStart, this.phraseEnd);
                return currentPhrase;
            }
        }
        return null;
    }

    private boolean isLineFeed(String string) {
        boolean isCR = string.equals("\r\n");
        boolean isN = string.equals("\n");
        return isCR || isN;
    }

    private Integer calcWordStart(boolean findDots) {
        for (int i = this.caretPosition; i >= 0; --i) {
            boolean isDot;
            char preceedingCh;
            boolean isDocStart;
            boolean bl = isDocStart = i == 0;
            if (isDocStart) {
                return i;
            }
            char preceedingInt = preceedingCh = this.docText.charAt(i - 1);
            String preceedingCharStr = this.docText.substring(i - 1, i);
            boolean isNonPrintable = preceedingInt < '\u001f';
            boolean isLineFeed = this.isLineFeed(preceedingCharStr);
            boolean isSpace = preceedingCh == ' ';
            boolean bl2 = isDot = preceedingCh == '.';
            if (isSpace || isLineFeed || isNonPrintable) {
                return i;
            }
            if (!findDots || !isDot) continue;
            return i;
        }
        return null;
    }

    private Integer calcWordEnd() {
        int textLength = this.docText.length();
        for (int i = this.caretPosition; i < textLength; ++i) {
            String previousChar = this.docText.substring(i, i + 1);
            boolean isSpace = previousChar.equals(" ");
            boolean isLineFeed = this.isLineFeed(previousChar);
            boolean isDot = previousChar.equals(".");
            if (!isSpace && !isLineFeed && !isDot) continue;
            return i;
        }
        return textLength;
    }

    public Integer getWordEnd() {
        return this.wordEnd;
    }

    public Integer getWordStart() {
        return this.wordStart;
    }
}

