/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.text.completion.popupMenu;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrenchgui.text.completion.popupMenu.CodeCompleteAction;
import com.harrand.dbwrenchgui.text.completion.popupMenu.CodeCompletionItem;
import com.harrand.dbwrenchgui.text.completion.popupMenu.CurrentWordFinder;
import com.harrand.dbwrenchgui.text.keystroke.CodeCompleteRePopUpCtrl;
import com.harrand.dbwrenchnb.editor.completion.CodeCompletionItemBldr;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public final class CodeCompletionPopup
extends JPopupMenu
implements ComponentListener {
    private final CurrentWordFinder currentWordFinder = new CurrentWordFinder();
    private final JEditorPane editorPane;
    private List<CodeCompletionItem> codeCompletionItems;
    private int count = 0;
    private final CodeCompleteRePopUpCtrl rePopUpCtrl;

    CodeCompletionPopup(JEditorPane editorPane, CodeCompleteRePopUpCtrl rePopUpCtrl) {
        this.editorPane = editorPane;
        this.rePopUpCtrl = rePopUpCtrl;
        this.buildCodeCompletionItems();
        this.buildMenuItems();
        this.setRequestFocusEnabled(true);
        this.requestFocusInWindow();
        for (KeyListener keyListener : this.getKeyListeners()) {
            keyListener.toString();
        }
        this.addComponentListener(this);
    }

    private void buildCodeCompletionItems() {
        String currentWord = this.getCurrentWord();
        String currentPhrase = this.getCurrentPhrase();
        this.codeCompletionItems = new CodeCompletionItemBldr().getCodeCompletionItems(currentWord, currentPhrase);
        if (this.codeCompletionItems.isEmpty()) {
            // empty if block
        }
    }

    private String getCurrentWord() {
        return this.currentWordFinder.getCurrentWord(this.getEditorText(), this.editorPane.getCaretPosition());
    }

    private String getCurrentPhrase() {
        return this.currentWordFinder.getCurrentPhrase(this.getEditorText(), this.editorPane.getCaretPosition());
    }

    private String getEditorText() {
        return GuiHelper.getEditorPaneText(this.editorPane);
    }

    private void buildMenuItems() {
        for (CodeCompletionItem codeCompletionItem : this.codeCompletionItems) {
            this.addMenuItem(codeCompletionItem);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent evt, MenuElement[] path, MenuSelectionManager manager) {
        char ch = evt.getKeyChar();
        String typedKey = new String(new char[]{ch});
        Document document = this.editorPane.getDocument();
        int keyCode = evt.getKeyCode();
        boolean isPopupCloseKey = this.isPopupCloseKey(keyCode);
        boolean isPopupIgnoreKey = this.isPopupIgnoreKey(keyCode);
        int dot = this.getCaretDot();
        if (isPopupCloseKey) {
            if (keyCode == 32) {
                this.insertText(document, dot, typedKey);
                this.rePopUpCtrl.setIsActive(false);
                this.setVisible(false);
                return;
            }
            super.processKeyEvent(evt, path, manager);
            this.rePopUpCtrl.setIsActive(false);
        } else if (isPopupIgnoreKey) {
            super.processKeyEvent(evt, path, manager);
        } else {
            String currentWord;
            if (evt.paramString().contains("KEY_PRESSED") && !this.rePopUpCtrl.getIsProbablyDuplicateStroke(currentWord = this.getCurrentWord(), Character.valueOf(ch))) {
                try {
                    if (keyCode == 8) {
                        if (document.getLength() > 0) {
                            document.remove(dot - 1, 1);
                        }
                    } else {
                        this.insertText(document, dot, typedKey);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            this.setVisible(false);
        }
    }

    private void insertText(Document document, int dot, String typedKey) {
        try {
            document.insertString(dot, typedKey, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private int getCaretDot() {
        return this.editorPane.getCaret().getDot();
    }

    private void addMenuItem(CodeCompletionItem codeCompletionItem) {
        CodeCompleteAction applyCodeCompleteAction = new CodeCompleteAction(this.editorPane, codeCompletionItem.getDisplayText());
        JMenuItem menuItem = new JMenuItem(applyCodeCompleteAction);
        if (codeCompletionItem.getIcon() != null) {
            menuItem.setIcon(codeCompletionItem.getIcon());
        }
        String countString = Integer.toString(++this.count);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(countString));
        this.add(menuItem);
    }

    boolean getWereKeywordsFound() {
        return this.count > 0;
    }

    private boolean isPopupIgnoreKey(int keyCode) {
        return keyCode == 0 || keyCode == 38 || keyCode == 40 || keyCode == 17;
    }

    private boolean isPopupCloseKey(int keyCode) {
        return keyCode == 49 || keyCode == 50 || keyCode == 51 || keyCode == 52 || keyCode == 53 || keyCode == 54 || keyCode == 55 || keyCode == 56 || keyCode == 57 || keyCode == 27 || keyCode == 32 || keyCode == 10;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.dispatchEvent(new KeyEvent(this, 401, 0L, 0, 40, '\u0000'));
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

