/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.text.completion.popupMenu;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrenchgui.text.completion.popupMenu.CurrentWordFinder;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public final class CodeCompleteAction
extends AbstractAction {
    private final JEditorPane editorPane;
    private final String replaceWord;

    public CodeCompleteAction(JEditorPane editorPane, String replaceWord) {
        super(replaceWord);
        this.editorPane = editorPane;
        this.replaceWord = replaceWord;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.replaceWord();
    }

    private void replaceWord() {
        CurrentWordFinder currentWordFinder = new CurrentWordFinder();
        String text = GuiHelper.getEditorPaneText(this.editorPane);
        int caretPosition = this.editorPane.getCaretPosition();
        currentWordFinder.getCurrentWord(text, caretPosition);
        int currentWordStart = currentWordFinder.getWordStart();
        int currentWordEnd = currentWordFinder.getWordEnd();
        int currentWordLength = currentWordEnd - currentWordStart;
        int caratWordStart = caretPosition - currentWordLength;
        try {
            Document doc = this.editorPane.getDocument();
            doc.remove(caratWordStart, currentWordLength);
            int insertLocation = caratWordStart;
            doc.insertString(insertLocation, this.replaceWord, null);
            int newCaretPosition = insertLocation + this.replaceWord.length();
            this.editorPane.setCaretPosition(newCaretPosition);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

