/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.text.action;

import com.harrand.dbwrenchgui.text.action.IndentAction;
import com.harrand.dbwrenchgui.text.line.LineStartFinder;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public final class UnindentAction
extends AbstractAction {
    private final LineStartFinder lineStartFinder = new LineStartFinder();
    private final JEditorPane editorPane;

    public UnindentAction(JEditorPane editorPane) {
        this.editorPane = editorPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Integer> lineStarts = this.lineStartFinder.getSelectedTextLineStarts(this.editorPane);
        Collections.reverse(lineStarts);
        Document doc = this.editorPane.getDocument();
        String indentText = IndentAction.getIndentText();
        for (Integer lineStart : lineStarts) {
            try {
                int length = indentText.length();
                String subString = doc.getText(lineStart, length);
                if (!subString.equals(indentText)) continue;
                doc.remove(lineStart, length);
            }
            catch (BadLocationException badLocationException) {}
        }
    }
}

