/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.text.action;

import com.harrand.coreclasses.element.Range;
import com.harrand.dbwrenchgui.text.line.LineRangesFinder;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public final class DuplicateLineUpAction
extends AbstractAction {
    private final LineRangesFinder lineRangeFinder = new LineRangesFinder();
    private final JEditorPane editorPane;

    public DuplicateLineUpAction(JEditorPane editorPane) {
        this.editorPane = editorPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Range> selectedLineRanges = this.lineRangeFinder.getSelectedTextLineRanges(this.editorPane);
        if (!selectedLineRanges.isEmpty()) {
            int blockStart = selectedLineRanges.get(0).getStart();
            if (blockStart > 0) {
                --blockStart;
            }
            int blockEnd = selectedLineRanges.get(selectedLineRanges.size() - 1).getEnd();
            int blockLength = blockEnd - blockStart;
            try {
                Document document = this.editorPane.getDocument();
                String copyText = document.getText(blockEnd, blockLength);
                document.insertString(blockStart, copyText, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

