/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrenchgui.panel.TriggerEditPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TriggerTableDriver
implements ITableDriver {
    private Collector collector_;
    private String className_;

    public TriggerTableDriver(Table table) {
        this.setCollector(table);
        this.className_ = Trigger.getClassName();
    }

    public void setCollector(Collector collector) {
        this.collector_ = collector;
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.collector_.size(this.className_)][this.getHeaders().length];
        int row = 0;
        for (Trigger trigger : this.collector_.values(this.className_)) {
            int col = 0;
            matrix[row][col++] = trigger.getName();
            matrix[row][col++] = new Boolean(trigger.getFireOnDeleteFlag());
            matrix[row][col++] = new Boolean(trigger.getFireOnInsertFlag());
            matrix[row][col++] = new Boolean(trigger.getFireOnUpdateFlag());
            matrix[row][col++] = trigger.getExecWhenStr();
            matrix[row][col++] = new Boolean(trigger.getExecBefore());
            matrix[row][col++] = trigger.getForEachStr();
            matrix[row][col++] = new Boolean(trigger.getForEachRow());
            matrix[row][col++] = trigger.getSql();
            matrix[row][col++] = trigger.getName();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = Trigger.getTableHeaders();
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Execute");
        list.add("For Each");
        list.add("ExecuteValue");
        list.add("ForEachValue");
        list.add("SQL");
        list.add("ID");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ExecuteValue");
        list.add("ForEachValue");
        list.add("ID");
        return list;
    }

    public boolean getConfirmRemoveFlag() {
        return false;
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        Trigger newTrigger = null;
        newTrigger = new Trigger((String)data.get("Name"), (Boolean)data.get("On Delete"), (Boolean)data.get("On Insert"), (Boolean)data.get("On Update"), (String)data.get("SQL"), (Boolean)data.get("ExecuteValue"), (Boolean)data.get("ForEachValue"));
        return newTrigger;
    }

    @Override
    public Collector getCollector() {
        return this.collector_;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        return new TriggerEditPanel((Trigger)currentIdf, (Table)this.collector_);
    }

    @Override
    public String getDisplayName() {
        return this.collector_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        return this.collector_.getDisplayPlural(this.className_);
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }
}

