/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.rename.IRenameMgrSource;
import com.harrand.coreclasses.rename.RenameMgr;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.coregui.command.idf.RenameIdf;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.db.SqlReservedWordGui;
import com.harrand.dbwrenchgui.panel.TableAddPanel;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TableTableDriver
implements ITableDriver,
IRenameMgrSource {
    private Schema schema_;
    private String className_;
    private DbUser user_;

    public TableTableDriver(Schema schema, DbUser user) {
        this.schema_ = schema;
        this.className_ = Table.getClassName();
        this.user_ = user;
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.schema_.size(this.className_)][this.getHeaders().length];
        int row = 0;
        for (Table table : this.schema_.values(this.className_)) {
            int col = 0;
            matrix[row][col++] = table.getName();
            matrix[row][col++] = table.getComment();
            matrix[row][col++] = table.getTableOptions();
            matrix[row][col++] = table.getName();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"Name", "Comment", "Table Options", "ID"};
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        return this.getUneditableColumns();
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        String newName = (String)data.get("Name");
        String newComment = (String)data.get("Comment");
        String newTableOpts = (String)data.get("Table Options");
        Table table = (Table)this.schema_.get(this.className_, (String)data.get("ID"));
        String oldName = table.getName();
        ITestResult result = Table.validateName(newName);
        if (!result.getPassed()) {
            throw new Exception(result.getDetail());
        }
        if (!oldName.equals(newName)) {
            SqlReservedWordGui.instance().warnIfReserved(newName);
        }
        if (!newName.equals(oldName)) {
            DataEntryResult rslt;
            ITestResult iTestResult = rslt = oldName.equalsIgnoreCase(newName) ? new DataEntryResult(true) : this.schema_.checkDuplicateName(table.getMapName(), newName);
            if (rslt.getPassed()) {
                RenameIdf cmd = new RenameIdf(this.schema_, table, oldName, newName, App.getCommandChain());
                cmd.setRenameMgr(this.schema_.getDb().getRenameMgr());
                cmd.actionPerformed(new ActionEvent(this, 0, ""));
            } else {
                GuiMessageHelper.showInputErrMsg(null, rslt);
            }
        }
        if (!newComment.equals(table.getComment())) {
            table.setComment(newComment);
        }
        if (!newTableOpts.equals(table.getTableOptions())) {
            table.setTableOptions(newTableOpts);
        }
        return table;
    }

    @Override
    public Collector getCollector() {
        return this.schema_;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        TableAddPanel editor = null;
        if (currentIdf == null) {
            editor = new TableAddPanel(this.schema_, this.user_, null);
        }
        return editor;
    }

    @Override
    public String getDisplayName() {
        return this.schema_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        String schPrefix = this.schema_.getDbHasManySchemas() ? this.schema_.getName() + " " : "";
        return schPrefix + this.schema_.getDisplayPlural(this.className_);
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }

    @Override
    public RenameMgr getRenameMgr() {
        return this.schema_.getDb().getRenameMgr();
    }
}

