/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrenchgui.panel.SequenceEditPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SequenceTableDriver
implements ITableDriver {
    private Schema schema_;
    private String className_;

    public SequenceTableDriver(Schema schema) {
        this.schema_ = schema;
        this.className_ = Sequence.getClassName();
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.schema_.size(this.className_)][this.getHeaders().length];
        int row = 0;
        for (Sequence sequence : this.schema_.values(this.className_)) {
            int col = 0;
            matrix[row][col++] = sequence.getName();
            matrix[row][col++] = new Integer(sequence.getIncrement());
            matrix[row][col++] = sequence.getComment();
            matrix[row][col++] = sequence.getName();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"Name", "Increment", "Comment", "ID"};
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Increment");
        list.add("ID");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        return list;
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        int incr;
        Sequence newSequence = null;
        String nm = (String)data.get("Name");
        ITestResult result = Sequence.checkValues(nm, incr = ((Integer)data.get("Increment")).intValue());
        if (!result.getPassed()) {
            throw new Exception(result.getDetail());
        }
        newSequence = new Sequence(nm, incr, (String)data.get("Comment"));
        return newSequence;
    }

    @Override
    public Collector getCollector() {
        return this.schema_;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        if (currentIdf != null) {
            return new SequenceEditPanel((Sequence)currentIdf);
        }
        return new SequenceEditPanel(this.schema_);
    }

    @Override
    public String getDisplayName() {
        return this.schema_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        String schPrefix = this.schema_.getDbHasManySchemas() ? this.schema_.getName() + " " : "";
        return schPrefix + this.schema_.getDisplayPlural(this.className_);
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }
}

