/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coregui.Icons;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.LogUtil;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public final class PkIconTableCellRenderer
extends DefaultTableCellRenderer {
    private Table table_;
    private ImageIcon notPkIcon = Icons.NULL_ICON;

    public PkIconTableCellRenderer(Table table) {
        this.table_ = table;
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        ImageIcon icon = this.notPkIcon;
        String numberText = "";
        PrimaryKey pk = this.table_.getPrimaryKey();
        int colPos = -1;
        if (pk != null) {
            Set columnKeys = this.table_.getKeys(Column.getClassName());
            ArrayList colNames = new ArrayList(columnKeys);
            if (row < colNames.size()) {
                String colName = (String)colNames.get(row);
                Column column = this.table_.getColumn(colName);
                colPos = column.getPkColumnPos(this.table_);
            } else {
                LogUtil.logMsg("PkIconTblCellRender.row " + row + " beyond colNames.size: " + colNames.size());
            }
        }
        if (colPos > -1) {
            icon = Icons.PK;
            if (colPos > 0) {
                numberText = Integer.toString(colPos);
            }
        }
        this.setIconTextGap(3);
        this.setIcon(icon);
        this.setFont(new Font("Verdana", 0, 9));
        this.setText(numberText);
        return this;
    }
}

