/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.object.Note;
import com.harrand.sketch.panel.NoteEditPanel;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NoteTableDriver
implements ITableDriver {
    private Diagram diagram_;
    private String className_ = Note.getClassName();

    public NoteTableDriver(Diagram diagram) {
        this.diagram_ = diagram;
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.diagram_.size(this.className_)][this.getHeaders().length];
        int row = 0;
        for (Note note : this.diagram_.values(this.className_)) {
            int col = 0;
            matrix[row][col++] = note.getName();
            matrix[row][col++] = note.getText();
            matrix[row][col++] = note.getOrigin().x;
            matrix[row][col++] = note.getOrigin().y;
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"ID", "Text", "X", "Y"};
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        list.add("Text");
        list.add("X");
        list.add("Y");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        list.add("X");
        list.add("Y");
        return list;
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        Note newNote = null;
        String nm = (String)data.get("Name");
        String text = (String)data.get("Text");
        int x = (Integer)data.get("X");
        int y = (Integer)data.get("Y");
        Point origin = new Point(x, y);
        newNote = new Note(text, origin);
        return newNote;
    }

    @Override
    public Collector getCollector() {
        return this.diagram_;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        if (currentIdf != null) {
            return new NoteEditPanel((Note)currentIdf, this.diagram_);
        }
        return new NoteEditPanel(null, this.diagram_);
    }

    @Override
    public String getDisplayName() {
        return this.diagram_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        return this.diagram_.getDisplayPlural(this.className_);
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }
}

