/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.dbwrenchgui.panel.IndexEditPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class IndexTableDriver
implements ITableDriver {
    private Collector collector_;
    private String className_;

    public IndexTableDriver(Table table) {
        this.setCollector(table);
        this.className_ = Index.getClassName();
    }

    public void setCollector(Collector collector) {
        this.collector_ = collector;
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.collector_.size(this.className_)][this.getHeaders().length];
        int row = 0;
        for (Index index : this.collector_.values(this.className_)) {
            int col = 0;
            matrix[row][col++] = index.getName();
            matrix[row][col++] = index.getIndexColumnDdlTextsCSV();
            matrix[row][col++] = new Boolean(index.getUnique());
            matrix[row][col++] = new Boolean(index.getClusteredFlag());
            matrix[row][col++] = index.getName();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"Name", "Columns", "Unique", "Clustered", "ID"};
        return headers;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Columns");
        list.add("ID");
        return list;
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        return list;
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        String id = (String)data.get("ID");
        Index oldIndex = (Index)this.collector_.get(this.className_, id);
        List<IIndexColumn> columnNames = oldIndex.getIndexColumns();
        Index newIndex = null;
        newIndex = new Index((String)data.get("Name"), columnNames, (boolean)((Boolean)data.get("Clustered")), (boolean)((Boolean)data.get("Unique")));
        return newIndex;
    }

    @Override
    public Collector getCollector() {
        return this.collector_;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        return new IndexEditPanel((Index)currentIdf, (Table)this.collector_);
    }

    @Override
    public String getDisplayName() {
        return this.collector_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        return this.collector_.getDisplayPlural(this.className_);
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }
}

