/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.sync;

import com.harrand.coreclasses.dataEntry.CompareResult;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.list.NamedList;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.command.Command;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.notification.NotifyMgr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.compare.DbCompareCtrl;
import com.harrand.dbwrench.script.compare.IDbmsCompareCtrl;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.command.bldr.RevSyncCmdBldr;
import com.harrand.dbwrenchnb.lifecycle.db.DbSaveChecker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RevSyncCtrl
implements IObservable {
    private Database designDb_;
    private Database svrDb_;
    private JdbcConfig cfg_;
    private final DbCompareCtrl dbCompareCtrl_ = new DbCompareCtrl();
    private final BasicObservable observable_ = new BasicObservable();
    private IDbmsCompareCtrl dbmsCompareCtrl_;
    private final DataTypeSvr dataTypeSvr_;
    private final RevSyncCmdBldr cmdBldr_ = new RevSyncCmdBldr();
    private NamedList diffResults_ = new NamedList();
    private int selectedCount_ = 0;
    private int syncedCount_ = 0;
    public static final String OBJ_NM_HDR = "Object Name";
    public static final String OBJ_CLZ_HDR = "Clz";
    public static final String OBJ_TYPE_HDR = "Object Type";
    public static final String SYNCED_HDR = "Synced";
    private final Object[] COLUMN_NAMES = new Object[]{"#", "Clz", "Object Type", "Object Name", "Summary", "Difference (Server Value Listed First)", "Synced"};
    public static final String CLZ = "RevSyncCtrl";

    public RevSyncCtrl(Database designDb) {
        this.setDesignDb(designDb);
        this.dataTypeSvr_ = new DataTypeSvr(App.getUser().getOptionMgr("data.type.opt.mgr"));
    }

    public void setConfig(JdbcConfig cfg) {
        this.cfg_ = cfg;
        this.dbmsCompareCtrl_ = this.cfg_.getDbmsCompareCtrl();
    }

    public void setDesignDb(Database designDb) {
        this.designDb_ = designDb;
    }

    public void setSvrDb(Database svrDb) {
        this.svrDb_ = svrDb;
    }

    public Database getSvrDb() {
        return this.svrDb_;
    }

    public Database getDesignDb() {
        return this.designDb_;
    }

    public ITestResult refresh() {
        new DbSaveChecker().checkAutoSave();
        DataEntryResult result = new DataEntryResult(true);
        this.diffResults_ = this.dbCompareCtrl_.getDiffResults(this.dbmsCompareCtrl_, this.svrDb_, this.designDb_, this.cfg_);
        return result;
    }

    public NamedList getDiffResults() {
        return this.diffResults_;
    }

    public Object[][] getDataMatrix() {
        Object[][] data = new Object[this.diffResults_.size()][this.COLUMN_NAMES.length];
        int row = 0;
        Iterator it = this.diffResults_.iterator();
        while (it.hasNext()) {
            CompareResult result = (CompareResult)it.next();
            int col = 0;
            data[row][col++] = result.getId().toString();
            data[row][col++] = result.getClz();
            data[row][col++] = result.getDisplayClzNm();
            data[row][col++] = result.getObjectName();
            data[row][col++] = result.getSummary();
            data[row][col++] = result.getDetail();
            data[row][col++] = this.getSyncedText(result.getSynced());
            ++row;
        }
        return data;
    }

    public Object[] getColNames() {
        return this.COLUMN_NAMES;
    }

    public ITestResult getIsSyncValid(List diffNms) {
        DataEntryResult result = new DataEntryResult(true);
        ArrayList<ForeignKey> syncFks = new ArrayList<ForeignKey>();
        ArrayList<String> availTblDotNotes = new ArrayList<String>();
        Iterator itDiff = this.diffResults_.iterator();
        while (itDiff.hasNext()) {
            CompareResult diffResult = (CompareResult)itDiff.next();
            String resultNm = diffResult.getName();
            if (!diffNms.contains(resultNm)) continue;
            Identifiable srvIdf = diffResult.getIdfPair().getSvrIdf();
            if (srvIdf != null && srvIdf instanceof ForeignKey) {
                ForeignKey fk = (ForeignKey)srvIdf;
                syncFks.add(fk);
            }
            if (srvIdf == null || !(srvIdf instanceof Table)) continue;
            Table tbl = (Table)srvIdf;
            availTblDotNotes.add(tbl.getDotNote().toLowerCase());
        }
        availTblDotNotes.addAll(this.designDb_.getAllTableDotNotes());
        List availTblDotNotesLc = StrHelper.getLowerCase(availTblDotNotes);
        String prefix = "The following foreign keys have been selected to be synced, \nbut they require the following tables which do not exist in the design database\nnor have these tables been selected to be synced.\nPlease select the rows containing the required tables as well.\n";
        StringBuilder sb = new StringBuilder();
        for (ForeignKey fk : syncFks) {
            String parTblDotNote = fk.getParTbl().getDotNote();
            String parTblDotNoteLc = parTblDotNote.toLowerCase();
            if (availTblDotNotesLc.contains(parTblDotNoteLc)) continue;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            String fkCall = this.svrDb_.getHasManySchemas() ? fk.getDotNote() : fk.getName();
            String parTblCall = this.svrDb_.getHasManySchemas() ? parTblDotNote : fk.getParTbl().getName();
            String lineStr = "Foreign key '" + fkCall + "' requires table '" + parTblCall + "'";
            sb.append(lineStr);
        }
        if (sb.length() > 0) {
            String fullMsg = prefix + "\n" + sb.toString();
            result = new DataEntryResult(false, "Foreign Key Sync Warning", fullMsg);
        }
        return result;
    }

    public List syncDb(List diffNms) {
        ArrayList<String> syncedNms = new ArrayList<String>();
        this.selectedCount_ = diffNms.size();
        this.syncedCount_ = 0;
        NotifyMgr notifyMgr = this.designDb_.getNotifyMgr();
        notifyMgr.setDbEnabled(false);
        for (String compareNm : diffNms) {
            CompareResult compare = (CompareResult)this.diffResults_.get(compareNm);
            Command cmd = this.cmdBldr_.getCmd(compare);
            cmd.actionPerformed(null);
            syncedNms.add(compare.getName());
            compare.setSynced(true);
            ++this.syncedCount_;
            this.notifyObservers(null);
        }
        notifyMgr.setDbEnabled(true);
        notifyMgr.updateDb();
        this.dataTypeSvr_.autoEnableDbType(this.designDb_);
        return syncedNms;
    }

    public String getSyncedCountMsg() {
        return "Synced: " + this.syncedCount_ + "/" + this.selectedCount_ + "...";
    }

    private String getSyncedText(boolean synced) {
        if (synced) {
            return StrHelper.YES_STR;
        }
        return StrHelper.NO_STR;
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

