/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.sub.editor.key;

import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.keyStroke.IKeyStrokeActionMapper;
import com.harrand.dbwrenchgui.option.AbbreviationCtrl;
import com.harrand.dbwrenchgui.sub.editor.key.KeyStrokeActionCtrl;
import com.harrand.dbwrenchgui.text.action.EditorColorCodeAction;
import com.harrand.dbwrenchgui.text.undo.UndoableEditListenerImpl;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Utilities;

public final class DbwEditorKeyListener
implements KeyListener {
    private final KeyStrokeActionCtrl keyStrokeActionCtrl = new KeyStrokeActionCtrl();
    private final JEditorPane editorPane;
    private final UndoableEditListenerImpl undoableEditListener;
    private final AbbreviationCtrl abbrCtrl_;
    private final IObservable observable;
    private final EditorColorCodeAction editorColorCodeAction;
    private boolean colorCodingEnabled;

    public DbwEditorKeyListener(JEditorPane editorPane, UndoableEditListenerImpl undoableEditListenerImpl, IObservable observable) {
        this.editorPane = editorPane;
        this.undoableEditListener = undoableEditListenerImpl;
        this.abbrCtrl_ = new AbbreviationCtrl(editorPane);
        this.observable = observable;
        this.editorColorCodeAction = new EditorColorCodeAction(this.editorPane, this.undoableEditListener);
        this.setKeyListener();
    }

    private void setKeyListener() {
        this.editorPane.addKeyListener(this);
    }

    public void addKeyStrokeActionMapper(IKeyStrokeActionMapper keyStrokeActionMapper) {
        this.keyStrokeActionCtrl.addKeyStrokeActionMapper(keyStrokeActionMapper);
    }

    public void setColorCodingEnabled(boolean enabled) {
        this.colorCodingEnabled = enabled;
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.keyStrokeActionCtrl.checkInvokeAction(event);
        this.abbrCtrl_.checkAbbreviationHit(event);
        if (this.colorCodingEnabled) {
            this.doColorCode();
        }
    }

    private void doColorCode() {
        this.editorColorCodeAction.actionPerformed(null);
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        this.observable.notifyObservers(new UpdateChain());
    }

    public void logStartEnd() {
        try {
            int start = Utilities.getRowStart(this.editorPane, 0);
            int n = Utilities.getRowEnd(this.editorPane, 0);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

