/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.sub;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.option.UserOptionMgr;
import com.harrand.coregui.undo.BasicUndoEditListener;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.option.AbbreviationCtrl;
import com.harrand.util.LogUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.StatusBar;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

@Deprecated
public class NbEditPanel
extends JPanel
implements IObservable,
IObserver {
    private NbEditorDocument doc_;
    private DbUser user_ = App.getUser();
    private UserOptionMgr editOptMgr_;
    private AbbreviationCtrl abbrCtrl_;
    private UndoRedo.Manager undoRedoMgr_ = new UndoRedo.Manager();
    private BasicUndoEditListener undoEditListener_ = new BasicUndoEditListener();
    private JEditorPane editorPane_ = new JEditorPane();
    private IObservable observable_ = new BasicObservable();
    private JPanel editorComponent_;
    private JTextComponent txtComp_;
    private JToolBar toolBar_;
    private StatusBar statusBar_;
    private boolean addBorder_;
    public static final String MIME_SQL = "text/x-sql";
    public static final String MIME_PLAIN = "text/plain";
    public static final String MIME_SJ = "text/x-sj";
    public static final String MIME_DBW_SQL = "text/x-dbwsql";

    public NbEditPanel(boolean addBorder) {
        this.addBorder_ = addBorder;
        this.editOptMgr_ = (UserOptionMgr)this.user_.getOptionMgr("editor.option.mgr");
        this.editOptMgr_.addObserver(this);
        this.buildPanel();
        this.addKeyListener();
    }

    public void setText(String text) {
        this.editorPane_.setText(text);
        this.txtComp_.setCaretPosition(0);
        this.setUndoRedoListener();
    }

    public String getText() {
        return this.editorPane_.getText();
    }

    public String getSelectedText() {
        return this.editorPane_.getSelectedText();
    }

    public JTextComponent getTextComponenet() {
        return this.txtComp_;
    }

    public void setEditable(boolean editable) {
        this.txtComp_.setEditable(editable);
        Color backColor = editable ? Color.WHITE : Colors.getGrayUltraLight();
        this.txtComp_.setBackground(backColor);
        this.editorPane_.setBackground(backColor);
        this.txtComp_.setOpaque(true);
        this.editorPane_.setOpaque(true);
    }

    public void clear() {
        this.setText("");
    }

    public UndoRedo getUndoRedoMgr() {
        return this.undoRedoMgr_;
    }

    public void setTCActions(TopComponent tc) {
        this.setTCAction(tc, "copy-to-clipboard", "copy-to-clipboard");
        this.setTCAction(tc, "cut-to-clipboard", "cut-to-clipboard");
        this.setTCAction(tc, "paste-from-clipboard", "paste-from-clipboard");
        this.setTCAction(tc, "delete-next", "delete");
        this.setTCAction(tc, "replace", "org.openide.actions.ReplaceAction");
        this.setTCAction(tc, "incremental-search-forward", "org.openide.actions.FindAction");
    }

    private void buildPanel() {
        this.initPanel();
        this.layoutPanel();
        this.modifyToolbar();
        this.modifyActions();
    }

    private void initPanelDirect() {
    }

    private void initPanelTest() {
        EditorKit kit = CloneableEditorSupport.getEditorKit((String)MIME_SQL);
        JEditorPane jep = new JEditorPane();
        jep.setEditorKit(kit);
        GuiMessageHelper.showWarningMsg(null, "jep test", "NbEditPanel.editorKit: " + kit.getClass());
    }

    private void initPanel() {
        StyledEditorKit editorKit = (StyledEditorKit)CloneableEditorSupport.getEditorKit((String)MIME_PLAIN);
        this.editorPane_.setEditorKit(editorKit);
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.editorPane_);
        this.editorComponent_ = (JPanel)editorUI.getExtComponent();
        this.txtComp_ = editorUI.getComponent();
        this.toolBar_ = editorUI.getToolBarComponent();
        this.statusBar_ = editorUI.getStatusBar();
        this.doc_ = (NbEditorDocument)this.editorPane_.getDocument();
        this.setCodeStylePrefs();
        this.abbrCtrl_ = new AbbreviationCtrl(this.txtComp_);
        Font oldFont = this.txtComp_.getFont();
        StyledEditorKit.FontSizeAction fontSizeAction = new StyledEditorKit.FontSizeAction("font8", 8);
        for (Action action : editorKit.getActions()) {
            LogUtil.logMsg("nbeditPanel.action: " + action.toString());
            LogUtil.logMsg("nbeditPanel.action.name: " + action.getValue("name"));
        }
        StyledEditorKit.ForegroundAction foreColorAction = new StyledEditorKit.ForegroundAction("redColor", Color.red);
        foreColorAction.actionPerformed(null);
        this.toolBar_.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                NbEditPanel.this.modifyToolbar();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    private void setUndoRedoListener() {
        this.doc_.addUndoableEditListener((UndoableEditListener)this.undoEditListener_);
    }

    private void modifyToolbar() {
        if (this.toolBar_.isVisible()) {
            this.addCommentBtns();
        }
        this.initUndoRedoBtns();
    }

    private void removeSQLCmdBtns() {
        for (int i = 0; i < 6; ++i) {
            this.toolBar_.remove(0);
        }
    }

    private void removeMacroBtns() {
        int MACRO_REC_IDX = 15;
        int MACRO_PLAY_IDX = 16;
        try {
            this.toolBar_.remove(16);
            this.toolBar_.remove(15);
        }
        catch (Exception ex) {
            LogUtil.logMsg("NbEditPanel.could not remove macro buttons.");
        }
    }

    private void addCommentBtns() {
        int COMMENT_SUBSTRACT = 2;
        boolean UNCOMMENT_SUBSTRACT = true;
        Component[] comps = this.toolBar_.getComponents();
        KeyStroke stroke = KeyStroke.getKeyStroke(47, 2, false);
        String tooltip = "Comment (Ctrl-Backslash)";
        this.switchButtonAction(comps, comps.length - 2, (Action)new ExtKit.CommentAction("--"), stroke, tooltip);
        stroke = KeyStroke.getKeyStroke(46, 2, false);
        tooltip = "Uncomment (Ctrl-Period)";
        this.switchButtonAction(comps, comps.length - 1, (Action)new ExtKit.UncommentAction("--"), stroke, tooltip);
    }

    private void initUndoRedoBtns() {
        Action undoAction = this.undoEditListener_.getUndoAction();
        Action redoAction = this.undoEditListener_.getRedoAction();
        this.txtComp_.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "redoAction");
        this.txtComp_.getActionMap().put("redoAction", redoAction);
        this.txtComp_.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "undoAction");
        this.txtComp_.getActionMap().put("undoAction", undoAction);
        this.toolBar_.addSeparator();
        this.toolBar_.add(undoAction);
        this.toolBar_.add(redoAction);
    }

    private void switchButtonAction(Component[] comps, int btnIndex, Action newAction, KeyStroke hotkeyStroke, String tooltip) {
        Component comp;
        if (btnIndex >= 0 && btnIndex < comps.length && (comp = comps[btnIndex]) instanceof JButton) {
            JButton btn = (JButton)comp;
            Icon icon = btn.getIcon();
            btn.setAction(newAction);
            btn.setIcon(icon);
            btn.setToolTipText(tooltip);
        }
        this.txtComp_.getInputMap().put(hotkeyStroke, tooltip);
        this.txtComp_.getActionMap().put(tooltip, newAction);
    }

    private void modifyActions() {
        this.listActionMapDisp();
    }

    private void listActionMapDisp() {
        this.listActionMap(this.txtComp_);
        this.listActionMap(this.editorComponent_);
        this.listActionMap(this.editorPane_);
    }

    private void listActionMap(JComponent comp) {
        ActionMap actionMap = comp.getActionMap();
        Object[] keys = actionMap.keys();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                Object object = keys[i];
            }
        }
    }

    private void setCodeStylePrefs() {
        int indent = this.editOptMgr_.getIntValue("editor.indent");
        Preferences prefs = CodeStylePreferences.get((Document)this.doc_).getPreferences();
        prefs.putInt("indent-shift-width", indent);
        prefs.putInt("spaces-per-tab", indent);
        prefs.putBoolean("expand-tabs", true);
    }

    private void setTCAction(TopComponent tc, String localActionNm, String sysActionNm) {
        Action localAction = this.editorPane_.getActionMap().get(localActionNm);
        if (localAction != null) {
            localAction.setEnabled(true);
            tc.getActionMap().put(sysActionNm, localAction);
        }
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolBar_, "North");
        this.add((Component)this.editorComponent_, "Center");
        if (this.addBorder_) {
            Border compBorder = BorderFactory.createLineBorder(Colors.getBlueLightNb());
            this.editorComponent_.setBorder(compBorder);
        }
        Border panelBorder = BorderFactory.createEmptyBorder(5, 0, 0, 0);
        this.setBorder(panelBorder);
    }

    private void addKeyListener() {
        this.editorPane_.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                NbEditPanel.this.abbrCtrl_.checkAbbreviationHit(e);
                NbEditPanel.this.notifyObservers(null);
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void update(UpdateChain chain) {
        this.setCodeStylePrefs();
    }

    public static boolean checkInitFonts() {
        MimePath mimePath = MimePath.parse((String)MIME_SQL);
        Lookup lookup = MimeLookup.getLookup((MimePath)mimePath);
        FontColorSettings fcs = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        AttributeSet attribs = fcs.getTokenFontColors("default");
        Object objSize = attribs.getAttribute(StyleConstants.FontSize);
        LogUtil.logMsg("NbEditPanel.objSize: " + objSize);
        boolean initFonts = true;
        Integer objSizeInt = Integer.parseInt(objSize.toString());
        return initFonts;
    }

    private void updateFont() {
        Font baseFont_ = new Font("Monospaced", 0, 8);
        this.editorPane_.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.editorPane_.setFont(baseFont_);
    }
}

