/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.sub;

import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.helper.GuiHelper;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class FkPairLinkPanel
extends JPanel
implements IObservable {
    private List pairs_;
    private String lastParentLinkColNm_;
    private JLabel lblPrompt_ = new JLabel("Draw Link Using");
    private JComboBox cboLinkPair_;
    private JTextPane txtHelp_ = new JTextPane();
    private BasicObservable observable_ = new BasicObservable();
    private ActionListener lisCombo_;
    public static final String CLAZZ = "FkPairLinkPanel";

    public FkPairLinkPanel(List pairs, String parentLinkColNm) {
        this.pairs_ = pairs;
        this.buildControls();
        this.setupGui();
        this.setSelectedParentLinkColNm(parentLinkColNm);
        this.lastParentLinkColNm_ = parentLinkColNm;
    }

    public void setPairs(List pairs) {
        String oldPair = (String)this.cboLinkPair_.getSelectedItem();
        this.cboLinkPair_.removeActionListener(this.lisCombo_);
        this.cboLinkPair_.removeAllItems();
        Iterator it = pairs.iterator();
        while (it.hasNext()) {
            this.cboLinkPair_.addItem((String)it.next());
        }
        if (oldPair != null) {
            this.cboLinkPair_.setSelectedItem(oldPair);
        }
        if (pairs.size() == 0) {
            this.cboLinkPair_.setPrototypeDisplayValue("xxxxxxxxx");
        } else {
            this.cboLinkPair_.setPrototypeDisplayValue(null);
        }
        this.cboLinkPair_.addActionListener(this.lisCombo_);
    }

    public void setSelectedParentLinkColNm(String parentLinkColNm) {
        this.cboLinkPair_.removeActionListener(this.lisCombo_);
        int itemCount = this.cboLinkPair_.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            String pairStr = (String)this.cboLinkPair_.getItemAt(i);
            String[] strs = pairStr.split("/");
            String parentNm = strs[1];
            if (!parentNm.equalsIgnoreCase(parentLinkColNm)) continue;
            this.cboLinkPair_.setSelectedIndex(i);
            this.cboLinkPair_.addActionListener(this.lisCombo_);
            break;
        }
        this.cboLinkPair_.addActionListener(this.lisCombo_);
    }

    public String getSelectedParentLinkColNm() {
        String selectedParent = null;
        if (this.cboLinkPair_.getItemCount() > 0) {
            String pairStr = (String)this.cboLinkPair_.getSelectedItem();
            String[] strs = pairStr.split("/");
            selectedParent = strs[1];
        }
        return selectedParent;
    }

    private void setupGui() {
        this.layoutComponents();
        this.setNames();
        this.addListeners();
    }

    private void buildControls() {
        this.txtHelp_.setText("If this foreign key has multiple column pairs, specify which pair to use to draw the link on the diagram.");
        Color bkg = this.getBackground();
        Color dupColor = new Color(bkg.getRed(), bkg.getGreen(), bkg.getBlue());
        this.txtHelp_.setBackground(dupColor);
        this.txtHelp_.setEditable(false);
        this.txtHelp_.setForeground(Color.BLACK);
        Vector v = new Vector(this.pairs_);
        this.cboLinkPair_ = new JComboBox(v);
    }

    private void layoutComponents() {
        GuiHelper.setTitledBorderBuffered(this, "Draw Link Pair");
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPairFixed(this.lblPrompt_, this.cboLinkPair_, gbc, this, row++);
        GuiHelper.addGridbagPair(new JLabel(), this.txtHelp_, gbc, this, row++);
    }

    private void setNames() {
        this.setName(CLAZZ);
        this.cboLinkPair_.setName("cboLinkPair");
    }

    private void addListeners() {
        this.lisCombo_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FkPairLinkPanel.this.notifyChanged();
            }
        };
        this.cboLinkPair_.addActionListener(this.lisCombo_);
    }

    private void notifyChanged() {
        String newParentLinkColNm;
        if (this.cboLinkPair_.getItemCount() > 0 && !(newParentLinkColNm = this.getSelectedParentLinkColNm()).equals(this.lastParentLinkColNm_)) {
            this.notifyObservers(new UpdateChain(this));
        }
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

