/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.security;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.security.BasicCodeMgr;
import com.harrand.coreclasses.security.Code;
import com.harrand.coreclasses.security.ICodeMgr;
import com.harrand.coreclasses.security.ICodeStore;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.security.CodeInfoPanel;
import com.harrand.dbwrenchgui.security.CodeWarningPanel;
import com.harrand.util.ResMgr;
import java.awt.Container;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;

public final class SwingCodeMgr
implements ICodeMgr,
IObservable {
    private static SwingCodeMgr instance__ = new SwingCodeMgr(null, 1);
    private BasicCodeMgr basicCodeMgr_;
    private ICodeStore codeStore_;
    private List codes_;
    private Frame parent_;
    private boolean showLicensePanel_;
    private BasicObservable observable_ = new BasicObservable();
    public static final int REMINDER_DAYS = 4;
    public static final int TRIAL_DAYS = 7;

    private SwingCodeMgr(Frame parent, int majorId) {
        this.parent_ = parent;
        this.loadCodeList();
    }

    public static SwingCodeMgr getInstance() {
        return instance__;
    }

    public void setCodeStore(ICodeStore codeStore) {
        this.codeStore_ = codeStore;
        this.basicCodeMgr_ = new BasicCodeMgr(this.codes_, this.codeStore_.getInstallCal(), 7);
    }

    public boolean getShowLicensePanel() {
        return this.showLicensePanel_;
    }

    private ITestResult showInfoDlg(Code code) {
        CodeInfoPanel codePanel = new CodeInfoPanel(this, this.codeStore_, false);
        JDialog dlg = new JDialog(this.parent_, true);
        Container cp = dlg.getContentPane();
        cp.add(codePanel);
        codePanel.setParentContainer(dlg);
        GuiHelper.locateDialog(dlg, codePanel.getPreferredBounds());
        dlg.setTitle(ResMgr.getRes("license.expired.title"));
        dlg.setVisible(true);
        Code codeOut = this.codeStore_.getCode();
        return this.validateCode(codeOut);
    }

    private void showRemindMsg(int daysRemain) {
        CodeWarningPanel warnPanel = new CodeWarningPanel(daysRemain);
        JDialog dlg = new JDialog(this.parent_, true);
        Container cp = dlg.getContentPane();
        cp.add(warnPanel);
        warnPanel.setParentContainer(dlg);
        GuiHelper.locateDialog(dlg, warnPanel.getPreferredBounds());
        dlg.setTitle(warnPanel.getTitle());
        dlg.setVisible(true);
        this.showLicensePanel_ = warnPanel.getShowLicensePanelAfter();
    }

    private void loadCodeList() {
        this.codes_ = new ArrayList();
        this.codes_.add("15248624");
        this.codes_.add("78549258");
        this.codes_.add("86974826");
        this.codes_.add("95867458");
        this.codes_.add("68573588");
        this.codes_.add("94578623");
        this.codes_.add("24868538");
        this.codes_.add("36487598");
        this.codes_.add("82154207");
        this.codes_.add("08594784");
        this.codes_.add("67841025");
        this.codes_.add("90847152");
        this.codes_.add("15214022");
        this.codes_.add("88757204");
        this.codes_.add("94811577");
        this.codes_.add("78459780");
        this.codes_.add("12548712");
        this.codes_.add("15842654");
        this.codes_.add("77485175");
        this.codes_.add("95682642");
        this.codes_.add("14175482");
        this.codes_.add("15243516");
        this.codes_.add("95867842");
        this.codes_.add("95868111");
        this.codes_.add("05174899");
        this.codes_.add("01245842");
        this.codes_.add("99848511");
        this.codes_.add("21311595");
        this.codes_.add("75735551");
        this.codes_.add("64648849");
        this.codes_.add("44857611");
        this.codes_.add("31157944");
        this.codes_.add("44581197");
        this.codes_.add("44978484");
        this.codes_.add("67669948");
        this.codes_.add("55481174");
        this.codes_.add("99487744");
        this.codes_.add("33446948");
        this.codes_.add("55884847");
        this.codes_.add("84857695");
        this.codes_.add("25487689");
        this.codes_.add("34587695");
        this.codes_.add("47845112");
        this.codes_.add("56987442");
        this.codes_.add("69985721");
        this.codes_.add("78529634");
        this.codes_.add("88475112");
        this.codes_.add("97865455");
        this.codes_.add("01524777");
        this.codes_.add("16584237");
        this.codes_.add("26699558");
        this.codes_.add("34477885");
        this.codes_.add("41593578");
        this.codes_.add("56969894");
        this.codes_.add("65848777");
        this.codes_.add("71211451");
        this.codes_.add("85564588");
        this.codes_.add("91253358");
        this.codes_.add("01477558");
        this.codes_.add("83412544");
        this.codes_.add("13424866");
        this.codes_.add("33499458");
        this.codes_.add("63484575");
        this.codes_.add("23458469");
        this.codes_.add("93412124");
        this.codes_.add("73458511");
        this.codes_.add("63428120");
        this.codes_.add("73481542");
        this.codes_.add("23422011");
        this.codes_.add("43484115");
        this.codes_.add("63487775");
        this.codes_.add("53464211");
        this.codes_.add("13400512");
        this.codes_.add("33481255");
        this.codes_.add("63415299");
        this.codes_.add("23410548");
        this.codes_.add("93478450");
        this.codes_.add("43487651");
        this.codes_.add("13484602");
        this.codes_.add("77845723");
        this.codes_.add("95863345");
        this.codes_.add("95847521");
        this.codes_.add("02454369");
        this.codes_.add("48025173");
        this.codes_.add("95135740");
        this.codes_.add("13025844");
        this.codes_.add("84762510");
        this.codes_.add("45845724");
        this.codes_.add("66584871");
        this.codes_.add("50628901");
        this.codes_.add("84857223");
        this.codes_.add("15847623");
        this.codes_.add("44685811");
        this.codes_.add("45695847");
        this.codes_.add("35261845");
        this.codes_.add("77848661");
        this.codes_.add("58422315");
        this.codes_.add("65847712");
        this.codes_.add("19458192");
        this.codes_.add("94587624");
        this.codes_.add("82486731");
        this.codes_.add("50150488");
        this.codes_.add("15699584");
        this.codes_.add("65483237");
        this.codes_.add("46819735");
        this.codes_.add("80480658");
        this.codes_.add("84752566");
        this.codes_.add("11753486");
        this.codes_.add("95864228");
        this.codes_.add("68562401");
        this.codes_.add("35236835");
        this.codes_.add("68954732");
        this.codes_.add("75848692");
        this.codes_.add("84561253");
        this.codes_.add("45869582");
        this.codes_.add("58102501");
        this.codes_.add("61020339");
        this.codes_.add("20135884");
        this.codes_.add("76481994");
        this.codes_.add("48755814");
        this.codes_.add("26593151");
        this.codes_.add("15248752");
        this.codes_.add("59687433");
        this.codes_.add("55487596");
        this.codes_.add("69125411");
        this.codes_.add("64587334");
        this.codes_.add("99586413");
        this.codes_.add("54682857");
        this.codes_.add("58259964");
        this.codes_.add("48487588");
        this.codes_.add("12313145");
        this.codes_.add("65668859");
        this.codes_.add("25251141");
        this.codes_.add("33625933");
        this.codes_.add("45848577");
        this.codes_.add("95822458");
        this.codes_.add("48758441");
        this.codes_.add("68594587");
        this.codes_.add("58711252");
        this.codes_.add("48457469");
        this.codes_.add("85472288");
        this.codes_.add("65856223");
        this.codes_.add("95869915");
        this.codes_.add("77584772");
        this.codes_.add("33253314");
        this.codes_.add("95858224");
        this.codes_.add("15528556");
        this.codes_.add("58477586");
        this.codes_.add("45484425");
        this.codes_.add("65958869");
        this.codes_.add("15447584");
        this.codes_.add("65825855");
        this.codes_.add("48575899");
        this.codes_.add("88594858");
        this.codes_.add("36263655");
        this.codes_.add("75847758");
        this.codes_.add("95848444");
        this.codes_.add("77584855");
        this.codes_.add("48758115");
        this.codes_.add("11254335");
        this.codes_.add("18279134");
        this.codes_.add("45781355");
        this.codes_.add("26154889");
        this.codes_.add("98657742");
        this.codes_.add("59683221");
        this.codes_.add("15427889");
        this.codes_.add("15455686");
        this.codes_.add("55478456");
        this.codes_.add("95683362");
        this.codes_.add("48596587");
        this.codes_.add("76596335");
        this.codes_.add("59683225");
        this.codes_.add("78994568");
        this.codes_.add("56488568");
        this.codes_.add("35268894");
        this.codes_.add("75846644");
        this.codes_.add("65668995");
        this.codes_.add("78445848");
        this.codes_.add("12544588");
        this.codes_.add("78994577");
        this.codes_.add("84571428");
        this.codes_.add("98645725");
        this.codes_.add("14357845");
        this.codes_.add("65849757");
        this.codes_.add("15245867");
        this.codes_.add("97845862");
        this.codes_.add("65482583");
        this.codes_.add("48572515");
        this.codes_.add("14251885");
        this.codes_.add("45288153");
        this.codes_.add("84576678");
        this.codes_.add("12457841");
        this.codes_.add("28145826");
        this.codes_.add("69369699");
        this.codes_.add("58258842");
        this.codes_.add("47147111");
        this.codes_.add("42411755");
        this.codes_.add("95864321");
        this.codes_.add("74837882");
        this.codes_.add("98992881");
        this.codes_.add("90290001");
        this.codes_.add("76888276");
        this.codes_.add("54357772");
        this.codes_.add("12876411");
        this.codes_.add("27836382");
        this.codes_.add("34726113");
        this.codes_.add("58731922");
        this.codes_.add("09433922");
        this.codes_.add("87462274");
        this.codes_.add("87444324");
        this.codes_.add("76283772");
        this.codes_.add("98923388");
        this.codes_.add("98767332");
        this.codes_.add("65746443");
        this.codes_.add("56474332");
        this.codes_.add("84736643");
        this.codes_.add("23984722");
        this.codes_.add("75893234");
        this.codes_.add("81236829");
        this.codes_.add("56382931");
        this.codes_.add("12334922");
        this.codes_.add("97923422");
        this.codes_.add("98723498");
        this.codes_.add("65732399");
        this.codes_.add("12796292");
        this.codes_.add("97289367");
        this.codes_.add("47837892");
        this.codes_.add("57837429");
        this.codes_.add("56873431");
        this.codes_.add("79877896");
        this.codes_.add("09879873");
        this.codes_.add("78374533");
        this.codes_.add("12839722");
        this.codes_.add("12914234");
        this.codes_.add("98768723");
        this.codes_.add("78329831");
        this.codes_.add("91237394");
        this.codes_.add("92368395");
        this.codes_.add("73829615");
        this.codes_.add("92836829");
        this.codes_.add("98792388");
        this.codes_.add("90173926");
        this.codes_.add("26389561");
        this.codes_.add("16723602");
        this.codes_.add("79340379");
        this.codes_.add("65329103");
        this.codes_.add("75637892");
        this.codes_.add("09872619");
        this.codes_.add("74639283");
        this.codes_.add("98373948");
        this.codes_.add("67847239");
        this.codes_.add("54783921");
        this.codes_.add("57973692");
        this.codes_.add("09877432");
        this.codes_.add("79874639");
        this.codes_.add("54324533");
        this.codes_.add("09383734");
        this.codes_.add("68746398");
        this.codes_.add("43234543");
        this.codes_.add("87287246");
        this.codes_.add("43597883");
        this.codes_.add("82362916");
        this.codes_.add("28371909");
        this.codes_.add("12978236");
        this.codes_.add("73829163");
        this.codes_.add("56832202");
        this.codes_.add("84560213");
        this.codes_.add("86912938");
        this.codes_.add("23861036");
        this.codes_.add("98746291");
        this.codes_.add("64628913");
        this.codes_.add("01738926");
        this.codes_.add("19362003");
        this.codes_.add("48879311");
        this.codes_.add("87478313");
        this.codes_.add("67838687");
        this.codes_.add("23429832");
        this.codes_.add("67563521");
        this.codes_.add("09273813");
        this.codes_.add("79874639");
        this.codes_.add("98746201");
        this.codes_.add("48973011");
        this.codes_.add("68763922");
        this.codes_.add("09887494");
        this.codes_.add("89792723");
        this.codes_.add("79867464");
        this.codes_.add("98678589");
        this.codes_.add("12397332");
        this.codes_.add("43231908");
        this.codes_.add("78962230");
        this.codes_.add("09879389");
        this.codes_.add("89790287");
        this.codes_.add("67850021");
        this.codes_.add("08979468");
        this.codes_.add("34352313");
        this.codes_.add("34532245");
        this.codes_.add("09879847");
        this.codes_.add("23423552");
        this.codes_.add("79079348");
        this.codes_.add("12341229");
        this.codes_.add("09874938");
        this.codes_.add("78968300");
        this.codes_.add("23423993");
        this.codes_.add("12100993");
        this.codes_.add("78974900");
        this.codes_.add("15673002");
        this.codes_.add("89870344");
        this.codes_.add("79803422");
        this.codes_.add("80282933");
        this.codes_.add("45311334");
        this.codes_.add("89007034");
        this.codes_.add("23786000");
        this.codes_.add("07803441");
        this.codes_.add("23423990");
        this.codes_.add("08789723");
        this.codes_.add("43522342");
        this.codes_.add("37281918");
        this.codes_.add("49783820");
        this.codes_.add("08381220");
        this.codes_.add("47629202");
        this.codes_.add("09484922");
        this.codes_.add("58474637");
        this.codes_.add("12299029");
        this.codes_.add("87949492");
        this.codes_.add("85748493");
        this.codes_.add("39889923");
        this.codes_.add("40895849");
        this.codes_.add("39377923");
        this.codes_.add("43523221");
        this.codes_.add("09790872");
        this.codes_.add("43522897");
        this.codes_.add("87972932");
        this.codes_.add("98029233");
        this.codes_.add("23334321");
        this.codes_.add("89879790");
        this.codes_.add("67786968");
        this.codes_.add("34235323");
        this.codes_.add("35322233");
        this.codes_.add("54543233");
        this.codes_.add("79887110");
        this.codes_.add("15243568");
        this.codes_.add("08847755");
        this.codes_.add("85457695");
        this.codes_.add("58694758");
        this.codes_.add("45857695");
        this.codes_.add("16635584");
        this.codes_.add("26647875");
        this.codes_.add("35626534");
        this.codes_.add("46965847");
        this.codes_.add("54867771");
        this.codes_.add("84757471");
        this.codes_.add("20154835");
        this.codes_.add("31542705");
        this.codes_.add("61820475");
        this.codes_.add("95124355");
        this.codes_.add("65182205");
        this.codes_.add("54817571");
        this.codes_.add("65235264");
        this.codes_.add("98568584");
        this.codes_.add("10241524");
        this.codes_.add("48755855");
        this.codes_.add("95869985");
        this.codes_.add("75865956");
        this.codes_.add("36253999");
        this.codes_.add("48577859");
        this.codes_.add("25114255");
        this.codes_.add("84578596");
        this.codes_.add("26253585");
        this.codes_.add("69596684");
        this.codes_.add("48571132");
        this.codes_.add("47392918");
        this.codes_.add("49583119");
        this.codes_.add("47263839");
        this.codes_.add("12837290");
        this.codes_.add("90873729");
        this.codes_.add("23947923");
        this.codes_.add("79278303");
        this.codes_.add("12307098");
        this.codes_.add("34579876");
        this.codes_.add("23423222");
        this.codes_.add("62382093");
        this.codes_.add("84729992");
        this.codes_.add("89748392");
        this.codes_.add("62378193");
        this.codes_.add("64830023");
        this.codes_.add("98749822");
        this.codes_.add("19387083");
        this.codes_.add("38267902");
        this.codes_.add("57830690");
        this.codes_.add("67862922");
        this.codes_.add("70723422");
        this.codes_.add("13470978");
    }

    @Override
    public ITestResult checkValid(Code code) {
        ITestResult result = null;
        int validateId = this.basicCodeMgr_.getValidateId(code);
        switch (validateId) {
            case 0: {
                result = this.showInfoDlg(code);
                break;
            }
            case 1: {
                int daysRemain = this.basicCodeMgr_.getTrialDaysRemaining();
                if (daysRemain <= 4) {
                    this.showRemindMsg(daysRemain);
                }
                result = new DataEntryResult(true);
                break;
            }
            case 2: {
                result = new DataEntryResult(true);
                break;
            }
            default: {
                StrHelper.throwProgExcept("Unsupported validateId: " + validateId);
            }
        }
        this.notifyObservers(new UpdateChain(code));
        return result;
    }

    @Override
    public String getValidateDesc(Code code, int id) {
        return this.basicCodeMgr_.getValidateDesc(code, id);
    }

    @Override
    public int getValidateId(Code code) {
        return this.basicCodeMgr_.getValidateId(code);
    }

    @Override
    public ITestResult validateCode(Code code) {
        return this.basicCodeMgr_.validateCode(code);
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

