/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.print.panel;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrenchgui.print.PreviewTile;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;

public class TilePanel
extends JPanel {
    private BufferedImage buffImg_ = GuiHelper.getBufferedImage(1, 1, true);
    private static final int MARGIN = 10;
    private static final Color BACK_COLOR = Color.WHITE;

    public TilePanel() {
        this.init();
    }

    public void refresh(List<PreviewTile> tiles) {
        this.updateBuffImgSz(tiles);
        Graphics2D buffImgGfx = (Graphics2D)this.buffImg_.getGraphics();
        this.fillBackColor(buffImgGfx);
        for (PreviewTile tile : tiles) {
            if (buffImgGfx == null) continue;
            buffImgGfx.drawImage((Image)tile.getImage(), tile.getLocation().x, tile.getLocation().y, null);
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void fillBackColor(Graphics2D buffImgGfx) {
        GuiHelper.setBackColor(buffImgGfx, BACK_COLOR, this.buffImg_.getWidth(), this.buffImg_.getHeight());
    }

    private void init() {
        this.setOpaque(true);
        this.setBackground(BACK_COLOR);
    }

    private void updateBuffImgSz(List<PreviewTile> tiles) {
        Dimension sz = this.calcImageSz(tiles);
        this.buffImg_ = GuiHelper.getBufferedImage(sz.width, sz.height, true);
    }

    private Dimension calcImageSz(List<PreviewTile> tiles) {
        int maxX = 0;
        int maxY = 0;
        for (PreviewTile tile : tiles) {
            int tileWidth = tile.getImage().getWidth();
            int tileHeight = tile.getImage().getHeight();
            int currentX = tile.getLocation().x + tileWidth;
            int currentY = tile.getLocation().y + tileHeight;
            maxX = Math.max(maxX, currentX);
            maxY = Math.max(maxY, currentY);
        }
        Dimension imgSz = new Dimension(maxX + 10, maxY + 10);
        return imgSz;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.buffImg_, 0, 0, this);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = new Dimension(this.buffImg_.getWidth(), this.buffImg_.getHeight());
        return preferredSize;
    }
}

