/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.print.panel;

import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrenchgui.print.ctrl.PrintPreviewCtrl;
import com.harrand.dbwrenchgui.print.panel.TilePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class PrintPreviewPanel
extends JPanel
implements IObserver {
    private PrintPreviewCtrl previewCtrl_;
    private JButton btnRefresh_ = new JButton("Refresh Print Preview");
    private TilePanel tilePanel_ = new TilePanel();
    public static final String REFRESH_TXT = "Refresh Print Preview";

    public PrintPreviewPanel(PrintPreviewCtrl printCtrl) {
        this.previewCtrl_ = printCtrl;
        this.previewCtrl_.addObserver(this);
        this.init();
    }

    private void init() {
        this.setupGui();
        this.buildListeners();
    }

    private void refresh() {
        this.tilePanel_.refresh(this.previewCtrl_.getPreviewTiles());
    }

    public JButton getRefreshPreviewBtn() {
        return this.btnRefresh_;
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTilePane(), "Center");
    }

    private void setCosmetics() {
        this.btnRefresh_.setMnemonic('R');
        this.setBorder(new TitledBorder("Print Preview"));
    }

    private JScrollPane getTilePane() {
        JScrollPane scrollPane = new JScrollPane(this.tilePanel_);
        return scrollPane;
    }

    private void buildListeners() {
        this.btnRefresh_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintPreviewPanel.this.refreshDisp();
            }
        });
    }

    private void refreshDisp() {
        this.btnRefresh_.setText("Redrawing...");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PrintPreviewPanel.this.previewCtrl_.refreshByPreview();
                PrintPreviewPanel.this.refresh();
                PrintPreviewPanel.this.btnRefresh_.setText(PrintPreviewPanel.REFRESH_TXT);
            }
        });
    }

    @Override
    public void update(UpdateChain chain) {
        this.refresh();
    }
}

