/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.print.panel;

import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.system.OsUtil;
import com.harrand.coregui.Icons;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrenchgui.print.ctrl.PrintDiagramCtrl;
import com.harrand.dbwrenchgui.print.panel.PageFormatPanel;
import com.harrand.dbwrenchgui.print.panel.PrintPreviewPanel;
import com.harrand.sketch.core.Diagram;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrintDiagramPanel
extends JPanel
implements IObserver {
    private PrintDiagramCtrl printDiagramCtrl_;
    private PageFormatPanel formatPanel_;
    private PrintPreviewPanel previewPanel_;
    private JButton btnPrint_ = new JButton("Print");
    private JLabel lblDiagram_ = new JLabel("Diagram: ");
    private JComboBox cboDiagram_ = new JComboBox();

    public PrintDiagramPanel(PrintDiagramCtrl printDiagramCtrl) {
        this.printDiagramCtrl_ = printDiagramCtrl;
        this.printDiagramCtrl_.addObserver(this);
        this.init();
        this.refresh();
    }

    private void init() {
        this.setupGui();
        this.buildListeners();
    }

    private void refresh() {
        this.loadCombo();
    }

    private void loadCombo() {
        this.cboDiagram_.removeAllItems();
        for (Diagram diagram : this.printDiagramCtrl_.getDiagrams()) {
            this.cboDiagram_.addItem(diagram);
        }
    }

    private void setupGui() {
        this.createComponents();
        this.layoutComponents();
        this.setCosmetics();
    }

    private void createComponents() {
        this.formatPanel_ = new PageFormatPanel(this.printDiagramCtrl_.getPageFormatCtrl());
        this.previewPanel_ = new PrintPreviewPanel(this.printDiagramCtrl_.getPrintPreviewCtrl());
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(4, 4));
        this.add(this.getNorthPanel(), "North");
        this.add((Component)this.getCenterPanelCards(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private void setCosmetics() {
        GuiHelper.addEmptyBorder(this);
        this.btnPrint_.setMnemonic('P');
        if (!OsUtil.isMacOs()) {
            this.btnPrint_.setIcon(Icons.PRINT);
        }
    }

    private Component getNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.getDiagramListPanel());
        panel.add(Box.createHorizontalStrut(4));
        return panel;
    }

    private JPanel getCenterPanelCards() {
        JPanel panel = new JPanel();
        panel.setLayout(new CardLayout());
        panel.add((Component)this.previewPanel_, "preview");
        return panel;
    }

    private JPanel getDiagramListPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblDiagram_, this.cboDiagram_, gbc, panel, row++);
        GuiHelper.addTitledEmptyBorder(panel, "Diagram To Print");
        return panel;
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.formatPanel_.getPageSetupBtn());
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.previewPanel_.getRefreshPreviewBtn());
        panel.add(Box.createGlue());
        panel.add(this.btnPrint_);
        return panel;
    }

    private void buildListeners() {
        this.btnPrint_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PrintDiagramPanel.this.printDiagramCtrl_.print();
            }
        });
        this.cboDiagram_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Object item = PrintDiagramPanel.this.cboDiagram_.getSelectedItem();
                Diagram diagram = item != null ? (Diagram)item : null;
                PrintDiagramPanel.this.printDiagramCtrl_.setDiagram(diagram);
            }
        });
    }

    @Override
    public void update(UpdateChain chain) {
        this.refresh();
    }
}

