/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.print.panel;

import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrenchgui.print.ctrl.PageFormatCtrl;
import com.harrand.util.LogUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class PageFormatPanel
extends JPanel
implements IObserver {
    private PageFormatCtrl formatCtrl_;
    private PageFormat pageFormat_;
    private JLabel lblOrientation_ = new JLabel("Orientation: ");
    private JLabel lblPaper_ = new JLabel("Paper Size: ");
    private JTextField txtOrientation_ = new JTextField();
    private JTextField txtPaper_ = new JTextField();
    private JButton btnSetup_ = new JButton("Page Setup");
    public static final String PAGE_SETUP_TXT = "Page Setup";

    public PageFormatPanel(PageFormatCtrl formatCtrl) {
        this.formatCtrl_ = formatCtrl;
        this.formatCtrl_.addObserver(this);
        this.init();
        this.refresh();
    }

    private void init() {
        this.setupGui();
        this.buildListeners();
    }

    private void refresh() {
        this.pageFormat_ = this.formatCtrl_.getPageFormat();
        if (this.pageFormat_ != null) {
            this.txtOrientation_.setText(this.formatCtrl_.getOrientationStr());
            this.txtPaper_.setText(this.formatCtrl_.getDimensionStr());
        } else {
            LogUtil.logErr("PageFormatPanel.error: Page Format is NULL.");
        }
    }

    public JButton getPageSetupBtn() {
        return this.btnSetup_;
    }

    private void showPageSetupDlg() {
        this.btnSetup_.setText("Updating Setup (please wait)....");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PageFormatPanel.this.formatCtrl_.showPageSetupDlg();
                PageFormatPanel.this.btnSetup_.setText(PageFormatPanel.PAGE_SETUP_TXT);
            }
        });
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.getCenterPanel(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private void setCosmetics() {
        this.btnSetup_.setMnemonic('g');
        this.setBorder(new TitledBorder("Print Setup"));
    }

    private JPanel getCenterPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblPaper_, this.txtPaper_, gbc, panel, row++);
        GuiHelper.addGridbagPair(this.lblOrientation_, this.txtOrientation_, gbc, panel, row++);
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createGlue());
        panel.add(this.btnSetup_);
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private void buildListeners() {
        this.btnSetup_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PageFormatPanel.this.showPageSetupDlg();
            }
        });
    }

    @Override
    public void update(UpdateChain chain) {
        this.refresh();
    }
}

