/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.print;

import com.harrand.dbwrenchgui.print.DiagramPage;
import com.harrand.dbwrenchgui.print.page.MarginCalculator;
import com.harrand.dbwrenchgui.print.page.PageMargins;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.List;

public class PageGroup
implements Printable,
Pageable {
    private List<DiagramPage> pages_;
    private PageMargins pageMargins;
    private PageFormat pageFormat_;

    public PageGroup(List<DiagramPage> pages, PageFormat pageFormat) {
        this.pages_ = pages;
        this.pageFormat_ = pageFormat;
        this.pageMargins = MarginCalculator.calcPageMargins(this.pageFormat_);
    }

    public List<DiagramPage> getPages() {
        return this.pages_;
    }

    public PageMargins getPageMargins() {
        return this.pageMargins;
    }

    public int getRowCount() {
        int maxRow = 0;
        for (DiagramPage page : this.pages_) {
            int row = page.getRow();
            maxRow = Math.max(maxRow, row);
        }
        return maxRow + 1;
    }

    public int getColCount() {
        int maxCol = 0;
        for (DiagramPage page : this.pages_) {
            int row = page.getCol();
            maxCol = Math.max(maxCol, row);
        }
        return maxCol + 1;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        if (pageIndex >= this.pages_.size()) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        DiagramPage partition = this.pages_.get(pageIndex);
        g2d.drawImage(partition.getImage(), null, 0, 0);
        return 0;
    }

    @Override
    public int getNumberOfPages() {
        return this.pages_.size();
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        return this.pageFormat_;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }
}

