/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.print;

import com.harrand.dbwrenchgui.print.DiagramPage;
import com.harrand.dbwrenchgui.print.PageGroup;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.List;

public class DiagramPartitioner {
    private BufferedImage fullImg_;
    private PageFormat pageFormat_;
    public static final int UNITS = 25400;

    public PageGroup createPageGroup(BufferedImage fullImg, PageFormat pageFormat) {
        this.pageFormat_ = pageFormat;
        this.fullImg_ = fullImg;
        List<DiagramPage> pages = this.buildPages();
        PageGroup group = new PageGroup(pages, this.pageFormat_);
        return group;
    }

    private List<DiagramPage> buildPages() {
        Dimension pixelsPerPageDim = this.getPixelsPerPageDim();
        int pagePixelWidth = pixelsPerPageDim.width;
        int pagePixelHeight = pixelsPerPageDim.height;
        Dimension pageGrid = this.getPageGrid(pixelsPerPageDim);
        int pageNum = 0;
        ArrayList<DiagramPage> pages = new ArrayList<DiagramPage>();
        for (int row = 0; row < pageGrid.height; ++row) {
            for (int col = 0; col < pageGrid.width; ++col) {
                ++pageNum;
                int x = col * pagePixelWidth;
                int y = row * pagePixelHeight;
                int subImgW = this.getLimitedWidth(x, pixelsPerPageDim.width, this.fullImg_.getWidth());
                int subImgH = this.getLimitedWidth(y, pixelsPerPageDim.height, this.fullImg_.getHeight());
                if (subImgW <= 0 || subImgH <= 0) continue;
                BufferedImage subImg = this.fullImg_.getSubimage(x, y, subImgW, subImgH);
                DiagramPage page = new DiagramPage(pageNum, subImg);
                page.setCol(col);
                page.setRow(row);
                page.setWidthUsedRatio(this.getUsedRatio(subImgW, pagePixelWidth));
                page.setHeightUsedRatio(this.getUsedRatio(subImgH, pagePixelHeight));
                pages.add(page);
            }
        }
        return pages;
    }

    private double getUsedRatio(int pixelsUsed, int pixelsAvailable) {
        return (double)pixelsUsed / (double)pixelsAvailable;
    }

    private int getLimitedWidth(int start, int pixelsPerPage, int imgSize) {
        int theoreticalTravel = start + pixelsPerPage;
        if (theoreticalTravel > imgSize) {
            return imgSize - start;
        }
        return pixelsPerPage;
    }

    private Dimension getPageGrid(Dimension PixelsPerPageDim) {
        int imgWidth = this.fullImg_.getWidth();
        int imgHeight = this.fullImg_.getHeight();
        float horzPageReq = imgWidth / PixelsPerPageDim.width;
        float vertPageReq = imgHeight / PixelsPerPageDim.height;
        int horzPageCount = (int)horzPageReq + 1;
        int vertPageCount = (int)vertPageReq + 1;
        return new Dimension(horzPageCount, vertPageCount);
    }

    private Dimension getPixelsPerPageDim() {
        int pixelsPerPageW = (int)this.pageFormat_.getImageableWidth();
        int pixelsPerPageH = (int)this.pageFormat_.getImageableHeight();
        Dimension rawPixelsPerPageDim = new Dimension(pixelsPerPageW, pixelsPerPageH);
        return rawPixelsPerPageDim;
    }
}

