/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel.support;

import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.SetProperty;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.PkNameBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import java.util.ArrayList;
import java.util.List;

public class ColumnEditPanelPK_Support {
    public Command getUpdatePK_SubCmd(Table table, Column oldColumn, Column newColumn, boolean newIsInPk) {
        ArrayList<String> pkColNames;
        PrimaryKey oldPk = table.getPrimaryKey();
        String newColNm = newColumn.getName();
        boolean oldIsInPk = false;
        if (oldPk != null) {
            pkColNames = oldPk.getKeyColumnNames();
            oldIsInPk = this.isInPk(oldPk, oldColumn);
        } else {
            pkColNames = new ArrayList<String>();
        }
        if (!this.hasPkChanged(oldIsInPk, newIsInPk)) {
            return null;
        }
        if (newIsInPk) {
            pkColNames.add(newColNm);
        } else {
            pkColNames.remove(newColNm);
        }
        String newPkName = this.getNewPK_Name(table, pkColNames);
        PrimaryKey newPk = !pkColNames.isEmpty() ? new PrimaryKey(newPkName, pkColNames) : null;
        SetProperty cmd = new SetProperty(table, oldPk, newPk);
        return cmd;
    }

    private boolean isInPk(PrimaryKey pk, Column column) {
        String columnNm = column != null ? column.getName() : null;
        boolean isInPk = false;
        if (columnNm != null) {
            isInPk = pk.containsColumnName(columnNm);
        }
        return isInPk;
    }

    private String getNewPK_Name(Table table, List pkColNms) {
        PkNameBldr pkNmBldr = (PkNameBldr)DbwNameBldrSvr.instance().getNameBldr("PkNameBldr");
        String pkNm = pkNmBldr.getFormedName(table.getName(), pkColNms);
        return pkNm;
    }

    private boolean hasPkChanged(boolean oldIsInPk, boolean newIsInPk) {
        return oldIsInPk != newIsInPk;
    }
}

