/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel.subpanel.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.button.ButtonUtil;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.coregui.display.BasicSizeStorable;
import com.harrand.coregui.display.ISizeStorable;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.list.DualListPanel;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.UniqueConstraintNameBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.table.constraint.UniqueConstraint;
import com.harrand.dbwrench.security.App;
import com.harrand.util.FileHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListDataListener;

public final class UniqueConstraintPanel
extends JPanel
implements DataEditor,
ITitled {
    private Table table;
    private UniqueConstraint uniqueConstraint;
    private UniqueConstraint newUniqueConstraint;
    private DualListPanel columnPanel_;
    private JLabel lblName_;
    private JTextField txtName_ = new JTextField("");
    private JButton btnAutoName_ = ButtonUtil.getAutonameBtn();
    private boolean syncOnEdit_ = false;
    private boolean startedUpdate_ = false;
    private ActionListener editSyncActionListener_;
    private ListDataListener editSyncListDataListener_;
    private InputVerifier verifier_;
    private static ISizeStorable basicSizeStorable__ = new BasicSizeStorable(new Dimension(395, 390));
    public static final String LBL_USED_COLUMNS = "Columns In Constraint";
    public static final String LBL_NOT_USED_COLUMNS = "Available Columns";
    private static final String CLASS_NM = UniqueConstraint.getClassName();

    public UniqueConstraintPanel(Table table, UniqueConstraint uniqueConstraint) {
        this.table = table;
        this.uniqueConstraint = uniqueConstraint;
        this.setupGui();
    }

    private List<Column> getSelectedColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        Object[] selectedColNms = this.columnPanel_.getLeftItems();
        for (int i = 0; i < selectedColNms.length; ++i) {
            Column column = this.table.getColumn((String)selectedColNms[i]);
            columns.add(column);
        }
        return columns;
    }

    private void setupGui() {
        this.buildComponents();
        this.layoutComponents();
        this.loadData();
        this.setCosmetics();
        this.addListeners();
    }

    private void buildComponents() {
        String div = "";
        this.lblName_ = new JLabel(FileHelper.getResource("name.label") + div);
        this.columnPanel_ = new DualListPanel(new ArrayList().toArray(), new ArrayList().toArray());
    }

    private void loadData() {
        if (this.uniqueConstraint != null) {
            this.txtName_.setText(this.uniqueConstraint.getName());
        } else {
            this.txtName_.setText("");
        }
        this.loadDualListData();
    }

    private void loadDualListData() {
        this.columnPanel_.removeListDataListener(this.editSyncListDataListener_);
        List usedColNms = this.uniqueConstraint == null ? new ArrayList() : StrHelper.getNamedNms(this.uniqueConstraint.getColumns());
        ArrayList remainColumnNames = new ArrayList(this.table.getKeys(Column.getClassName()));
        remainColumnNames.removeAll(usedColNms);
        this.columnPanel_.setData(usedColNms.toArray(), remainColumnNames.toArray());
        if (this.syncOnEdit_) {
            this.columnPanel_.addListDataListener(this.editSyncListDataListener_);
        }
    }

    private void layoutComponents() {
        GuiHelper.addEmptyBorder(this);
        this.setLayout(new BorderLayout(4, 16));
        this.add((Component)this.getNamePanel(), "North");
        this.add((Component)this.columnPanel_, "Center");
    }

    private JPanel getNamePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(this.lblName_);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.txtName_);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.btnAutoName_);
        return panel;
    }

    private void setCosmetics() {
        this.columnPanel_.setLeftLabel(LBL_USED_COLUMNS);
        this.columnPanel_.setRightLabel(LBL_NOT_USED_COLUMNS);
    }

    private void syncData() throws Exception {
        String name = this.txtName_.getText();
        List<Column> columns = this.getSelectedColumns();
        this.newUniqueConstraint = new UniqueConstraint(this.table, columns, name);
        BasicCollector.verifyNoDups(this.table, this.uniqueConstraint, this.newUniqueConstraint);
        if (this.syncOnEdit_) {
            if (this.uniqueConstraint != null) {
                this.startedUpdate_ = true;
                UniqueConstraint oldUc = this.uniqueConstraint;
                this.uniqueConstraint = this.newUniqueConstraint;
                UpdateInCollector.doUpdate(this.table, oldUc, this.uniqueConstraint, App.getCommandChain(), null);
            }
        } else {
            this.uniqueConstraint = this.newUniqueConstraint;
        }
        this.startedUpdate_ = false;
    }

    @Override
    public ITestResult validateData() {
        DataEntryResult result;
        block2: {
            try {
                this.syncData();
                result = new DataEntryResult(true);
            }
            catch (Exception e) {
                result = new DataEntryResult(false, e.getMessage());
                if (this.uniqueConstraint == null) break block2;
                this.loadData();
            }
        }
        return result;
    }

    public void update(UpdateChain chain) {
        if (!this.startedUpdate_ && chain.hasClassName(CLASS_NM) && this.uniqueConstraint != null) {
            this.uniqueConstraint = this.table.getKeys(CLASS_NM).contains(this.uniqueConstraint.getName()) ? (UniqueConstraint)this.table.get(CLASS_NM, this.uniqueConstraint.getName()) : null;
            this.loadData();
        }
    }

    @Override
    public String getTitle() {
        String title = this.uniqueConstraint == null ? FileHelper.getResource("add.label") : FileHelper.getResource("edit.label");
        return title + " " + App.getResource("uniqueConstraint.label");
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.UNIQUE_CONSTRAINT;
    }

    public UniqueConstraint getUniqueConstraint() {
        this.validateData();
        return this.uniqueConstraint;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getUniqueConstraint();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(basicSizeStorable__.getSize());
    }

    @Override
    public Dimension getSize() {
        return basicSizeStorable__.getSize();
    }

    @Override
    public void setSize(Dimension size) {
        basicSizeStorable__.setSize(size);
    }

    private void addListeners() {
        this.btnAutoName_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UniqueConstraintPanel.this.setAutoName();
            }
        });
    }

    public void setAutoName() {
        List<Column> cols = this.getSelectedColumns();
        if (cols.isEmpty()) {
            GuiMessageHelper.showInputErrMsg(null, "No Columns Specified", "At least one column must be specified before an unique constraint name can be generated.");
            return;
        }
        DbwNameBldrSvr bldrSvr = DbwNameBldrSvr.instance();
        UniqueConstraintNameBldr nameBldr = (UniqueConstraintNameBldr)bldrSvr.getNameBldr("UniqueConstraintNameBldr");
        try {
            UniqueConstraint sampleUC = new UniqueConstraint(this.table, cols, "tempName");
            String builtName = nameBldr.getFormedName(sampleUC);
            this.txtName_.setText(builtName);
        }
        catch (Exception e) {
            GuiMessageHelper.showInputErrMsg(null, "Input Error", e.getMessage());
        }
    }

    @Override
    public Collector getCollector() {
        return this.table;
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
        this.syncOnEdit_ = sync;
    }
}

