/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel.lic;

import com.harrand.coreclasses.auth.lic.LicensePolicy;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrenchgui.panel.lic.LicensePanel;
import com.harrand.dbwrenchgui.security.CodeWarningPanel;
import com.harrand.util.ResMgr;
import java.awt.Container;
import javax.swing.JDialog;

public class LicensingUI_Ctrl {
    private static LicensingUI_Ctrl instance = new LicensingUI_Ctrl();
    private boolean showLicensePanel;

    private LicensingUI_Ctrl() {
    }

    public static LicensingUI_Ctrl getInstance() {
        return instance;
    }

    public ITestResult hasOperableLicense() {
        this.showWarningMsg();
        ITestResult result = this.getLicensePolicy().hasOperableLicense();
        if (result.getPassed()) {
            return result;
        }
        this.showExpiredLicenseDlg();
        result = this.getLicensePolicy().hasOperableLicense();
        return result;
    }

    public boolean getShowLicensePanel() {
        return this.showLicensePanel;
    }

    private void showWarningMsg() {
        String warningMsg = this.getLicensePolicy().getWarningMsg();
        if (warningMsg != null) {
            this.showWarningDlg(warningMsg);
        }
    }

    private void showWarningDlg(String warningMsg) {
        CodeWarningPanel warnPanel = new CodeWarningPanel(warningMsg);
        JDialog dlg = new JDialog();
        dlg.setModal(true);
        Container cp = dlg.getContentPane();
        cp.add(warnPanel);
        warnPanel.setParentContainer(dlg);
        GuiHelper.locateDialog(dlg, warnPanel.getPreferredBounds());
        dlg.setTitle(warnPanel.getTitle());
        dlg.setVisible(true);
        this.showLicensePanel = warnPanel.getShowLicensePanelAfter();
    }

    private void showExpiredLicenseDlg() {
        LicensePanel licensePanel = new LicensePanel();
        licensePanel.setShowCloseBtn(true);
        JDialog dlg = new JDialog();
        dlg.setModal(true);
        Container cp = dlg.getContentPane();
        cp.add(licensePanel);
        licensePanel.setParentContainer(dlg);
        GuiHelper.locateDialog(dlg, licensePanel.getPreferredBounds());
        dlg.setTitle(ResMgr.getRes("license.expired.title"));
        dlg.setVisible(true);
    }

    private LicensePolicy getLicensePolicy() {
        return LicensePolicy.getInstance();
    }
}

