/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel.lic;

import com.harrand.coreclasses.auth.lic.License;
import com.harrand.coreclasses.auth.lic.LicensePolicy;
import com.harrand.coreclasses.auth.lic.LicensingCtrl;
import com.harrand.coreclasses.auth.lic.type.ILicenseType;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.dbwrenchgui.panel.lic.LicenseInputPanel;
import com.harrand.dbwrenchgui.panel.lic.PurchaseLinksPanel;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.RootPaneContainer;

public class LicensePanel
extends JPanel
implements ITitled,
IObserver {
    private final LicenseInputPanel licenseInputPanel = new LicenseInputPanel();
    private final PurchaseLinksPanel purchaseLinksPanel = new PurchaseLinksPanel();
    private final JTextPane txtStatusDesc = new JTextPane();
    private final XpHeaderPanel headerPanel_ = new XpHeaderPanel("Licensing", "Update Licensing Information");
    static final String TITLE = ResMgr.getRes("license.info.title");

    public LicensePanel() {
        LicensePolicy.getInstance().refreshLicenseType();
        this.init();
        LicensingCtrl.getInstance().addObserver(this);
        this.refresh();
    }

    void setShowCloseBtn(boolean showCloseBtn) {
        this.purchaseLinksPanel.setShowCloseBtn(showCloseBtn);
    }

    private void init() {
        this.setupGui();
    }

    private License getLicense() {
        return License.getInstance();
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
    }

    private void refresh() {
        this.licenseInputPanel.refresh();
        this.purchaseLinksPanel.refresh();
        this.refreshDescText();
    }

    private void refreshDescText() {
        ILicenseType licenseType = this.getLicense().getLicenseType();
        String nmText = licenseType.getName();
        String descrText = licenseType.getFullDescr(new GregorianCalendar());
        String fullText = nmText + "\n\n" + descrText;
        this.txtStatusDesc.setText(fullText);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.getNorthPanel(), "North");
        this.add((Component)this.getDescriptionPanel(), "Center");
        this.add((Component)this.purchaseLinksPanel, "South");
    }

    private JPanel getNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.headerPanel_, "North");
        panel.add((Component)this.licenseInputPanel, "Center");
        return panel;
    }

    private JPanel getDescriptionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.txtStatusDesc);
        GuiHelper.addEmptyBorder(this.txtStatusDesc);
        GuiHelper.addTitledEmptyBorder(panel, "License Description");
        return panel;
    }

    private void setCosmetics() {
        this.txtStatusDesc.setEditable(false);
    }

    public Rectangle getPreferredBounds() {
        return new Rectangle(50, 50, 550, 440);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getToolTip() {
        return TITLE;
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.SECURITY;
    }

    @Override
    public void update(UpdateChain chain) {
        this.refresh();
    }

    void setParentContainer(RootPaneContainer parentContainer) {
        this.purchaseLinksPanel.setParentContainer(parentContainer);
    }
}

