/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel.lic;

import com.harrand.coreclasses.auth.lic.License;
import com.harrand.coreclasses.auth.lic.LicensingCtrl;
import com.harrand.coreclasses.auth.pin.IPIN;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.security.Code;
import com.harrand.coregui.EditDialog;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.text.TextEditPanel;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LicenseInputPanel
extends JPanel {
    private final JLabel lblStandard_ = new JLabel("Standard License Key");
    private final JLabel lblUpgrade_ = new JLabel("Upgrade License Key");
    private final JTextField txtStandard_ = new JTextField();
    private final JTextField txtUpgrade_ = new JTextField();
    private final JButton btnStandard_ = new JButton("Set License Key");
    private final JButton btnUpgrade_ = new JButton("Set License Key");
    private JPanel standardTextPanel;
    private JPanel upgradeTextPanel;

    public LicenseInputPanel() {
        this.init();
        this.refresh();
    }

    private boolean getShowUpgradePanel() {
        return LicensingCtrl.getInstance().getNeedsUpgradeLicense();
    }

    public final void refresh() {
        this.removeAll();
        this.layoutComponents();
        this.refreshLicenseTexts();
    }

    private String extractPIN_Text(IPIN pin) {
        if (pin != null) {
            return pin.getPIN_Text();
        }
        return "";
    }

    private void init() {
        this.setupGui();
        this.buildListeners();
    }

    private void setupGui() {
        this.createComponents();
        this.layoutComponents();
        this.setCosmetics();
    }

    private void createComponents() {
        this.buildStandardTextPanel();
        this.buildUpgradeTextPanel();
    }

    private void refreshLicenseTexts() {
        this.txtStandard_.setText(this.getCurrentStandardPIN_Text());
        this.txtUpgrade_.setText(this.getCurrentUpgradePIN_Text());
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.getInputPanel(), "North");
    }

    private JPanel getInputPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblStandard_, this.standardTextPanel, gbc, panel, row++);
        if (this.getShowUpgradePanel()) {
            GuiHelper.addGridbagPair(this.lblUpgrade_, this.upgradeTextPanel, gbc, panel, row++);
        }
        GuiHelper.addBodyPanelBorder(panel);
        return panel;
    }

    private void buildStandardTextPanel() {
        this.standardTextPanel = new JPanel();
        this.standardTextPanel.setLayout(new BoxLayout(this.standardTextPanel, 0));
        this.standardTextPanel.add(this.txtStandard_);
        this.standardTextPanel.add(Box.createHorizontalStrut(4));
        this.standardTextPanel.add(this.btnStandard_);
        this.standardTextPanel.add(Box.createHorizontalGlue());
    }

    private void buildUpgradeTextPanel() {
        this.upgradeTextPanel = new JPanel();
        this.upgradeTextPanel.setLayout(new BoxLayout(this.upgradeTextPanel, 0));
        this.upgradeTextPanel.add(this.txtUpgrade_);
        this.upgradeTextPanel.add(Box.createHorizontalStrut(4));
        this.upgradeTextPanel.add(this.btnUpgrade_);
        this.upgradeTextPanel.add(Box.createHorizontalGlue());
    }

    private void setCosmetics() {
        GuiHelper.addEmptyBorder(this);
        this.txtStandard_.setEditable(false);
        this.txtUpgrade_.setEditable(false);
    }

    private void buildListeners() {
        this.txtStandard_.addMouseListener(new StandardPinMouseListener());
        this.txtUpgrade_.addMouseListener(new UpgradePinMouseListener());
        this.btnStandard_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseInputPanel.this.showSetStandardLicense();
            }
        });
        this.btnUpgrade_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseInputPanel.this.showSetUpgradeLicense();
            }
        });
    }

    private void showSetStandardLicense() {
        ITestResult result;
        String newPIN_Text = this.showInputDlg(this.getCurrentStandardPIN_Text(), ResMgr.getRes("license.enter.prompt"), 0);
        if (newPIN_Text != null && !(result = LicensingCtrl.getInstance().setStandardPIN(newPIN_Text.trim())).getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, result);
        }
    }

    private void showSetUpgradeLicense() {
        ITestResult result;
        String newPIN_Text = this.showInputDlg(this.getCurrentUpgradePIN_Text(), "Upgrade " + ResMgr.getRes("license.enter.prompt"), 1);
        if (newPIN_Text != null && !(result = LicensingCtrl.getInstance().setUpgradePIN(newPIN_Text.trim())).getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, result);
        }
    }

    private String showInputDlg(String currentPIN_Text, String promptText, int codeType) {
        String PIN_Text = null;
        TextEditPanel editPanel = new TextEditPanel(Code.clazz(), promptText, currentPIN_Text);
        editPanel.setTitle(ResMgr.getRes("license.update.label"));
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, editPanel);
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            String inputStr;
            String inStr = editPanel.getText();
            Code newCode = new Code(inStr, codeType);
            PIN_Text = inputStr = newCode.getText();
        }
        return PIN_Text;
    }

    private String getCurrentStandardPIN_Text() {
        return this.extractPIN_Text(License.getInstance().getStandardPIN());
    }

    private String getCurrentUpgradePIN_Text() {
        return this.extractPIN_Text(License.getInstance().getUpgradePIN());
    }

    private class UpgradePinMouseListener
    extends MouseAdapter {
        private UpgradePinMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            LicenseInputPanel.this.showSetUpgradeLicense();
        }
    }

    private class StandardPinMouseListener
    extends MouseAdapter {
        private StandardPinMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            LicenseInputPanel.this.showSetStandardLicense();
        }
    }
}

