/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.IDataEditPanel;
import com.harrand.coreclasses.display.IPanelContainer;
import com.harrand.coreclasses.element.IIdfAsIs;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ICloseVerify;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.idf.AddToCollector;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.coregui.dataEntry.CloseChecker;
import com.harrand.coregui.display.BasicSizeStorable;
import com.harrand.coregui.display.ISizeStorable;
import com.harrand.coregui.display.ISpaceConservable;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.coregui.text.FocusRestorer;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.sub.NbEditPanel;
import com.harrand.dbwrenchgui.sub.editor.DbwEditor;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class ViewEditPanel
extends JPanel
implements DataEditor,
IObserver,
ISizeStorable,
ITitled,
ICloseVerify,
IDataEditPanel,
ISpaceConservable,
IRefreshable,
IIdfAsIs {
    private View lastView_;
    private View view_;
    private Schema schema_;
    private IPanelContainer panelContainer_;
    private static ISizeStorable basicSizeStorable__ = new BasicSizeStorable(new Dimension(500, 500));
    private final String className_ = View.getClassName();
    private JPanel editPanel_;
    private JLabel lblName_;
    private final JTextField txtName_ = new JTextField("");
    private JLabel lblSqlText_;
    private XpHeaderPanel header_;
    private DbwEditor editor;
    private boolean startedUpdate_ = false;
    private boolean conserveSpace_ = false;
    private int objId_ = -1;
    private SwingThemeCtrl themeCtrl_;
    private FocusRestorer focusRestorer_;

    public ViewEditPanel(View view) {
        this.buildControls();
        this.setView(view);
        this.init();
    }

    public ViewEditPanel(Schema schema) {
        this.buildControls();
        this.schema_ = schema;
        this.setView(null);
        this.init();
    }

    public void setView(View view) {
        this.lastView_ = view;
        if (this.lastView_ != null) {
            this.schema_ = this.lastView_.getSchema();
            this.objId_ = this.schema_.getId(this.lastView_);
        } else {
            this.objId_ = -1;
        }
        this.schema_.addObserver(this);
        this.loadData();
        this.updateDirty();
    }

    private void init() {
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
        this.buildFocusRestorer();
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void buildControls() {
        String div = "";
        this.lblName_ = new JLabel(App.getResource("view.name.label") + div);
        this.lblSqlText_ = new JLabel(App.getResource("sql.text.label") + div);
        this.editor = new DbwEditor();
        this.editor.addObserver(this);
    }

    private void buildFocusRestorer() {
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        comps.add(this.txtName_);
        comps.add(this.editor);
        this.focusRestorer_ = new FocusRestorer(comps);
    }

    private void loadData() {
        if (this.lastView_ != null) {
            this.txtName_.setText(this.lastView_.getName());
            this.editor.setText(this.lastView_.getSql());
        } else {
            this.txtName_.setText("");
            this.editor.setText("");
        }
    }

    private void layoutComponents() {
        this.buildMainPanel();
        this.setLayout(new BorderLayout());
        this.refreshDisplay();
    }

    @Override
    public void refresh() {
        if (this.objId_ >= 0 && this.schema_.contains(this.objId_)) {
            Identifiable idf = this.schema_.getIdf(this.objId_);
            if (idf instanceof View) {
                View view = (View)idf;
                this.setView(view);
            } else {
                String msg = idf == null ? "null" : idf.getClass().getName();
                LogUtil.logErr("ViewEditPan.Refresh: expected View but was: " + msg);
            }
            this.loadData();
        }
    }

    private void refreshDisplay() {
        this.removeAll();
        if (!this.conserveSpace_) {
            this.add((Component)this.header_, "North");
        }
        this.add((Component)this.editPanel_, "Center");
        this.setBorders();
    }

    private void buildMainPanel() {
        JPanel namePanel = new JPanel();
        JPanel textPanel = new JPanel();
        this.initHeaderPanel();
        this.buildNamePanel(namePanel);
        this.buildTextPanel(textPanel);
        this.editPanel_ = new JPanel();
        GuiHelper.addReducedBodyPanelBorder(this.editPanel_);
        this.themeCtrl_.process(namePanel);
        this.themeCtrl_.process(textPanel);
        this.editPanel_.setLayout(new BorderLayout(0, 4));
        this.editPanel_.add((Component)namePanel, "North");
        this.editPanel_.add((Component)textPanel, "Center");
    }

    private void buildNamePanel(JPanel panel) {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblName_, this.txtName_, gbc, panel, row++);
    }

    private void initHeaderPanel() {
        String hdrTitle = StrHelper.getAddOrEditText(this.lastView_) + App.getResource("view.label");
        this.header_ = new XpHeaderPanel(hdrTitle, null);
    }

    private void buildTextPanel(JPanel textPanel) {
        textPanel.setLayout(new BorderLayout());
        textPanel.add((Component)this.lblSqlText_, "North");
        textPanel.add((Component)this.editor, "Center");
    }

    private void setBorders() {
        if (this.conserveSpace_) {
            this.editPanel_.setBorder(null);
            GuiHelper.addEmptyBorder(this);
        } else {
            GuiHelper.addReducedBodyPanelBorder(this.editPanel_);
            this.setBorder(null);
        }
    }

    private void setNames() {
        this.setName("ViewEditPanel");
        this.lblName_.setName("lblName");
        this.txtName_.setName("txtName");
        this.lblSqlText_.setName("lblSqlText");
        this.editor.setName("sqlTextPanel");
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.lblName_);
        this.themeCtrl_.process(this.txtName_);
        this.themeCtrl_.process(this.lblSqlText_);
    }

    private void addListeners() {
        this.txtName_.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ViewEditPanel.this.updateDirty();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    private void updateDirty() {
        if (this.panelContainer_ != null) {
            this.panelContainer_.setTitle(this.getTitle());
        }
    }

    @Override
    public boolean isDirty() {
        String nm = this.txtName_.getText();
        String sql = this.editor.getText();
        if (this.lastView_ != null) {
            if (!this.lastView_.getName().equals(nm)) {
                return true;
            }
            if (!this.lastView_.getSql().equals(sql)) {
                return true;
            }
        } else {
            if (Validator.isStringValid(nm)) {
                return true;
            }
            if (Validator.isStringValid(sql)) {
                return true;
            }
        }
        return false;
    }

    public View getView() {
        this.validateData();
        return this.view_;
    }

    public Identifiable getObjectAsIs() {
        return this.lastView_;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getView();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(basicSizeStorable__.getSize());
    }

    @Override
    public ITestResult validateData() {
        ITestResult result = new DataEntryResult(true);
        String name = this.txtName_.getText();
        String sql = this.editor.getText();
        View newView = null;
        try {
            newView = new View(name, sql);
            newView.setSchema(this.schema_);
        }
        catch (Exception e) {
            result = new DataEntryResult(false, e.getMessage());
            return result;
        }
        result = BasicCollector.verifyNoDupsNoException(this.schema_, this.lastView_, newView);
        if (!result.getPassed()) {
            return result;
        }
        this.view_ = newView;
        return result;
    }

    @Override
    public String getTitle() {
        StringBuffer sb = new StringBuffer(this.getBasicTitle());
        if (this.isDirty()) {
            sb.append("*");
        }
        return sb.toString();
    }

    private String getBasicTitle() {
        String title = this.getView() != null ? this.getView().getName() : "Add View";
        return title;
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.VIEW;
    }

    @Override
    public void update(UpdateChain chain) {
        if (!this.startedUpdate_ && chain.hasClassName(this.className_) && this.lastView_ != null) {
            this.lastView_ = this.schema_.getKeys(this.className_).contains(this.lastView_.getName()) ? (View)this.schema_.get(this.className_, this.lastView_.getName()) : null;
            this.loadData();
        }
        if (chain.hasClassName(NbEditPanel.class.getName())) {
            this.updateDirty();
        }
    }

    @Override
    public Dimension getSize() {
        return basicSizeStorable__.getSize();
    }

    @Override
    public void setSize(Dimension size) {
        basicSizeStorable__.setSize(size);
    }

    @Override
    public Identifiable getIdfAsIs() {
        return this.lastView_;
    }

    @Override
    public Collector getCollector() {
        return this.schema_;
    }

    @Override
    public ITestResult save() {
        if (this.startedUpdate_) {
            return new DataEntryResult();
        }
        ITestResult result = this.validateData();
        if (result.getPassed()) {
            this.startedUpdate_ = true;
            if (this.lastView_ == null) {
                AddToCollector addCmd = new AddToCollector(this.schema_, this.view_);
                addCmd.setCommandChain(App.getCommandChain());
                addCmd.actionPerformed(null);
            } else {
                boolean autoSave = false;
                UpdateInCollector.doUpdate(this.schema_, this.lastView_, this.view_, App.getCommandChain(), null, autoSave);
            }
            this.lastView_ = this.view_;
            this.updateDirty();
            this.restoreFocus();
            this.startedUpdate_ = false;
        }
        return result;
    }

    @Override
    public void setPanelContainer(IPanelContainer panelContainer) {
        this.panelContainer_ = panelContainer;
    }

    private void restoreFocus() {
        this.focusRestorer_.restoreFocus();
    }

    @Override
    public boolean allowClose() {
        String nm = this.lastView_ != null ? this.lastView_.getName() : "";
        CloseChecker checker = new CloseChecker(this.isDirty(), nm);
        checker.doCheck();
        if (checker.getDoSave()) {
            this.save();
        }
        return checker.getAllowClose();
    }

    @Override
    public boolean getConserveSpace() {
        return this.conserveSpace_;
    }

    @Override
    public void setConserveSpace(boolean conserveSpace) {
        this.conserveSpace_ = conserveSpace;
        boolean editable = !conserveSpace;
        this.editor.setEditable(editable);
        this.txtName_.setEditable(editable);
        this.refreshDisplay();
    }
}

