/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.AddRemoveContainer;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.DbwCommandFactory;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.image.IIconTabPane;
import com.harrand.coregui.table.TablePanel;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.db.TableDataPanel;
import com.harrand.dbwrenchgui.panel.TablePropPanel;
import com.harrand.dbwrenchgui.table.ColumnTableDriver;
import com.harrand.dbwrenchgui.table.ForeignKeyTableDriver;
import com.harrand.dbwrenchgui.table.IndexTableDriver;
import com.harrand.dbwrenchgui.table.TriggerTableDriver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public final class TableDetailsPanel
extends JPanel
implements IIconTabPane,
ISized,
IObserver,
ITitled {
    private static final TableDetailsPanel instance__ = new TableDetailsPanel();
    private JTabbedPane tabPane_;
    private final JPanel emptyPanel_ = new JPanel(new BorderLayout());
    private AddRemoveContainer columnContainer_;
    private AddRemoveContainer indexContainer_;
    private AddRemoveContainer triggerContainer_;
    private AddRemoveContainer fkContainer_;
    private TablePropPanel tablePropPanel_;
    private ColumnTableDriver columnDriver_;
    private ForeignKeyTableDriver fkDriver_;
    private IndexTableDriver indexDriver_;
    private TriggerTableDriver triggerDriver_;
    private TableDataPanel dataPanel_;
    private TablePanel columnTablePanel_;
    private TablePanel fkTablePanel_;
    private TablePanel indexTablePanel_;
    private TablePanel triggerTablePanel_;
    private final JLabel lblNoTblSelected_ = new JLabel("<Table Details Panel - No Table Selected>");
    private Table table_ = null;
    private String headerTitle;
    private boolean driversCreated_ = false;
    private boolean emptyPanelDisplaying_ = false;
    private boolean isTabPaneInitialized_ = false;
    public static final String PANEL_TITLE = App.getRes("table.details.label");
    public static final String NAME = "tableDetailsPanel";
    public static final int COL_TAB_IDX = 0;
    public static final int PROP_TAB_IDX = 1;
    public static final int FK_TAB_IDX = 2;
    public static final int IDX_TAB_IDX = 3;
    public static final int TRG_TAB_IDX = 4;
    public static final int DATA_TAB_IDX = 5;
    public static final int PREFERRED_WIDTH = 750;
    public static final int PREFERRED_HEIGHT = 350;

    private TableDetailsPanel() {
        this.buildEmptyPanel();
        this.displayEmptyPanel(false);
    }

    public static TableDetailsPanel getInstance() {
        return instance__;
    }

    public Table getTable() {
        return this.table_;
    }

    public void viewData() {
        if (this.isTableSet()) {
            this.checkTabDisplaying();
            this.tabPane_.setSelectedIndex(5);
            this.dataPanel_.ensureDataPresent();
        } else {
            this.displayEmptyPanel(true);
        }
    }

    public void setTable(Table theTable) {
        this.table_ = theTable;
        if (this.isTableSet()) {
            if (!this.driversCreated_) {
                this.buildAddRemoveContainers();
            }
            if (!this.isTabPaneInitialized_) {
                this.initTabPanel();
            }
            this.checkTabDisplaying();
            this.columnDriver_.setCollector(this.table_);
            this.fkDriver_.setCollector(this.table_);
            this.indexDriver_.setCollector(this.table_);
            this.triggerDriver_.setCollector(this.table_);
            this.tablePropPanel_.setTable(this.table_);
            this.dataPanel_.setTable(this.table_);
            this.table_.addObserver(this);
            this.columnContainer_.setAdditionalButtonListener(this.getColumnSortActionListener());
            this.refresh();
        } else {
            this.displayEmptyPanel(false);
        }
    }

    public void setTab(String keyNm) {
        if (this.isTableSet()) {
            this.checkTabDisplaying();
            if (keyNm.equalsIgnoreCase(Column.getClassName())) {
                this.tabPane_.setSelectedIndex(0);
                this.setFocusToTablePanel(this.columnTablePanel_);
            } else if (keyNm.equalsIgnoreCase(ForeignKey.getClassName())) {
                this.tabPane_.setSelectedIndex(2);
                this.setFocusToTablePanel(this.fkTablePanel_);
            } else if (keyNm.equalsIgnoreCase(Index.getClassName())) {
                this.tabPane_.setSelectedIndex(3);
                this.setFocusToTablePanel(this.indexTablePanel_);
            } else if (keyNm.equalsIgnoreCase(Trigger.getClassName())) {
                this.tabPane_.setSelectedIndex(4);
                this.setFocusToTablePanel(this.triggerTablePanel_);
            } else if (keyNm.equalsIgnoreCase("Properties")) {
                this.tabPane_.setSelectedIndex(1);
            } else if (keyNm.equalsIgnoreCase("Data")) {
                this.tabPane_.setSelectedIndex(5);
                this.dataPanel_.requestFocus();
            }
        } else {
            this.displayEmptyPanel(true);
        }
    }

    private boolean isTableSet() {
        return this.table_ != null;
    }

    private void checkTabDisplaying() {
        if (this.emptyPanelDisplaying_) {
            this.addTabPanel();
        }
        this.emptyPanelDisplaying_ = false;
    }

    private void addTabPanel() {
        this.removeAll();
        if (this.tabPane_ == null) {
            this.buildTabPane();
        }
        this.add((Component)this.tabPane_, "Center");
    }

    private void displayEmptyPanel(boolean displayMsgFlag) {
        this.removeAll();
        this.add((Component)this.emptyPanel_, "Center");
        this.emptyPanelDisplaying_ = true;
        if (displayMsgFlag) {
            GuiMessageHelper.showWarningMsg(null, "Table Details Panel", "No table is selected. Select a table from a diagram or from the node tree in Database Explorer.");
        }
    }

    private void buildEmptyPanel() {
        this.lblNoTblSelected_.setHorizontalTextPosition(0);
        this.lblNoTblSelected_.setHorizontalAlignment(0);
        this.emptyPanel_.add((Component)this.lblNoTblSelected_, "Center");
    }

    private void initTabPanel() {
        this.buildTabPane();
        this.isTabPaneInitialized_ = true;
    }

    private void setFocusToTablePanel(TablePanel tablePanel) {
        tablePanel.selectFirstRow();
    }

    private void buildTabPane() {
        this.initComponents();
        this.setCosmetics();
        this.addPanels();
        this.setNames();
        this.refresh();
    }

    private void setNames() {
        this.setName(NAME);
        this.tabPane_.setName("tabPane");
        this.columnContainer_.setName("columnContainer");
        this.fkContainer_.setName("fkContainer");
        this.indexContainer_.setName("indexContainer");
        this.triggerContainer_.setName("triggerContainer");
    }

    private void setCosmetics() {
    }

    private void addPanels() {
        this.setLayout(new BorderLayout());
        this.tabPane_ = new JTabbedPane(3);
        this.tabPane_.addTab(this.table_.getDisplayPlural(Column.getClassName()), Icons.COLUMN, this.columnContainer_, "Ctrl+Shift+C");
        this.tabPane_.addTab("Properties", Icons.PROPS, this.tablePropPanel_, "Ctrl+Shift+P");
        this.tabPane_.addTab(this.table_.getDisplayPlural(ForeignKey.getClassName()), Icons.FOREIGN_KEY, this.fkContainer_, "Ctrl+Shift+F");
        this.tabPane_.addTab(this.table_.getDisplayPlural(Index.getClassName()), Icons.INDEX, this.indexContainer_, "Ctrl+Shift+I");
        this.tabPane_.addTab(this.table_.getDisplayPlural(Trigger.getClassName()), Icons.TRIGGER, this.triggerContainer_, "Ctrl+Shift+T");
        this.tabPane_.addTab("Data", Icons.TABLE_DATA_VIEWER, this.dataPanel_, "Ctrl+Shift+D");
        this.dataPanel_.setIconTabPane(this, 5);
        this.tabPane_.setMinimumSize(new Dimension(142, 165));
        this.addTabPanel();
    }

    private void buildAddRemoveContainers() {
        this.columnDriver_ = new ColumnTableDriver(this.table_);
        this.fkDriver_ = new ForeignKeyTableDriver(this.table_, 1);
        this.indexDriver_ = new IndexTableDriver(this.table_);
        this.triggerDriver_ = new TriggerTableDriver(this.table_);
        this.columnTablePanel_ = new TablePanel(this.columnDriver_);
        this.fkTablePanel_ = new TablePanel(this.fkDriver_);
        this.indexTablePanel_ = new TablePanel(this.indexDriver_);
        this.triggerTablePanel_ = new TablePanel(this.triggerDriver_);
        this.columnContainer_ = new AddRemoveContainer(this.columnTablePanel_, false, "Sort", this.getColumnSortActionListener());
        this.fkContainer_ = new AddRemoveContainer((JPanel)this.fkTablePanel_, false);
        this.indexContainer_ = new AddRemoveContainer((JPanel)this.indexTablePanel_, false);
        this.triggerContainer_ = new AddRemoveContainer((JPanel)this.triggerTablePanel_, false);
        this.triggerContainer_.setEditorActionFactory(App.getEditorActionFactory());
        this.tablePropPanel_ = new TablePropPanel(this.table_);
        this.dataPanel_ = new TableDataPanel(this.table_);
        this.driversCreated_ = true;
    }

    private ActionListener getColumnSortActionListener() {
        return DbwCommandFactory.getSortColumnCmd(this.table_);
    }

    private void refresh() {
        this.refreshPanels();
        this.refreshHeaders();
    }

    private void refreshPanels() {
        String div = "";
        this.headerTitle = Table.getClassName() + div;
        if (this.table_ != null) {
            this.headerTitle = this.headerTitle + this.table_.getName();
            this.columnTablePanel_.refresh();
            this.fkTablePanel_.refresh();
            this.indexTablePanel_.refresh();
            this.triggerTablePanel_.refresh();
        }
    }

    private void refreshHeaders() {
        Schema schema = this.table_.getSchema();
        String schPrefix = schema.getDbHasManySchemas() ? schema.getName() + "." : "";
        String headerPrefix = schPrefix + this.table_.getName() + ": ";
        this.columnContainer_.setHeaderTitle(headerPrefix + this.table_.getDisplayPlural(Column.getClassName()));
        this.fkContainer_.setHeaderTitle(headerPrefix + this.table_.getDisplayPlural(ForeignKey.getClassName()));
        this.indexContainer_.setHeaderTitle(headerPrefix + this.table_.getDisplayPlural(Index.getClassName()));
        this.triggerContainer_.setHeaderTitle(headerPrefix + this.table_.getDisplayPlural(Trigger.getClassName()));
    }

    @Override
    public void update(UpdateChain chain) {
        this.refresh();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(750, 350);
    }

    @Override
    public void setIconAt(int pos, Icon icon) {
        this.tabPane_.setIconAt(pos, icon);
    }

    @Override
    public Icon getIconAt(int pos) {
        return this.tabPane_.getIconAt(pos);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public String getTitle() {
        return this.table_.getName();
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.TABLE;
    }
}

