/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ICloseVerify;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.list.NamedList;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.Icons;
import com.harrand.coregui.dataEntry.IFocusable;
import com.harrand.coregui.dialog.IParentDlgUser;
import com.harrand.coregui.display.BasicSizeStorable;
import com.harrand.coregui.display.ISizeStorable;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.list.CheckList;
import com.harrand.coregui.listener.BasicFocusListener;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.PkNameBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrench.template.BasicColumnTemplate;
import com.harrand.dbwrench.template.ColumnTemplateSvr;
import com.harrand.dbwrench.template.GeneratedColumnTemplate;
import com.harrand.dbwrench.template.IColumnTemplate;
import com.harrand.dbwrenchgui.db.SqlReservedWordGui;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListModel;

public final class TableAddPanel
extends JPanel
implements ISized,
DataEditor,
IParentDlgUser,
ISizeStorable,
ICloseVerify,
IFocusable,
ITitled {
    private Database db_;
    private Schema schema_;
    private ColumnTemplateSvr templateSrv_;
    private IOptionMgr dbOptMgr_ = null;
    private PkNameBldr pkNmBldr_;
    private JDialog parentDlg_;
    private JTabbedPane tabPane_ = new JTabbedPane(3);
    private CheckList checkList_ = new CheckList();
    private JTextField txtTableName_ = new JTextField();
    private JLabel lblTableName_ = new JLabel("Name");
    private JComboBox cboSchema_ = new JComboBox();
    private JLabel lblSchema_ = new JLabel("Schema");
    private JLabel lblComment_ = new JLabel(ResMgr.getRes("comment"));
    private JTextField txtComment_ = new JTextField();
    private JComboBox cboSort_;
    private JLabel lblSort_ = new JLabel("Sort Method");
    private JTextPane txtTemplateDesc_ = new JTextPane();
    private JTextPane txtTemplatePref_ = new JTextPane();
    private static ISizeStorable basicSizeStorable__ = new BasicSizeStorable(new Dimension(435, 410));
    private static String lastSchNm_ = null;
    public static final int USER_SORT_IDX = 1;

    public TableAddPanel(Schema schema, DbUser user, Database db) {
        this.schema_ = schema;
        this.db_ = db != null ? db : this.schema_.getDb();
        this.templateSrv_ = user.getColumnTemplateSvr();
        this.dbOptMgr_ = user.getOptionMgr("db.option.mgr");
        this.pkNmBldr_ = (PkNameBldr)DbwNameBldrSvr.instance().getNameBldr("PkNameBldr");
        this.setupGui();
    }

    @Override
    public void setParentDialog(JDialog parentDlg) {
        this.parentDlg_ = parentDlg;
    }

    public Table getTable() {
        Table newTable = null;
        String name = this.txtTableName_.getText();
        SqlReservedWordGui.instance().warnIfReserved(name);
        ITestResult result = this.validateData();
        if (result.getPassed()) {
            newTable = new Table(name);
            newTable.setComment(this.txtComment_.getText());
            boolean userSort = this.cboSort_.getSelectedIndex() == 1;
            newTable.setUseManualSort(userSort);
            this.addTemplateColumns(newTable);
            lastSchNm_ = this.getSchema().getName();
        } else {
            GuiMessageHelper.showInputErrMsg(null, result.getSummary(), result.getDetail());
        }
        return newTable;
    }

    public Schema getSchema() {
        Schema sch = this.db_.getSchema((String)this.cboSchema_.getSelectedItem());
        return sch;
    }

    private void updateCheckList() {
        if (this.templateSrv_ == null) {
            this.checkList_.setListData(new Object[0]);
            return;
        }
        NamedList columnTemplates = this.templateSrv_.getTemplates();
        Object[] checkBoxes = new Object[columnTemplates.size()];
        Iterator it = columnTemplates.iterator();
        int i = 0;
        while (it.hasNext()) {
            BasicColumnTemplate template = (BasicColumnTemplate)it.next();
            JCheckBox checkBox = new JCheckBox(template.getDisplayText());
            checkBox.setName(template.getName());
            checkBoxes[i] = checkBox;
            checkBox.setSelected(template.getUseTemplate());
            ++i;
        }
        this.checkList_.setListData(checkBoxes);
    }

    private void addTemplateColumns(Table newTable) {
        ArrayList<String> pkColumnNames = new ArrayList<String>();
        NamedList colTemplates = this.templateSrv_.getTemplates();
        ListModel model = this.checkList_.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Column column;
            JCheckBox chkBox = (JCheckBox)model.getElementAt(i);
            boolean isSelected = chkBox.isSelected();
            if (!isSelected) continue;
            IColumnTemplate template = (IColumnTemplate)colTemplates.get(i);
            if (template instanceof GeneratedColumnTemplate) {
                GeneratedColumnTemplate genTemplate = (GeneratedColumnTemplate)template;
                String oldBaseNm = genTemplate.getBaseName();
                genTemplate.setBaseName(newTable.getName());
                column = genTemplate.getColumn();
                genTemplate.setBaseName(oldBaseNm);
            } else {
                column = template.getColumn();
            }
            ITestResult result = newTable.add(column);
            if (!template.getIsPrimaryKey()) continue;
            pkColumnNames.add(column.getName());
        }
        if (!pkColumnNames.isEmpty()) {
            String pkName = this.pkNmBldr_.getFormedName(newTable.getName(), pkColumnNames);
            PrimaryKey newPk = new PrimaryKey(pkName, pkColumnNames);
            newTable.setPrimaryKey(newPk);
        }
    }

    private void setupGui() {
        this.createControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.buildListeners();
        this.addListeners();
    }

    private void createControls() {
        this.initSortCombo();
        this.initSchemaCombo();
        this.updateCheckList();
        this.txtTemplateDesc_.setText("Use column templates to automatically add common columns to tables.");
        this.txtTemplatePref_.setText("Column templates can be modified using the Preferences panel.");
    }

    private void initSortCombo() {
        Vector<String> items = new Vector<String>();
        items.add(ResMgr.getRes("sort.alpha"));
        items.add(ResMgr.getRes("sort.user"));
        this.cboSort_ = new JComboBox(items);
        if (this.dbOptMgr_ != null) {
            boolean userSort = this.dbOptMgr_.getBoolValue("table.default.sort.user");
            if (userSort) {
                this.cboSort_.setSelectedIndex(1);
            } else {
                this.cboSort_.setSelectedIndex(0);
            }
        }
    }

    private void initSchemaCombo() {
        Vector schNms = new Vector(this.db_.getKeys(Schema.getClassName()));
        this.cboSchema_ = new JComboBox(schNms);
        if (this.schema_ != null) {
            this.cboSchema_.setSelectedItem(this.schema_.getName());
        } else if (lastSchNm_ != null) {
            this.cboSchema_.setSelectedItem(lastSchNm_);
        }
    }

    private void layoutComponents() {
        this.tabPane_.add("General", this.getTableNamePanel());
        this.tabPane_.add("Column Templates", this.getTemplatesPanel());
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.tabPane_, "Center");
    }

    private JPanel getTableNamePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        GuiHelper.addEmptyBorder(panel);
        JPanel namePanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        namePanel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblTableName_, this.txtTableName_, gbc, namePanel, row++);
        GuiHelper.addGridbagPair(this.lblSchema_, this.cboSchema_, gbc, namePanel, row++);
        GuiHelper.addGridbagPair(this.lblComment_, this.txtComment_, gbc, namePanel, row++);
        GuiHelper.setTitledBorderBuffered(namePanel, "General");
        panel.add((Component)namePanel, "North");
        return panel;
    }

    private JPanel getTemplatesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        GuiHelper.addEmptyBorder(panel);
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout(4, 4));
        innerPanel.add((Component)this.txtTemplateDesc_, "North");
        innerPanel.add((Component)new JScrollPane(this.checkList_), "Center");
        innerPanel.add((Component)this.txtTemplatePref_, "South");
        GuiHelper.setTitledBorderBuffered(innerPanel, "Column Templates");
        panel.add((Component)innerPanel, "Center");
        return panel;
    }

    private JPanel getSortPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        GuiHelper.addEmptyBorder(panel);
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 2));
        innerPanel.add(this.lblSort_);
        innerPanel.add(Box.createHorizontalStrut(5));
        innerPanel.add(this.cboSort_);
        innerPanel.add(Box.createHorizontalStrut(25));
        GuiHelper.setTitledBorderBuffered(innerPanel, "Column Sorting");
        panel.add((Component)innerPanel, "North");
        return panel;
    }

    private void setCosmetics() {
        Color panColor = this.getBackground();
        Color panColorDup = new Color(panColor.getRed(), panColor.getGreen(), panColor.getBlue());
        this.txtTemplateDesc_.setBackground(panColorDup);
        this.txtTemplateDesc_.setEditable(false);
        this.txtTemplateDesc_.setForeground(Color.BLACK);
        this.txtTemplatePref_.setBackground(panColorDup);
        this.txtTemplatePref_.setEditable(false);
        this.txtTemplateDesc_.setForeground(Color.BLACK);
        this.tabPane_.setBackground(panColorDup);
    }

    private void setNames() {
        this.setName("TableAddPanel");
        this.txtTableName_.setName("txtTableName");
        this.txtComment_.setName("txtComment");
        this.tabPane_.setName("tabPane");
        this.cboSchema_.setName("cboSchema");
        this.cboSort_.setName("cboSort");
        this.checkList_.setName("checkList");
    }

    private void addListeners() {
        this.addFocusListener(this.txtTableName_);
        this.addFocusListener(this.txtComment_);
    }

    private void addFocusListener(JTextField txtField) {
        txtField.addFocusListener(new BasicFocusListener(txtField));
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(basicSizeStorable__.getSize());
    }

    private void buildListeners() {
    }

    @Override
    public void transferFocus() {
        this.txtTableName_.requestFocus();
    }

    @Override
    public Identifiable getDataObject() {
        return this.getTable();
    }

    @Override
    public String getTitle() {
        return App.getRes("table.add.label");
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.TABLE_ADD;
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
    }

    @Override
    public ITestResult validateData() {
        String newNm = this.txtTableName_.getText();
        ITestResult result = Table.validateName(newNm);
        if (result.getPassed()) {
            Schema schema = this.getSchema();
            result = this.checkSchemaValid(schema);
            if (!result.getPassed()) {
                return result;
            }
            result = schema.checkDuplicateName(Table.getClassName(), newNm);
        }
        if (result.getPassed() && this.templateSrv_ != null) {
            if (this.dbOptMgr_ != null) {
                boolean userSort = this.cboSort_.getSelectedIndex() == 1;
                this.dbOptMgr_.setBoolValue("table.default.sort.user", userSort);
            }
            this.templateSrv_.save();
        }
        return result;
    }

    private ITestResult checkSchemaValid(Schema sch) {
        if (sch == null) {
            return new DataEntryResult(false, "Schema Not Set", "Please select a schema for this table.");
        }
        return new DataEntryResult(true);
    }

    @Override
    public Collector getCollector() {
        return this.schema_;
    }

    @Override
    public boolean allowClose() {
        return this.validateData().getPassed();
    }

    @Override
    public Dimension getSize() {
        return basicSizeStorable__.getSize();
    }

    @Override
    public void setSize(Dimension size) {
        basicSizeStorable__.setSize(size);
    }
}

