/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.listener.DataEditorVerifier;
import com.harrand.coregui.listener.EditSyncActionListener;
import com.harrand.coregui.text.IntegerOnlyDoc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.security.App;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class SequenceEditPanel
extends JPanel
implements DataEditor,
IObserver,
ITitled {
    private Schema schema_;
    private Sequence sequence_;
    private String className_ = Sequence.getClassName();
    private JLabel lblName_;
    private JTextField txtName_ = new JTextField("");
    private JLabel lblComment_;
    private JTextField txtComment_ = new JTextField("");
    private JLabel lblIncrement_;
    private JTextField txtIncrement_ = new JTextField(4);
    private boolean syncOnEdit_ = false;
    private boolean startedUpdate_ = false;
    private ActionListener editSyncActionListener_;
    private InputVerifier verifier_;
    private SwingThemeCtrl themeCtrl_;

    public SequenceEditPanel(Sequence sequence) {
        this.buildControls();
        this.sequence_ = sequence;
        this.schema_ = sequence.getSchema();
        this.init();
    }

    public SequenceEditPanel(Schema schema) {
        this.buildControls();
        this.sequence_ = null;
        this.schema_ = schema;
        this.init();
    }

    private void init() {
        this.schema_.addObserver(this);
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
        this.loadData();
        this.buildListeners();
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
        this.syncOnEdit_ = sync;
        if (this.syncOnEdit_) {
            this.txtName_.setInputVerifier(this.verifier_);
            this.txtName_.addActionListener(this.editSyncActionListener_);
            this.txtComment_.setInputVerifier(this.verifier_);
            this.txtComment_.addActionListener(this.editSyncActionListener_);
            this.txtIncrement_.setInputVerifier(this.verifier_);
            this.txtIncrement_.addActionListener(this.editSyncActionListener_);
        } else {
            this.txtName_.setInputVerifier(null);
            this.txtName_.addActionListener(this.editSyncActionListener_);
            this.txtComment_.setInputVerifier(null);
            this.txtComment_.removeActionListener(this.editSyncActionListener_);
            this.txtIncrement_.setInputVerifier(null);
            this.txtIncrement_.removeActionListener(this.editSyncActionListener_);
        }
    }

    private void buildListeners() {
        this.editSyncActionListener_ = new EditSyncActionListener(this);
        this.verifier_ = new DataEditorVerifier(this);
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void buildControls() {
        String div = "";
        this.lblName_ = new JLabel(App.getRes("sequence.name.label") + div);
        this.lblIncrement_ = new JLabel("Increment" + div);
        this.lblComment_ = new JLabel("Comment" + div);
    }

    private void loadData() {
        if (this.sequence_ != null) {
            this.txtName_.setText(this.sequence_.getName());
            this.txtComment_.setText(this.sequence_.getComment());
            this.txtIncrement_.setText(Integer.toString(this.sequence_.getIncrement()));
        } else {
            this.txtName_.setText("");
            this.txtComment_.setText("");
            this.txtIncrement_.setText("1");
        }
    }

    private void layoutComponents() {
        JPanel namePanel = new JPanel();
        JPanel textPanel = new JPanel();
        this.buildNamePanel(namePanel);
        int inset = 4;
        this.setBorder(GuiHelper.getEmptyBorder());
        this.themeCtrl_.process(namePanel);
        this.setLayout(new BorderLayout(0, 4));
        this.add((Component)namePanel, "North");
    }

    private void buildNamePanel(JPanel panel) {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblName_, this.txtName_, gbc, panel, row++);
        GuiHelper.addGridbagPair(this.lblComment_, this.txtComment_, gbc, panel, row++);
        GuiHelper.addGridbagPairFixed(this.lblIncrement_, this.txtIncrement_, gbc, panel, row++);
    }

    private void setNames() {
        this.setName("SequenceEditPanel");
        this.lblName_.setName("lblName");
        this.txtName_.setName("txtName");
        this.txtComment_.setName("txtComment");
        this.lblIncrement_.setName("lblIncrement");
        this.txtIncrement_.setName("txtIncrement");
    }

    private void setCosmetics() {
        this.txtIncrement_.setDocument(new IntegerOnlyDoc());
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.lblName_);
        this.themeCtrl_.process(this.txtName_);
        this.themeCtrl_.process(this.lblComment_);
        this.themeCtrl_.process(this.txtComment_);
        this.themeCtrl_.process(this.txtIncrement_);
    }

    private void addListeners() {
        this.addListenersGetFocus();
    }

    private void addListenersGetFocus() {
    }

    public Sequence getSequence() {
        this.validateData();
        return this.sequence_;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getSequence();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 350, 210);
    }

    private void syncData() throws Exception {
        String name = this.txtName_.getText();
        String comment = this.txtComment_.getText();
        int increment = Integer.parseInt(this.txtIncrement_.getText());
        ITestResult result = Sequence.checkValues(name, increment);
        if (!result.getPassed()) {
            throw new Exception(result.getDetail());
        }
        Sequence newSequence = new Sequence(name, increment, comment);
        BasicCollector.verifyNoDups(this.schema_, this.sequence_, newSequence);
        if (this.syncOnEdit_ && this.sequence_ != null) {
            this.startedUpdate_ = true;
            Sequence oldSeq = this.sequence_;
            this.sequence_ = newSequence;
            UpdateInCollector.doUpdate(this.schema_, oldSeq, this.sequence_, App.getCommandChain(), null);
        }
        this.sequence_ = newSequence;
    }

    @Override
    public ITestResult validateData() {
        DataEntryResult result;
        block2: {
            try {
                this.syncData();
                result = new DataEntryResult(true);
            }
            catch (Exception e) {
                result = new DataEntryResult(false, e.getMessage());
                if (this.sequence_ == null) break block2;
                this.loadData();
            }
        }
        return result;
    }

    @Override
    public void update(UpdateChain chain) {
        if (!this.startedUpdate_ && chain.hasClassName(this.className_) && this.sequence_ != null) {
            this.sequence_ = this.schema_.getKeys(this.className_).contains(this.sequence_.getName()) ? (Sequence)this.schema_.get(this.className_, this.sequence_.getName()) : null;
            this.loadData();
        }
        this.startedUpdate_ = false;
    }

    @Override
    public String getTitle() {
        StringBuffer sb = this.sequence_ == null ? new StringBuffer(ResMgr.getRes("add.label")) : new StringBuffer(ResMgr.getRes("edit.label"));
        sb.append(" " + App.getRes("sequence.label"));
        return sb.toString();
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.SEQUENCE;
    }

    @Override
    public Collector getCollector() {
        return this.schema_;
    }
}

