/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.EditDialog;
import com.harrand.coregui.Icons;
import com.harrand.coregui.button.ButtonUtil;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.display.BasicSizeStorable;
import com.harrand.coregui.display.ISizeStorable;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.list.DualListPanel;
import com.harrand.coregui.list.renderer.CustomTextListRendered;
import com.harrand.coregui.listener.DataEditorVerifier;
import com.harrand.coregui.listener.EditSyncActionListener;
import com.harrand.coregui.listener.EditSyncListDataListener;
import com.harrand.coregui.text.TextInputPanel;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.IndexNameBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.index.ColumnFunction;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.dbwrench.security.App;
import com.harrand.util.FileHelper;
import com.harrand.util.Validator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListDataListener;

public final class IndexEditPanel
extends JPanel
implements DataEditor,
IObserver,
ISizeStorable,
ITitled {
    private Table table_;
    private Index index_;
    private String className_;
    private List tableColumns_;
    private GridBagLayout gbl = new GridBagLayout();
    private DualListPanel dualListPanel;
    private JLabel lblName_;
    private JLabel lblOptionText;
    private JTextField txtName_ = new JTextField("");
    private JTextField txtOptionText = new JTextField("");
    private JCheckBox chkUnique_;
    private JCheckBox chkClustered_;
    private JCheckBox chkFullText;
    private JCheckBox chkSpatial;
    private JButton btnAutoName_ = ButtonUtil.getAutonameBtn();
    private JButton btnAddColumnFunction = new JButton("Add Column Function");
    private boolean syncOnEdit_ = false;
    private boolean startedUpdate_ = false;
    private ActionListener editSyncActionListener_;
    private ListDataListener editSyncListDataListener_;
    private InputVerifier verifier_;
    private SwingThemeCtrl ctrl_;
    private static ISizeStorable basicSizeStorable__ = new BasicSizeStorable(new Dimension(470, 430));
    private static final String ERR_MSG_NULL_TABLE = "Table columns must be specified.\nOtherwise a list of columns for the index_ can not be shown.";

    public IndexEditPanel(Index theIndex, Table table) throws IllegalArgumentException {
        this.index_ = theIndex;
        this.table_ = table;
        this.tableColumns_ = this.table_.values(Column.getClassName());
        this.className_ = Index.getClassName();
        this.checkInputs(this.index_, this.tableColumns_);
        this.table_.addObserver(this);
        this.ctrl_ = App.getThemeCtrl();
        this.setupGui();
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
        this.syncOnEdit_ = sync;
        if (this.syncOnEdit_) {
            this.txtName_.setInputVerifier(this.verifier_);
            this.txtName_.addActionListener(this.editSyncActionListener_);
            this.chkClustered_.addActionListener(this.editSyncActionListener_);
            this.chkUnique_.addActionListener(this.editSyncActionListener_);
            this.chkFullText.addActionListener(this.editSyncActionListener_);
            this.chkSpatial.addActionListener(this.editSyncActionListener_);
            this.dualListPanel.addListDataListener(this.editSyncListDataListener_);
        } else {
            this.txtName_.setInputVerifier(null);
            this.txtName_.removeActionListener(this.editSyncActionListener_);
            this.chkClustered_.removeActionListener(this.editSyncActionListener_);
            this.chkUnique_.removeActionListener(this.editSyncActionListener_);
            this.chkFullText.removeActionListener(this.editSyncActionListener_);
            this.chkSpatial.removeActionListener(this.editSyncActionListener_);
            this.dualListPanel.removeListDataListener(this.editSyncListDataListener_);
        }
    }

    public void preAddColumn(Column column) {
        this.dualListPanel.moveLeft(column);
    }

    private void buildListeners() {
        this.editSyncActionListener_ = new EditSyncActionListener(this);
        this.editSyncListDataListener_ = new EditSyncListDataListener(this);
        this.verifier_ = new DataEditorVerifier(this);
        this.btnAddColumnFunction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexEditPanel.this.showAddColumnFunctionPanel();
            }
        });
    }

    private List<IIndexColumn> getSelectIndexColumns() {
        Object[] selectedObjs = this.dualListPanel.getLeftItems();
        ArrayList<IIndexColumn> indexCols = new ArrayList<IIndexColumn>();
        for (Object nameObj : selectedObjs) {
            if (!(nameObj instanceof IIndexColumn)) continue;
            IIndexColumn indexColumn = (IIndexColumn)nameObj;
            indexCols.add(indexColumn);
        }
        return indexCols;
    }

    private void setupGui() {
        this.initComponents();
        this.buildControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.loadData();
        this.buildListeners();
        this.addListeners();
    }

    private void checkInputs(Index theIndex, List theTableColumns) throws IllegalArgumentException {
        if (theTableColumns == null) {
            throw new IllegalArgumentException(ERR_MSG_NULL_TABLE);
        }
    }

    private void showAddColumnFunctionPanel() {
        TextInputPanel textPanel = new TextInputPanel("Function Text", "");
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, textPanel, textPanel.getPreferredBounds(), "Add Index Column Function");
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            String functionText = textPanel.getText();
            this.dualListPanel.addToLeftList(new ColumnFunction(functionText));
        }
    }

    private void buildControls() {
        String div = "";
        this.lblName_ = new JLabel(FileHelper.getResource("name.label") + div);
        this.lblOptionText = new JLabel("Option Text" + div);
        this.chkClustered_ = new JCheckBox(App.getResouceStringApp("clustered.label"));
        this.chkUnique_ = new JCheckBox(App.getResouceStringApp("unique.label"));
        this.chkFullText = new JCheckBox("Full Text");
        this.chkSpatial = new JCheckBox("Spatial");
        this.dualListPanel = new DualListPanel(new ArrayList().toArray(), new ArrayList().toArray(), new CustomTextListRendered());
    }

    private void loadData() {
        if (this.index_ != null) {
            this.txtName_.setText(this.index_.getName());
            this.txtOptionText.setText(this.index_.getOptionText());
            this.chkClustered_.setSelected(this.index_.getClusteredFlag());
            this.chkUnique_.setSelected(this.index_.getUnique());
            this.chkFullText.setSelected(this.index_.getFullText());
            this.chkSpatial.setSelected(this.index_.getSpatial());
        } else {
            this.txtName_.setText("");
            this.txtOptionText.setText("");
            this.chkClustered_.setSelected(false);
            this.chkUnique_.setSelected(false);
            this.chkFullText.setSelected(false);
            this.chkSpatial.setSelected(false);
        }
        this.loadDualListData();
    }

    private void setNames() {
        this.setName("IndexEditPanel");
        this.lblName_.setName("lblName");
        this.txtName_.setName("txtName");
        this.chkClustered_.setName("chkClustered");
        this.chkUnique_.setName("chkUnique");
        this.dualListPanel.setName("columnPanel");
        this.btnAutoName_.setName("btnAutoName");
    }

    private void loadDualListData() {
        this.dualListPanel.removeListDataListener(this.editSyncListDataListener_);
        List<Object> usedColumns = this.index_ == null ? new ArrayList() : this.index_.getIndexColumns();
        ArrayList<Column> remainingColumns = new ArrayList<Column>(this.table_.getColumns());
        for (IIndexColumn iIndexColumn : usedColumns) {
            if (!(iIndexColumn instanceof Column)) continue;
            remainingColumns.remove((Column)iIndexColumn);
        }
        this.dualListPanel.setData(usedColumns.toArray(), remainingColumns.toArray());
        if (this.syncOnEdit_) {
            this.dualListPanel.addListDataListener(this.editSyncListDataListener_);
        }
    }

    private void layoutComponents() {
        GuiHelper.addEmptyBorder(this);
        this.setLayout(new BorderLayout());
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel topPanel = new JPanel();
        topPanel.setLayout(gbl);
        this.ctrl_.process(topPanel);
        int row = 0;
        GuiHelper.buildGridBagConstraints(gbc, 0, 0, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 13;
        topPanel.add((Component)this.lblName_, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 1, 0, 1, 1, 70.0, 0.0);
        gbc.fill = 2;
        topPanel.add((Component)this.txtName_, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 2, 0, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 17;
        topPanel.add((Component)this.btnAutoName_, gbc);
        JPanel rowPanelA = new JPanel(new GridLayout(1, 3));
        this.ctrl_.process(rowPanelA);
        rowPanelA.add(this.chkUnique_);
        rowPanelA.add(this.chkFullText);
        rowPanelA.add(this.chkSpatial);
        gbc = new GridBagConstraints();
        int n = ++row;
        ++row;
        GuiHelper.addGridbagPair(new JLabel(), rowPanelA, gbc, topPanel, n);
        JPanel rowPanelB = new JPanel(new GridLayout(1, 1));
        this.ctrl_.process(rowPanelB);
        rowPanelB.add(this.chkClustered_);
        gbc = new GridBagConstraints();
        int n2 = ++row;
        ++row;
        GuiHelper.addGridbagPair(new JLabel(), rowPanelB, gbc, topPanel, n2);
        this.add((Component)topPanel, "North");
        this.add((Component)this.dualListPanel, "Center");
        this.add((Component)this.getOptionTextPanel(), "South");
    }

    private JPanel getOptionTextPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gblLocal = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gblLocal);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblOptionText, this.txtOptionText, gbc, panel, row++);
        GuiHelper.addGridbagPairFixed(new JLabel(), this.btnAddColumnFunction, gbc, panel, row++);
        int th = 10;
        panel.setBorder(BorderFactory.createEmptyBorder(th, 0, 0, 0));
        return panel;
    }

    private void setCosmetics() {
        this.ctrl_.process(this);
        this.ctrl_.process(this.lblName_);
        this.ctrl_.process(this.txtName_);
        this.ctrl_.process(this.chkClustered_);
        this.ctrl_.process(this.chkUnique_);
        this.dualListPanel.setLeftLabel(Index.LBL_USED_COLUMNS);
        this.dualListPanel.setRightLabel(Index.LBL_NOT_USED_COLUMNS);
        this.chkClustered_.setMnemonic('L');
        this.chkUnique_.setMnemonic('U');
    }

    private void syncData() throws Exception {
        Index newIndex_ = null;
        String name = this.txtName_.getText();
        boolean clusteredFlag = this.chkClustered_.isSelected();
        boolean unique = this.chkUnique_.isSelected();
        boolean fullText = this.chkFullText.isSelected();
        boolean spatial = this.chkSpatial.isSelected();
        String optionText = this.txtOptionText.getText();
        List<IIndexColumn> indexCols = this.getSelectIndexColumns();
        newIndex_ = new Index(name, indexCols, clusteredFlag, unique);
        newIndex_.setFullText(fullText);
        newIndex_.setSpatial(spatial);
        newIndex_.setOptionText(optionText);
        BasicCollector.verifyNoDups(this.table_, this.index_, newIndex_);
        if (this.syncOnEdit_) {
            if (this.index_ != null) {
                this.startedUpdate_ = true;
                Index oldIdx = this.index_;
                this.index_ = newIndex_;
                UpdateInCollector.doUpdate(this.table_, oldIdx, this.index_, App.getCommandChain(), null);
            }
        } else {
            this.index_ = newIndex_;
        }
        this.startedUpdate_ = false;
    }

    @Override
    public ITestResult validateData() {
        DataEntryResult result;
        block2: {
            try {
                this.syncData();
                result = new DataEntryResult(true);
            }
            catch (Exception e) {
                result = new DataEntryResult(false, e.getMessage());
                if (this.index_ == null) break block2;
                this.loadData();
            }
        }
        return result;
    }

    @Override
    public void update(UpdateChain chain) {
        if (!this.startedUpdate_ && chain.hasClassName(this.className_) && this.index_ != null) {
            this.index_ = this.table_.getKeys(this.className_).contains(this.index_.getName()) ? (Index)this.table_.get(this.className_, this.index_.getName()) : null;
            this.loadData();
        }
    }

    @Override
    public String getTitle() {
        String title = this.index_ == null ? FileHelper.getResource("add.label") : FileHelper.getResource("edit.label");
        return title + " " + App.getResource("index.label");
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.INDEX;
    }

    public Index getIndex() {
        this.validateData();
        return this.index_;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getIndex();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(basicSizeStorable__.getSize());
    }

    @Override
    public Dimension getSize() {
        return basicSizeStorable__.getSize();
    }

    @Override
    public void setSize(Dimension size) {
        basicSizeStorable__.setSize(size);
    }

    private void addListeners() {
        this.btnAutoName_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexEditPanel.this.setAutoName();
            }
        });
    }

    public void setAutoName() {
        Object[] leftItems = this.dualListPanel.getLeftItems();
        if (leftItems.length == 0) {
            GuiMessageHelper.showInputErrMsg(null, "No Columns Specified", "At least one column must be specified before an index name can be generated.");
            return;
        }
        DbwNameBldrSvr bldrSvr = DbwNameBldrSvr.instance();
        IndexNameBldr nameBldr = (IndexNameBldr)bldrSvr.getNameBldr("IndexNameBldr");
        List<IIndexColumn> indexCoumns = this.getSelectIndexColumns();
        try {
            Index tempIndex = new Index("tempName", indexCoumns, this.chkClustered_.isSelected(), this.chkUnique_.isSelected());
            String builtName = nameBldr.getFormedName(this.table_, tempIndex);
            this.txtName_.setText(builtName);
        }
        catch (Exception e) {
            GuiMessageHelper.showInputErrMsg(null, "Input Error", e.getMessage());
        }
    }

    private void ValidateField(JTextField parentField) {
        try {
            if (parentField.getName() == "txtName_") {
                Validator.isStringEmpty(this.txtName_.getText(), "index_ name");
            } else if (parentField.getName() == "txtColumns") {
                Validator.isStringEmpty(this.txtName_.getText(), "column names");
            }
        }
        catch (IllegalArgumentException e) {
            GuiMessageHelper.showInputErrMsg(parentField, "Out of Range.", e.getMessage());
        }
    }

    @Override
    public Collector getCollector() {
        return this.table_;
    }

    private void initComponents() {
        this.setLayout(null);
    }
}

