/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.db.joint.CardinalityFactory;
import com.harrand.coreclasses.db.joint.EJointType;
import com.harrand.coreclasses.element.Cardinality;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.button.ButtonUtil;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.coregui.display.BasicSizeStorable;
import com.harrand.coregui.display.ISizeStorable;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.list.ComboListPanel;
import com.harrand.coregui.listener.DataEditorVerifier;
import com.harrand.coregui.listener.EditSyncActionListener;
import com.harrand.coregui.panel.AddRemovePanel;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.FkNameBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.sub.FkPairLinkPanel;
import com.harrand.sketch.panel.CardinalityPanel;
import com.harrand.util.ErrMsg;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.ResMgr;
import com.harrand.util.Validator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public final class ForeignKeyPanel
extends JPanel
implements DataEditor,
IObserver,
ISizeStorable,
ITitled {
    private Database db_;
    private String className_;
    private ForeignKey fk_;
    private JTabbedPane tabbedPane_ = new JTabbedPane(3);
    private List columnPairs_ = new ArrayList();
    private ComboListPanel parentPanel_;
    private ComboListPanel childPanel_;
    private List tableNames_;
    private AddRemovePanel addRemovePanel_ = new AddRemovePanel();
    private JLabel lblName_;
    private JLabel lblColumnPair_;
    private JTextField txtName_ = new JTextField("");
    private JLabel lblDescFix_;
    private JLabel lblDescVar_ = new JLabel(" ");
    private JButton btnAutoName_ = ButtonUtil.getAutonameBtn();
    private JLabel lblComment_ = new JLabel(ResMgr.getRes("comment"));
    private JTextField txtComment_ = new JTextField("");
    private CardinalityPanel childCardiPanel_;
    private FkPairLinkPanel pairLinkPanel_ = new FkPairLinkPanel(new ArrayList(), "");
    private ButtonGroup delActionGrp_ = new ButtonGroup();
    private JRadioButton rdoDelNoAction_ = new JRadioButton("No Action");
    private JRadioButton rdoDelCascade_ = new JRadioButton("Cascade");
    private JRadioButton rdoDelRestrict_ = new JRadioButton("Restrict");
    private JRadioButton rdoDelSetNull_ = new JRadioButton("Set Null");
    private JRadioButton rdoDelSetDefault_ = new JRadioButton("Set Default");
    private ButtonGroup updActionGrp_ = new ButtonGroup();
    private JRadioButton rdoUpdNoAction_ = new JRadioButton("No Action");
    private JRadioButton rdoUpdCascade_ = new JRadioButton("Cascade");
    private JRadioButton rdoUpdRestrict_ = new JRadioButton("Restrict");
    private JRadioButton rdoUpdSetNull_ = new JRadioButton("Set Null");
    private JRadioButton rdoUpdSetDefault_ = new JRadioButton("Set Default");
    private SwingThemeCtrl ctrl_;
    private JList columnPairList_ = new JList();
    private DefaultListModel pairModel_ = new DefaultListModel();
    private ActionListener removePairListener_;
    private ActionListener addPairListener_;
    private ActionListener parentListener_;
    private ActionListener childListener_;
    private ActionListener lisValidate_;
    private boolean loadingData_ = false;
    private boolean syncOnEdit_ = false;
    private boolean startedUpdate_ = false;
    private ActionListener editSyncActionListener_;
    private InputVerifier verifier_;
    private static ISizeStorable basicSizeStorable__ = new BasicSizeStorable(new Dimension(532, 390));

    public ForeignKeyPanel(ForeignKey foreignKey, Database db) {
        this.initComponents();
        this.setDatabase(db);
        this.className_ = ForeignKey.getClassName();
        this.ctrl_ = App.getThemeCtrl();
        this.setupGui();
        this.setForeignKey(foreignKey);
    }

    public void setForeignKey(ForeignKey foreignKey) {
        this.fk_ = foreignKey;
        this.loadData();
    }

    public void setDatabase(Database db) {
        this.db_ = db;
    }

    public void refresh() {
        this.refreshTblNms();
        this.childPanel_.setComboItems(this.tableNames_);
        this.parentPanel_.setComboItems(this.tableNames_);
    }

    private void setupGui() {
        this.buildControls();
        this.setModels();
        this.addPanels();
        this.setCosmetics();
        this.buildListeners();
        this.addListeners();
        this.setNames();
    }

    private void setModels() {
        this.columnPairList_.setModel(this.pairModel_);
    }

    private void buildControls() {
        String div = "";
        this.lblName_ = new JLabel(FileHelper.getResource("name.label") + div);
        this.lblColumnPair_ = new JLabel(App.getResouceStringApp("foreignKey.column.pair.label") + div);
        this.lblDescFix_ = new JLabel(App.getResouceStringApp("foreignKey.desc.fix.label") + div);
        this.refreshTblNms();
        this.parentPanel_ = new ComboListPanel(" Parent Table:", " Columns:", this.tableNames_);
        this.childPanel_ = new ComboListPanel(" Child Table:", " Columns:", this.tableNames_);
        this.delActionGrp_.add(this.rdoDelNoAction_);
        this.delActionGrp_.add(this.rdoDelRestrict_);
        this.delActionGrp_.add(this.rdoDelCascade_);
        this.delActionGrp_.add(this.rdoDelSetNull_);
        this.delActionGrp_.add(this.rdoDelSetDefault_);
        this.updActionGrp_.add(this.rdoUpdNoAction_);
        this.updActionGrp_.add(this.rdoUpdRestrict_);
        this.updActionGrp_.add(this.rdoUpdCascade_);
        this.updActionGrp_.add(this.rdoUpdSetNull_);
        this.updActionGrp_.add(this.rdoUpdSetDefault_);
    }

    private void refreshTblNms() {
        this.tableNames_ = new ArrayList();
        for (Table tbl : this.db_.getAllTables()) {
            this.tableNames_.add(tbl.getSchemaBracket());
        }
        Collections.sort(this.tableNames_);
    }

    public void setChildTable(Table table) {
        String tblBracketNm = table.getSchemaBracket();
        this.childPanel_.getCombo().setSelectedItem(tblBracketNm);
    }

    public void setParentTable(Table table) {
        String tblBracketNm = table.getSchemaBracket();
        this.parentPanel_.getCombo().setSelectedItem(tblBracketNm);
    }

    private void lockChildTable() {
        this.childPanel_.lockComboBox();
        this.childPanel_.getCombo().setToolTipText("To edit the child table, this foreign key must be removed and a new one added.");
    }

    private void lockParentTable() {
        this.parentPanel_.lockComboBox();
        this.parentPanel_.getCombo().setToolTipText("To edit the parent table, double click on the treenode for this foreing key.");
    }

    private void loadData() {
        this.loadingData_ = true;
        if (this.fk_ != null) {
            this.txtName_.setText(this.fk_.getName());
            this.lblDescVar_.setText(this.fk_.toString());
            this.setParentTable(this.fk_.getParTbl());
            this.setChildTable(this.fk_.getChdTbl());
            this.columnPairs_ = new ArrayList(this.fk_.getColumns());
            this.refreshPairList();
            this.txtComment_.setText(this.fk_.getComment());
            this.childCardiPanel_.setSelectedCardinality(this.fk_.getChildCardinality());
            this.pairLinkPanel_.setSelectedParentLinkColNm(this.fk_.getParentLinkColNm());
            this.loadDeleteAction();
            this.loadUpdateAction();
            this.lockChildTable();
        } else {
            this.txtName_.setText("");
            this.lblDescVar_.setText("");
            this.txtComment_.setText("");
            this.childCardiPanel_.setSelectedCardinality(ForeignKey.getDefaultCardinality(1));
            this.rdoDelNoAction_.setSelected(true);
            this.rdoUpdNoAction_.setSelected(true);
            this.columnPairs_ = new ArrayList();
            this.refreshPairList();
        }
        this.loadingData_ = false;
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
        this.syncOnEdit_ = sync;
        if (this.syncOnEdit_) {
            this.txtName_.setInputVerifier(this.verifier_);
            this.txtName_.addActionListener(this.editSyncActionListener_);
            this.txtComment_.setInputVerifier(this.verifier_);
            this.txtComment_.addActionListener(this.editSyncActionListener_);
            this.lockParentTable();
        } else {
            this.txtName_.setInputVerifier(null);
            this.txtName_.removeActionListener(this.editSyncActionListener_);
            this.txtComment_.setInputVerifier(null);
            this.txtComment_.removeActionListener(this.editSyncActionListener_);
        }
    }

    private void addPanels() {
        this.tabbedPane_.addTab("General", this.getGeneralPanel());
        this.tabbedPane_.addTab("Details", this.getDetailsPanel());
        this.tabbedPane_.addTab("Advanced", this.getAdvancedPanel());
        this.setLayout(new BorderLayout());
        GuiHelper.addEmptyBorder(this);
        this.add(this.tabbedPane_);
    }

    private JPanel getGeneralPanel() {
        JPanel generalPanel = new JPanel();
        GuiHelper.addEmptyBorder(this);
        int insetSize = 3;
        int strutWidth = 15;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel northPanel = new JPanel(gbl);
        GuiHelper.buildGridBagConstraints(gbc, 0, 0, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 13;
        northPanel.add((Component)this.lblName_, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 1, 0, 1, 1, 70.0, 0.0);
        gbc.fill = 2;
        northPanel.add((Component)this.txtName_, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 2, 0, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 17;
        northPanel.add((Component)this.btnAutoName_, gbc);
        JPanel pairPanel = new JPanel(new BorderLayout(insetSize, insetSize));
        pairPanel.add((Component)this.lblColumnPair_, "North");
        pairPanel.add((Component)new JScrollPane(this.columnPairList_), "Center");
        pairPanel.add((Component)this.addRemovePanel_, "South");
        JPanel southBox = new JPanel(new GridLayout(1, 3, strutWidth, 0));
        southBox.add(this.childPanel_);
        southBox.add(pairPanel);
        southBox.add(this.parentPanel_);
        this.ctrl_.process(southBox);
        generalPanel.setBorder(new EmptyBorder(new Insets(insetSize, insetSize, insetSize, insetSize)));
        generalPanel.setLayout(new BorderLayout());
        this.ctrl_.process(pairPanel);
        this.ctrl_.process(northPanel);
        generalPanel.add((Component)northPanel, "North");
        generalPanel.add((Component)southBox, "Center");
        GuiHelper.addEmptyBorder(generalPanel);
        return generalPanel;
    }

    private JPanel getDetailsPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel(gbl);
        GuiHelper.buildGridBagConstraints(gbc, 0, 0, 1, 1, 100.0, 10.0);
        gbc.fill = 2;
        gbc.anchor = 18;
        panel.add((Component)this.getCommentPanel(), gbc);
        GuiHelper.buildGridBagConstraints(gbc, 0, 1, 1, 1, 100.0, 10.0);
        gbc.fill = 2;
        gbc.anchor = 18;
        panel.add((Component)this.getCardinalityPanel(), gbc);
        GuiHelper.buildGridBagConstraints(gbc, 0, 2, 1, 1, 100.0, 10.0);
        gbc.fill = 2;
        gbc.anchor = 18;
        this.pairLinkPanel_.addObserver(this);
        panel.add((Component)this.pairLinkPanel_, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 0, 3, 1, 1, 100.0, 50.0);
        gbc.fill = 1;
        gbc.anchor = 18;
        panel.add((Component)new JLabel(), gbc);
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private JPanel getAdvancedPanel() {
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.add((Component)this.getActionPanel(), "North");
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private JPanel getCommentPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblComment_, this.txtComment_, gbc, panel, row++);
        return panel;
    }

    private JPanel getCardinalityPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 2, 60, 5));
        this.childCardiPanel_ = new CardinalityPanel("Child", Cardinality.getDefaultCardinalityList(1));
        this.childCardiPanel_.addObserver(this);
        panel.add(this.childCardiPanel_);
        GuiHelper.setTitledBorderBuffered(panel, "Cardinality");
        return panel;
    }

    private JPanel getActionPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(this.getOnDelPanel());
        panel.add(this.getOnUpdPanel());
        return panel;
    }

    private JPanel getOnDelPanel() {
        JPanel panel = new JPanel(new GridLayout(5, 1));
        panel.add(this.rdoDelNoAction_);
        panel.add(this.rdoDelRestrict_);
        panel.add(this.rdoDelCascade_);
        panel.add(this.rdoDelSetNull_);
        panel.add(this.rdoDelSetDefault_);
        panel.setBorder(BorderFactory.createTitledBorder("On Delete Action"));
        return panel;
    }

    private JPanel getOnUpdPanel() {
        JPanel panel = new JPanel(new GridLayout(5, 1));
        panel.add(this.rdoUpdNoAction_);
        panel.add(this.rdoUpdRestrict_);
        panel.add(this.rdoUpdCascade_);
        panel.add(this.rdoUpdSetNull_);
        panel.add(this.rdoUpdSetDefault_);
        panel.setBorder(BorderFactory.createTitledBorder("On Update Action"));
        return panel;
    }

    private void setCosmetics() {
        this.ctrl_.process(this);
        this.ctrl_.process(this.lblName_);
        this.ctrl_.process(this.txtName_);
        this.ctrl_.process(this.lblColumnPair_);
        this.ctrl_.process(this.lblDescVar_);
        this.ctrl_.process(this.columnPairList_);
        this.columnPairList_.setSelectionMode(2);
        this.addRemovePanel_.setButtonAppendedText(App.getRes("foreignKey.column.pair.label"));
        this.parentPanel_.getList().setSelectionMode(0);
        this.childPanel_.getList().setSelectionMode(0);
    }

    private void buildListeners() {
        this.editSyncActionListener_ = new EditSyncActionListener(this);
        this.verifier_ = new DataEditorVerifier(this);
    }

    private void addListeners() {
        this.addPairListener_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ForeignKeyPanel.this.addColumnPair();
            }
        };
        this.removePairListener_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ForeignKeyPanel.this.removeColumnPairs();
            }
        };
        this.btnAutoName_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ForeignKeyPanel.this.setAutoName();
            }
        });
        this.lisValidate_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ForeignKeyPanel.this.checkValidate();
            }
        };
        this.rdoDelCascade_.addActionListener(this.lisValidate_);
        this.rdoDelNoAction_.addActionListener(this.lisValidate_);
        this.rdoDelRestrict_.addActionListener(this.lisValidate_);
        this.rdoDelSetDefault_.addActionListener(this.lisValidate_);
        this.rdoDelSetNull_.addActionListener(this.lisValidate_);
        this.rdoUpdCascade_.addActionListener(this.lisValidate_);
        this.rdoUpdNoAction_.addActionListener(this.lisValidate_);
        this.rdoUpdRestrict_.addActionListener(this.lisValidate_);
        this.rdoUpdSetDefault_.addActionListener(this.lisValidate_);
        this.rdoUpdSetNull_.addActionListener(this.lisValidate_);
        this.parentListener_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tblBracketNm = (String)((JComboBox)e.getSource()).getSelectedItem();
                if (tblBracketNm != null) {
                    Table table = ForeignKeyPanel.this.db_.getTableFromSchemaBracket(tblBracketNm);
                    ForeignKeyPanel.this.parentPanel_.setListItems(new ArrayList(table.getItemNames(Column.getClassName())));
                    ForeignKeyPanel.this.clearPairList();
                }
            }
        };
        this.childListener_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tblBracketNm = (String)((JComboBox)e.getSource()).getSelectedItem();
                if (tblBracketNm != null) {
                    Table table = ForeignKeyPanel.this.db_.getTableFromSchemaBracket(tblBracketNm);
                    ForeignKeyPanel.this.childPanel_.setListItems(new ArrayList(table.getItemNames(Column.getClassName())));
                    ForeignKeyPanel.this.clearPairList();
                }
            }
        };
        this.addRemovePanel_.btnAdd.addActionListener(this.addPairListener_);
        this.addRemovePanel_.btnRemove.addActionListener(this.removePairListener_);
        this.parentPanel_.setComboListener(this.parentListener_);
        this.childPanel_.setComboListener(this.childListener_);
        this.parentPanel_.forceListReload();
        this.childPanel_.forceListReload();
    }

    private void setNames() {
        this.setName("ForeignKeyPanel");
        this.tabbedPane_.setName("tabbedPane");
        this.parentPanel_.setName("parentPanel");
        this.childPanel_.setName("childPanel");
        this.lblName_.setName("lblName");
        this.txtName_.setName("txtName");
        this.btnAutoName_.setName("btnAutoName");
        this.addRemovePanel_.setName("addRemovePanel");
        this.lblColumnPair_.setName("lblColumnPair");
        this.columnPairList_.setName("columnPairList");
        this.txtComment_.setName("txtComment");
        this.childCardiPanel_.setName("childCardiPanel");
        this.rdoDelNoAction_.setName("rdoDelNoAction");
        this.rdoDelRestrict_.setName("rdoDelRestrict");
        this.rdoDelCascade_.setName("rdoDelCascade");
        this.rdoDelSetNull_.setName("rdoDelSetNull");
        this.rdoDelSetDefault_.setName("rdoDelSetDefault");
        this.rdoUpdNoAction_.setName("rdoUpdNoAction");
        this.rdoUpdRestrict_.setName("rdoUpdRestrict");
        this.rdoUpdCascade_.setName("rdoUpdCascade");
        this.rdoUpdSetNull_.setName("rdoUpdSetNull");
        this.rdoUpdSetDefault_.setName("rdoUpdSetDefault");
    }

    private void setAutoName() {
        if (this.columnPairs_.size() == 0) {
            GuiMessageHelper.showInputErrMsg(null, "No Column Pairs Specified", "At least one column pair must be specified before a foreign key name can be generated.");
            return;
        }
        DbwNameBldrSvr bldrSvr = DbwNameBldrSvr.instance();
        FkNameBldr nameBldr = (FkNameBldr)bldrSvr.getNameBldr("FkNameBldr");
        Table parTbl = this.getSelectedTbl(this.parentPanel_);
        Table chdTbl = this.getSelectedTbl(this.childPanel_);
        try {
            ForeignKey tempFk = new ForeignKey("tempName", parTbl, chdTbl, this.columnPairs_, this.getDelActionSelected(), this.getUpdActionSelected(), "", this.childCardiPanel_.getSelectedCardinality(), this.pairLinkPanel_.getSelectedParentLinkColNm());
            String builtName = nameBldr.getFormedName(tempFk);
            this.txtName_.setText(builtName);
            ITestResult iTestResult = this.validateData();
        }
        catch (Exception e) {
            GuiMessageHelper.showInputErrMsg(null, "Input Error", e.getMessage());
        }
    }

    private Cardinality getParentCardinality() {
        return CardinalityFactory.createCardinality(this.fk_, EJointType.PARENT);
    }

    private Table getSelectedTbl(ComboListPanel comboListPanel) {
        String tblBracketNm = (String)comboListPanel.getCombo().getSelectedItem();
        Table tbl = this.db_.getTableFromSchemaBracket(tblBracketNm);
        return tbl;
    }

    private void syncData() throws Exception {
        String name = this.txtName_.getText();
        Table parTbl = this.getSelectedTbl(this.parentPanel_);
        Table chdTbl = this.getSelectedTbl(this.childPanel_);
        String comment = this.txtComment_.getText();
        Cardinality childCardi = this.childCardiPanel_.getSelectedCardinality();
        String linkParentColNm = this.pairLinkPanel_.getSelectedParentLinkColNm();
        int delActionId = this.getDelActionSelected();
        int updActionId = this.getUpdActionSelected();
        ForeignKey newFk = new ForeignKey(name, parTbl, chdTbl, this.columnPairs_, delActionId, updActionId, comment, childCardi, linkParentColNm);
        BasicCollector.verifyNoDups(chdTbl, this.fk_, newFk);
        if (this.syncOnEdit_) {
            if (this.fk_ != null) {
                this.startedUpdate_ = true;
                this.setBusyCursor();
                ForeignKey oldFk = this.fk_;
                this.fk_ = newFk;
                UpdateInCollector.doUpdate(chdTbl, oldFk, this.fk_, App.getCommandChain(), null);
                this.setDefaultCursor();
                this.fk_ = chdTbl.getForeignKey(name);
            }
        } else {
            this.fk_ = newFk;
        }
        this.startedUpdate_ = false;
    }

    @Override
    public ITestResult validateData() {
        DataEntryResult result;
        block2: {
            try {
                this.syncData();
                result = new DataEntryResult(true);
            }
            catch (Exception e) {
                result = new DataEntryResult(false, e.getMessage());
                if (this.fk_ == null) break block2;
                this.loadData();
            }
        }
        return result;
    }

    private int getDelActionSelected() {
        int id = -1;
        if (this.rdoDelNoAction_.isSelected()) {
            id = 3;
        } else if (this.rdoDelRestrict_.isSelected()) {
            id = 1;
        } else if (this.rdoDelCascade_.isSelected()) {
            id = 0;
        } else if (this.rdoDelSetNull_.isSelected()) {
            id = 2;
        } else if (this.rdoDelSetDefault_.isSelected()) {
            id = 4;
        }
        return id;
    }

    private int getUpdActionSelected() {
        int id = -1;
        if (this.rdoUpdNoAction_.isSelected()) {
            id = 3;
        } else if (this.rdoUpdRestrict_.isSelected()) {
            id = 1;
        } else if (this.rdoUpdCascade_.isSelected()) {
            id = 0;
        } else if (this.rdoUpdSetNull_.isSelected()) {
            id = 2;
        } else if (this.rdoUpdSetDefault_.isSelected()) {
            id = 4;
        }
        return id;
    }

    private void loadDeleteAction() {
        int actionId = this.fk_.getDeleteActionId();
        switch (actionId) {
            case 3: {
                this.rdoDelNoAction_.setSelected(true);
                break;
            }
            case 1: {
                this.rdoDelRestrict_.setSelected(true);
                break;
            }
            case 0: {
                this.rdoDelCascade_.setSelected(true);
                break;
            }
            case 2: {
                this.rdoDelSetNull_.setSelected(true);
                break;
            }
            case 4: {
                this.rdoDelSetDefault_.setSelected(true);
            }
        }
    }

    private void loadUpdateAction() {
        int actionId = this.fk_.getUpdateActionId();
        switch (actionId) {
            case 3: {
                this.rdoUpdNoAction_.setSelected(true);
                break;
            }
            case 1: {
                this.rdoUpdRestrict_.setSelected(true);
                break;
            }
            case 0: {
                this.rdoUpdCascade_.setSelected(true);
                break;
            }
            case 2: {
                this.rdoUpdSetNull_.setSelected(true);
                break;
            }
            case 4: {
                this.rdoUpdSetDefault_.setSelected(true);
            }
        }
    }

    private void addColumnPair() {
        StringBuffer errBuffer = new StringBuffer();
        boolean parentColumnValid = this.isParentColumnValid(errBuffer);
        boolean childColumnValid = this.isChildColumnValid(errBuffer);
        if (parentColumnValid && childColumnValid) {
            this.showDataTypeWarning();
            this.columnPairs_.add(new StringPair((String)this.parentPanel_.getList().getSelectedValue(), (String)this.childPanel_.getList().getSelectedValue()));
            this.refreshPairList();
        } else {
            GuiMessageHelper.showInputErrMsg(null, ErrMsg.getTitleInvalidSelection(), errBuffer.toString());
        }
    }

    private void showDataTypeWarning() {
        Column colChd;
        Table parTbl = this.getSelectedTbl(this.parentPanel_);
        Table chdTbl = this.getSelectedTbl(this.childPanel_);
        String parColNm = (String)this.parentPanel_.getList().getSelectedValue();
        String chdColNm = (String)this.childPanel_.getList().getSelectedValue();
        Column colPar = parTbl.getColumn(parColNm);
        ITestResult result = ForeignKey.checkColumnDataTypes(colPar, colChd = chdTbl.getColumn(chdColNm));
        if (!result.getPassed()) {
            GuiMessageHelper.showOptionPaneMsg(null, result.getSummary(), result.getDetail(), 2);
        }
    }

    private void removeColumnPairs() {
        boolean invalidRemove;
        int pairCount;
        int[] selIndices = this.columnPairList_.getSelectedIndices();
        int selCount = selIndices.length;
        boolean allSelectedToRemove = selCount == (pairCount = this.columnPairList_.getModel().getSize());
        boolean bl = invalidRemove = this.syncOnEdit_ && allSelectedToRemove;
        if (!invalidRemove) {
            if (selCount > 0) {
                for (int i = selCount; i > 0; --i) {
                    int index = selIndices[i - 1];
                    this.columnPairs_.remove(index);
                }
                this.refreshPairList();
            } else {
                GuiMessageHelper.showInputErrMsg(null, ResMgr.getRes("command.invalid.label"), App.getRes("err.foreignKey.no.columnPair.selected.remove"));
            }
        } else {
            GuiMessageHelper.showInputErrMsg(null, ResMgr.getRes("command.invalid.label"), App.getRes("err.foreignKey.last.columPair.not.removable"));
        }
    }

    private void refreshPairList() {
        this.pairModel_.removeAllElements();
        Vector listData = new Vector();
        ArrayList<String> pairLinkList = new ArrayList<String>();
        for (StringPair pair : this.columnPairs_) {
            String parColNm = pair.getStrA();
            String chdColNm = pair.getStrB();
            String desc = chdColNm + "/" + parColNm;
            this.pairModel_.addElement(desc);
            pairLinkList.add(desc);
        }
        this.pairLinkPanel_.setPairs(pairLinkList);
        this.checkValidate();
    }

    private void clearPairList() {
        this.columnPairs_ = new ArrayList();
        this.refreshPairList();
    }

    private void checkValidate() {
        ITestResult result;
        if (this.syncOnEdit_ && !this.loadingData_ && !(result = this.validateData()).getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, result.getSummary(), result.getDetail());
        }
    }

    @Override
    public void update(UpdateChain chain) {
        if (!this.startedUpdate_ && !this.loadingData_) {
            if (chain.hasClassName(this.className_) && this.fk_ != null) {
                try {
                    this.fk_ = (ForeignKey)this.db_.get(this.className_, this.fk_.getName());
                }
                catch (Exception e) {
                    this.fk_ = null;
                }
                this.loadData();
            }
            if (this.fk_ != null && (chain.hasClassName(Cardinality.clazz()) || chain.hasClassName("FkPairLinkPanel"))) {
                try {
                    this.syncData();
                }
                catch (Exception e) {
                    LogUtil.logErr("FkPanel.update.error: " + e.getMessage());
                }
            }
        }
    }

    public ForeignKey getForeignKey() {
        return (ForeignKey)this.getDataObject();
    }

    public ForeignKey getForeignKeyAsIs() {
        return this.fk_;
    }

    @Override
    public Identifiable getDataObject() {
        this.validateData();
        return this.fk_;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(basicSizeStorable__.getSize());
    }

    @Override
    public Dimension getSize() {
        return basicSizeStorable__.getSize();
    }

    @Override
    public void setSize(Dimension size) {
        basicSizeStorable__.setSize(size);
    }

    @Override
    public Collector getCollector() {
        Table coll = null;
        if (this.fk_ != null) {
            coll = this.fk_.getChdTbl();
        }
        return coll;
    }

    private boolean isDataValid() {
        boolean isValid = true;
        StringBuffer errBuffer = new StringBuffer();
        isValid |= this.isNameValid(errBuffer);
        isValid |= this.isParentTableValid(errBuffer);
        isValid |= this.isChildTableValid(errBuffer);
        if (!(isValid |= this.isColumnPairValid(errBuffer))) {
            GuiMessageHelper.showInputErrMsg(null, ErrMsg.getTitleInvalidSelection(), errBuffer.toString());
        }
        return isValid;
    }

    private boolean isNameValid(StringBuffer buffer) {
        boolean isValid = Validator.isStringValid(this.txtName_.getText());
        if (!isValid) {
            buffer.append(App.getResouceStringApp("err.foreignKey.invalid.name") + "\n");
        }
        return isValid;
    }

    private boolean isParentTableValid(StringBuffer buffer) {
        boolean isValid;
        boolean bl = isValid = this.parentPanel_.getCombo().getSelectedItem() != null;
        if (!isValid) {
            buffer.append(App.getResouceStringApp("err.foreignKey.invalid.parent.table") + "\n");
        }
        return isValid;
    }

    private boolean isParentColumnValid(StringBuffer buffer) {
        boolean isValid;
        boolean bl = isValid = this.parentPanel_.getList().getSelectedValue() != null;
        if (!isValid) {
            buffer.append(App.getResouceStringApp("err.foreignKey.invalid.parent.column") + "\n");
        }
        return isValid;
    }

    private boolean isChildTableValid(StringBuffer buffer) {
        boolean isValid;
        boolean bl = isValid = this.childPanel_.getCombo().getSelectedItem() != null;
        if (!isValid) {
            buffer.append(App.getResouceStringApp("err.foreignKey.invalid.child.table") + "\n");
        }
        return isValid;
    }

    private boolean isChildColumnValid(StringBuffer buffer) {
        boolean isValid;
        boolean bl = isValid = this.childPanel_.getList().getSelectedValue() != null;
        if (!isValid) {
            buffer.append(App.getResouceStringApp("err.foreignKey.invalid.child.column") + "\n");
        }
        return isValid;
    }

    private boolean isColumnPairValid(StringBuffer buffer) {
        boolean isValid;
        boolean bl = isValid = this.columnPairList_.getModel().getSize() > 0;
        if (!isValid) {
            buffer.append(App.getResouceStringApp("err.foreignKey.no.columnPair") + "\n");
        }
        return isValid;
    }

    private void initComponents() {
        this.setLayout(null);
    }

    @Override
    public String getTitle() {
        String title = this.fk_ == null ? FileHelper.getResource("add.label") : FileHelper.getResource("edit.label");
        return title + " " + App.getResource("foreignKey.label");
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.FOREIGN_KEY;
    }

    private void setBusyCursor() {
        GuiHelper.setBusyCursor(this);
        GuiHelper.setBusyCursor(this.txtName_);
        GuiHelper.setBusyCursor(this.txtComment_);
        GuiHelper.setBusyCursor(this.lblName_);
        GuiHelper.setBusyCursor(this.lblComment_);
        GuiHelper.setBusyCursor(this.btnAutoName_);
        GuiHelper.setBusyCursor(this.addRemovePanel_);
        GuiHelper.setBusyCursor(this.childPanel_);
        GuiHelper.setBusyCursor(this.childCardiPanel_);
        GuiHelper.setBusyCursor(this.pairLinkPanel_);
        GuiHelper.setBusyCursor(this.rdoDelCascade_);
        GuiHelper.setBusyCursor(this.rdoDelNoAction_);
        GuiHelper.setBusyCursor(this.rdoDelRestrict_);
        GuiHelper.setBusyCursor(this.rdoDelSetDefault_);
        GuiHelper.setBusyCursor(this.rdoDelSetNull_);
        GuiHelper.setBusyCursor(this.rdoUpdCascade_);
        GuiHelper.setBusyCursor(this.rdoUpdNoAction_);
        GuiHelper.setBusyCursor(this.rdoUpdRestrict_);
        GuiHelper.setBusyCursor(this.rdoUpdSetDefault_);
        GuiHelper.setBusyCursor(this.rdoUpdSetNull_);
    }

    private void setDefaultCursor() {
        GuiHelper.setDefaultCursor(this);
        GuiHelper.setDefaultCursor(this.txtName_);
        GuiHelper.setDefaultCursor(this.txtComment_);
        GuiHelper.setDefaultCursor(this.lblName_);
        GuiHelper.setDefaultCursor(this.lblComment_);
        GuiHelper.setDefaultCursor(this.btnAutoName_);
        GuiHelper.setDefaultCursor(this.addRemovePanel_);
        GuiHelper.setDefaultCursor(this.childPanel_);
        GuiHelper.setDefaultCursor(this.childCardiPanel_);
        GuiHelper.setDefaultCursor(this.pairLinkPanel_);
        GuiHelper.setDefaultCursor(this.rdoDelCascade_);
        GuiHelper.setDefaultCursor(this.rdoDelNoAction_);
        GuiHelper.setDefaultCursor(this.rdoDelRestrict_);
        GuiHelper.setDefaultCursor(this.rdoDelSetDefault_);
        GuiHelper.setDefaultCursor(this.rdoDelSetNull_);
        GuiHelper.setDefaultCursor(this.rdoUpdCascade_);
        GuiHelper.setDefaultCursor(this.rdoUpdNoAction_);
        GuiHelper.setDefaultCursor(this.rdoUpdRestrict_);
        GuiHelper.setDefaultCursor(this.rdoUpdSetDefault_);
        GuiHelper.setDefaultCursor(this.rdoUpdSetNull_);
    }
}

