/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.IChildComponent;
import com.harrand.coreclasses.dataEntry.IDataEditPanel;
import com.harrand.coreclasses.display.IPanelContainer;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ICloseVerify;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.listener.DataEditorVerifier;
import com.harrand.coregui.listener.EditSyncActionListener;
import com.harrand.dbwrench.object.Database;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;

public class DbEditPanel
extends JPanel
implements DataEditor,
IObserver,
ICloseVerify,
IChildComponent,
IDataEditPanel {
    private Database db_;
    private RootPaneContainer parentContainer_;
    private boolean dirty_;
    private JLabel lblDefaultTableOpts_;
    private JTextField txtDefaultTableOpts_ = new JTextField("");
    private JLabel lblVerionsLabel_;
    private JTextField txtVersionLabel_ = new JTextField("");
    private JLabel lblVersionNotes_;
    private JTextArea txtVersionNotes_ = new JTextArea();
    private JButton btnUpdate_ = GuiHelper.getUpdateBtn();
    private JComponent focusItem_ = null;
    private boolean syncOnEdit_ = false;
    private ActionListener editSyncActionListener_;
    private InputVerifier verifier_;
    private ActionListener lisUpdate_;
    private SwingThemeCtrl themeCtrl_;

    public DbEditPanel(Database db) {
        this.buildControls();
        this.db_ = db;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
        this.loadData();
        this.buildListeners();
        this.setSyncOnEdit(true);
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
        this.syncOnEdit_ = sync;
        if (this.syncOnEdit_) {
            this.txtDefaultTableOpts_.setInputVerifier(this.verifier_);
            this.txtDefaultTableOpts_.addActionListener(this.editSyncActionListener_);
            this.txtVersionLabel_.setInputVerifier(this.verifier_);
            this.txtVersionLabel_.addActionListener(this.editSyncActionListener_);
            this.txtVersionNotes_.setInputVerifier(this.verifier_);
        } else {
            this.txtDefaultTableOpts_.setInputVerifier(null);
            this.txtDefaultTableOpts_.removeActionListener(this.editSyncActionListener_);
            this.txtVersionLabel_.setInputVerifier(null);
            this.txtVersionLabel_.removeActionListener(this.editSyncActionListener_);
            this.txtVersionNotes_.setInputVerifier(null);
        }
    }

    private void buildListeners() {
        this.editSyncActionListener_ = new EditSyncActionListener(this);
        this.verifier_ = new DataEditorVerifier(this);
        this.lisUpdate_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbEditPanel.this.storeFocusItem();
                DbEditPanel.this.syncData();
                DbEditPanel.this.restoreFocusItem();
            }
        };
        this.addListeners();
    }

    private void storeFocusItem() {
        this.storeFocusItemDisp(this.txtDefaultTableOpts_);
        this.storeFocusItemDisp(this.txtVersionLabel_);
        this.storeFocusItemDisp(this.txtVersionNotes_);
    }

    private void storeFocusItemDisp(JComponent comp) {
        if (comp.hasFocus()) {
            this.focusItem_ = comp;
        }
    }

    private void restoreFocusItem() {
        if (this.focusItem_ != null) {
            this.focusItem_.requestFocus();
        }
    }

    private void setupGui() {
        this.buildControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
    }

    private void buildControls() {
        String div = "";
        this.lblDefaultTableOpts_ = new JLabel("Default Table Options" + div);
        this.lblVerionsLabel_ = new JLabel("Version Label" + div);
        this.lblVersionNotes_ = new JLabel("Version Notes" + div);
    }

    private void loadData() {
        if (this.db_ != null) {
            this.txtDefaultTableOpts_.setText(this.db_.getDefaultTableOpts());
            this.txtVersionLabel_.setText(this.db_.getVersionLabel());
            this.txtVersionNotes_.setText(this.db_.getVersionNotes());
        } else {
            this.txtDefaultTableOpts_.setText("");
            this.txtVersionLabel_.setText("");
            this.txtVersionNotes_.setText("");
        }
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.getMainPanel(), "North");
        this.add((Component)this.getButtonPanel(), "South");
        GuiHelper.addEmptyBorder(this);
    }

    private JPanel getMainPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblDefaultTableOpts_, this.txtDefaultTableOpts_, gbc, panel, row++);
        GuiHelper.addGridbagPair(this.lblVerionsLabel_, this.txtVersionLabel_, gbc, panel, row++);
        GuiHelper.buildGridBagConstraints(gbc, 0, row, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 18;
        panel.add((Component)this.lblVersionNotes_, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 1, row++, 1, 1, 90.0, 0.0);
        gbc.fill = 1;
        gbc.anchor = 18;
        panel.add((Component)new JScrollPane(this.txtVersionNotes_), gbc);
        return panel;
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.btnUpdate_);
        return buttonPanel;
    }

    private void setNames() {
        this.txtDefaultTableOpts_.setName("txtDefaultTableOpts");
        this.txtVersionLabel_.setName("txtVersionLabel");
        this.txtVersionNotes_.setName("txtVersionNotes");
    }

    private void setCosmetics() {
        this.txtVersionNotes_.setRows(5);
        this.txtVersionNotes_.setFont(this.lblVerionsLabel_.getFont());
        this.themeCtrl_.process(this);
    }

    private void addListeners() {
        KeyListener lisDirty = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                DbEditPanel.this.checkDirty();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        this.txtDefaultTableOpts_.addKeyListener(lisDirty);
        this.txtVersionLabel_.addKeyListener(lisDirty);
        this.txtVersionNotes_.addKeyListener(lisDirty);
    }

    private void checkDirty() {
        String oldVersionLabel = this.db_ != null ? this.db_.getVersionLabel() : "";
        String oldVersionNotes = this.db_ != null ? this.db_.getVersionNotes() : "";
        String oldDefaultOpts = this.db_ != null ? this.db_.getDefaultTableOpts() : "";
        String newVersionLabel = this.txtVersionLabel_.getText();
        String newVersionNotes = this.txtVersionNotes_.getText();
        String newDefaultOpts = this.txtDefaultTableOpts_.getText();
        if (!(oldVersionLabel.equals(newVersionLabel) && oldVersionLabel.equals(newVersionLabel) && oldDefaultOpts.equals(newDefaultOpts))) {
            this.dirty_ = true;
        }
        this.updateDirty();
    }

    private void saveDb() {
        ITestResult result = this.save();
        if (!result.getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, result.getSummary(), result.getDetail());
        }
    }

    public Database getDb() {
        this.validateData();
        return this.db_;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getDb();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 320, 275);
    }

    private void syncData() {
        String newVerNotes;
        String oldVerNotes;
        String newVerLabel;
        String oldVerLabel;
        String newTableOpts;
        String oldTableOpts = this.db_.getDefaultTableOpts();
        if (!oldTableOpts.equals(newTableOpts = this.txtDefaultTableOpts_.getText())) {
            this.db_.setDefaultTableOpts(newTableOpts);
            this.toggleMouseCursor();
        }
        if (!(oldVerLabel = this.db_.getVersionLabel()).equals(newVerLabel = this.txtVersionLabel_.getText())) {
            this.db_.setVersionLabel(newVerLabel);
            this.toggleMouseCursor();
        }
        if (!(oldVerNotes = this.db_.getVersionNotes()).equals(newVerNotes = this.txtVersionNotes_.getText())) {
            this.db_.setVersionNotes(newVerNotes);
            this.toggleMouseCursor();
        }
    }

    @Override
    public ITestResult validateData() {
        DataEntryResult result = new DataEntryResult(true);
        this.syncData();
        return result;
    }

    @Override
    public void update(UpdateChain chain) {
    }

    @Override
    public String getTitle() {
        StringBuffer sb;
        StringBuffer stringBuffer = sb = this.db_ == null ? new StringBuffer(ResMgr.getRes("add.label") + "Database") : new StringBuffer("Database Properties");
        if (this.dirty_) {
            sb.append("*");
        }
        return sb.toString();
    }

    private void addParentListeners() {
        if (this.parentContainer_ != null) {
            GuiHelper.addContainerCancelAction(this.parentContainer_);
        }
    }

    private void updateDirty() {
        if (this.parentContainer_ != null && this.parentContainer_ instanceof JDialog) {
            ((JDialog)this.parentContainer_).setTitle(this.getTitle());
        }
    }

    private void toggleMouseCursor() {
        this.setBusyCursor();
        try {
            Robot robot = new Robot();
            robot.delay(50);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDefaultCursor();
    }

    private void setBusyCursor() {
        GuiHelper.setBusyCursor(this);
        GuiHelper.setBusyCursor(this.txtDefaultTableOpts_);
        GuiHelper.setBusyCursor(this.txtVersionLabel_);
        GuiHelper.setBusyCursor(this.txtVersionNotes_);
        GuiHelper.setBusyCursor(this.lblDefaultTableOpts_);
        GuiHelper.setBusyCursor(this.lblVerionsLabel_);
        GuiHelper.setBusyCursor(this.lblVersionNotes_);
    }

    private void setDefaultCursor() {
        GuiHelper.setDefaultCursor(this);
        GuiHelper.setDefaultCursor(this.txtDefaultTableOpts_);
        GuiHelper.setDefaultCursor(this.txtVersionLabel_);
        GuiHelper.setDefaultCursor(this.txtVersionNotes_);
        GuiHelper.setDefaultCursor(this.lblDefaultTableOpts_);
        GuiHelper.setDefaultCursor(this.lblVerionsLabel_);
        GuiHelper.setDefaultCursor(this.lblVersionNotes_);
    }

    @Override
    public boolean allowClose() {
        String objName;
        boolean allow = true;
        String string = objName = this.db_ != null ? this.db_.getName() : "";
        if (this.dirty_) {
            String title = ResMgr.getRes("editor.save.changes.title");
            String msg = ResMgr.getRes("editor.doc.modified.msg") + this.db_ + "\n" + ResMgr.getRes("editor.save.changes.prompt");
            int option = GuiMessageHelper.showYesNoCancelMsg(null, title, msg);
            switch (option) {
                case 2: {
                    allow = false;
                    break;
                }
                case 0: {
                    this.save();
                    break;
                }
            }
        }
        return allow;
    }

    @Override
    public void setParentContainer(RootPaneContainer parentContainer) {
        this.parentContainer_ = parentContainer;
        this.addParentListeners();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.PROC;
    }

    @Override
    public String getToolTip() {
        return "Edit Database Properties";
    }

    @Override
    public ITestResult save() {
        ITestResult result = this.validateData();
        if (result.getPassed()) {
            this.dirty_ = false;
            this.updateDirty();
        }
        return result;
    }

    @Override
    public boolean isDirty() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPanelContainer(IPanelContainer panelContainer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collector getCollector() {
        return null;
    }
}

