/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.list.ComboArrayPanel;
import com.harrand.coregui.text.TextEditPanel;
import com.harrand.dbwrench.dataConversion.DbConversionComboArrayCtrl;
import com.harrand.dbwrench.dataConversion.DbDataConversion;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.JPanel;

public final class DbDataConversionEditPanel
extends JPanel
implements DataEditor {
    private ComboArrayPanel comboArrayPanel_;
    private TextEditPanel textEditPanel_;
    private Collector db_;
    private DbDataConversion conversion_;
    private String collectorClassName_;
    private String converteeClassName_;
    private SwingThemeCtrl themeCtrl_;

    public DbDataConversionEditPanel(DbDataConversion conversion) {
        this.conversion_ = conversion;
        if (this.conversion_ != null) {
            Schema sch = (Schema)conversion.getParent();
            this.db_ = sch.getDb();
        } else {
            LogUtil.logMsg("DbDataConvEditPanel.conversion is NULL!!");
        }
        this.init();
    }

    public DbDataConversionEditPanel(Database db) {
        this.conversion_ = null;
        this.db_ = db;
        this.init();
    }

    private void init() {
        this.themeCtrl_ = App.getThemeCtrl();
        this.converteeClassName_ = Column.getClassName();
        this.collectorClassName_ = Table.getClassName();
        this.buildPanel();
        this.loadData();
    }

    private void buildPanel() {
        this.buildComboArrayPanel();
        this.textEditPanel_ = new TextEditPanel(null, App.getResource("conversion.value.label") + ": ", "");
        this.setLayout(new BorderLayout());
        this.add((Component)this.comboArrayPanel_, "North");
        this.add((Component)this.textEditPanel_, "South");
        this.themeCtrl_.process(this);
    }

    private void buildComboArrayPanel() {
        DbConversionComboArrayCtrl comboCtrl = new DbConversionComboArrayCtrl(this.db_, new HashMap());
        this.comboArrayPanel_ = new ComboArrayPanel(comboCtrl);
    }

    private void loadData() {
        if (this.conversion_ != null) {
            this.comboArrayPanel_.setSelectedItem(this.collectorClassName_, this.conversion_.getCollector());
            this.comboArrayPanel_.setSelectedItem(this.converteeClassName_, this.conversion_.getConvertedObject());
            this.textEditPanel_.setText(this.conversion_.getConversionValue().toString());
        } else {
            this.textEditPanel_.setText("");
        }
    }

    @Override
    public ITestResult validateData() {
        DataEntryResult result;
        try {
            this.syncData();
            result = new DataEntryResult(true);
        }
        catch (Exception e) {
            result = new DataEntryResult(false, e.getMessage());
            this.conversion_ = null;
        }
        return result;
    }

    private void syncData() throws Exception {
        Column convertee = (Column)this.comboArrayPanel_.getSelectedItem(this.converteeClassName_);
        Table collector = (Table)this.comboArrayPanel_.getSelectedItem(this.collectorClassName_);
        String conversionValue = this.textEditPanel_.getText();
        if (convertee == null) {
            throw new IllegalArgumentException(FileHelper.getResource("err.combo.not.selected") + this.converteeClassName_);
        }
        if (collector == null) {
            throw new IllegalArgumentException(FileHelper.getResource("err.combo.not.selected") + this.collectorClassName_);
        }
        if (conversionValue.length() == 0) {
            throw new IllegalArgumentException(FileHelper.getResource("err.text.empty") + this.converteeClassName_);
        }
        this.conversion_ = new DbDataConversion(convertee, collector, this.db_, this.textEditPanel_.getText());
    }

    @Override
    public Identifiable getDataObject() {
        this.validateData();
        return this.conversion_;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 325, 155);
    }

    @Override
    public String getTitle() {
        return App.getResource("display.name.DbDataConversion");
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
    }

    @Override
    public Collector getCollector() {
        return this.db_;
    }
}

