/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.IDataEditPanel;
import com.harrand.coreclasses.display.IPanelContainer;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.list.DNDList;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.dbwrench.object.ColumnSortPanelCtrl;
import com.harrand.dbwrench.security.App;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public final class ColumnSortPanel
extends JPanel
implements IDataEditPanel,
DropTargetListener {
    public static final String SUBTITLE = "Edit Columns Positions";
    private final ColumnSortPanelCtrl ctrl_;
    private XpHeaderPanel headerPanel_;
    private final JButton btnUp_ = new JButton("Up");
    private final JButton btnDown_ = new JButton("Down");
    private JTextField txtTable_;
    private final JLabel lblTable_ = new JLabel(App.getRes("table.label"));
    private JList lstColumns_;
    private DefaultListModel listModel_;
    private final SwingThemeCtrl themeCtrl_;
    private DropTarget dropTargetAbove_;
    private DropTarget dropTargetBelow_;

    public ColumnSortPanel(ColumnSortPanelCtrl ctrl) {
        this.ctrl_ = ctrl;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
    }

    private void setupGui() {
        this.buildControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void buildControls() {
        this.headerPanel_ = new XpHeaderPanel("Sort Columns", SUBTITLE);
        this.txtTable_ = new JTextField(this.ctrl_.getTable().getName());
        this.lstColumns_ = new DNDList(this.ctrl_.getSortedColDescs());
        this.listModel_ = (DefaultListModel)this.lstColumns_.getModel();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.headerPanel_, "North");
        this.add((Component)this.getBodyPanel(), "Center");
    }

    private JPanel getBodyPanel() {
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.add((Component)this.getNorthPanel(), "North");
        panel.add((Component)this.getCenterPanel(), "Center");
        GuiHelper.addBodyPanelBorder(panel);
        return panel;
    }

    private JPanel getNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.add((Component)this.getTablePanel(), "North");
        this.themeCtrl_.process(panel);
        return panel;
    }

    private JPanel getTablePanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblTable_, this.txtTable_, gbc, panel, row++);
        this.themeCtrl_.process(panel);
        return panel;
    }

    private JPanel getCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)this.getListPanel(), "Center");
        panel.add(this.getArrowPanel(), "East");
        GuiHelper.addTitledEmptyBorder(panel, App.getRes("column.order"));
        return panel;
    }

    private Component getArrowPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.btnUp_);
        panel.add(Box.createVerticalStrut(5));
        panel.add(this.btnDown_);
        panel.add(Box.createGlue());
        return panel;
    }

    private JPanel getListPanel() {
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        JScrollPane scroll = new JScrollPane(this.lstColumns_);
        ((DNDList)this.lstColumns_).setScrollPane(scroll);
        this.lstColumns_.setAutoscrolls(true);
        panel.add((Component)scroll, "Center");
        this.themeCtrl_.process(panel);
        this.dropTargetAbove_ = new DropTarget(panel, this);
        return panel;
    }

    private void setCosmetics() {
        this.txtTable_.setEditable(false);
        this.txtTable_.setBackground(this.themeCtrl_.getUneditColumnBackground());
        this.txtTable_.setEnabled(false);
        this.btnUp_.setMnemonic('U');
        this.btnDown_.setMnemonic('D');
        this.btnUp_.setMaximumSize(this.btnDown_.getMinimumSize());
    }

    private void addListeners() {
        this.btnUp_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnSortPanel.this.moveUp();
            }
        });
        this.btnDown_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ColumnSortPanel.this.moveDown();
            }
        });
    }

    private void moveUp() {
        boolean abort;
        int[] selectedIdxs = this.lstColumns_.getSelectedIndices();
        int selectSize = selectedIdxs.length;
        boolean empty = selectSize == 0;
        boolean bl = abort = empty || selectedIdxs[0] == 0;
        if (!abort) {
            int[] newIndexes = new int[selectSize];
            for (int i = 0; i < selectSize; ++i) {
                int selectIdx = selectedIdxs[i];
                String colDesc = (String)this.listModel_.get(selectIdx);
                this.listModel_.remove(selectIdx);
                int newIdx = selectIdx - 1;
                this.listModel_.add(newIdx, colDesc);
                newIndexes[i] = newIdx;
            }
            this.reselect(newIndexes);
        } else {
            this.reselect(selectedIdxs);
        }
    }

    private void moveDown() {
        boolean abort;
        int maxPos = this.listModel_.getSize() - 1;
        int[] selectedIdxs = this.lstColumns_.getSelectedIndices();
        int selectSize = selectedIdxs.length;
        boolean empty = selectSize == 0;
        boolean bl = abort = empty || selectedIdxs[selectSize - 1] == maxPos;
        if (!abort) {
            int[] newIndexes = new int[selectSize];
            for (int i = selectedIdxs.length - 1; i >= 0; --i) {
                int selectIdx = selectedIdxs[i];
                String colDesc = (String)this.listModel_.get(selectIdx);
                this.listModel_.remove(selectIdx);
                int newIdx = selectIdx + 1;
                this.listModel_.add(newIdx, colDesc);
                newIndexes[i] = newIdx;
            }
            this.reselect(newIndexes);
        } else {
            this.reselect(selectedIdxs);
        }
    }

    private void reselect(int[] selectedIdxs) {
        this.lstColumns_.setSelectedIndices(selectedIdxs);
        this.lstColumns_.requestFocus();
    }

    private void setNames() {
        this.lstColumns_.setName("lstColumns");
    }

    @Override
    public Rectangle getPreferredBounds() {
        return this.ctrl_.getPreferredBounds(this.lblTable_.getFont());
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return App.getRes("column.sort");
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ITestResult save() {
        boolean useManual = true;
        this.ctrl_.setUseManualSort(useManual);
        if (useManual) {
            DefaultListModel model = (DefaultListModel)this.lstColumns_.getModel();
            ArrayList<String> sortedDescs = new ArrayList<String>();
            for (int i = 0; i < model.size(); ++i) {
                sortedDescs.add((String)model.get(i));
            }
            this.ctrl_.setSortedDescs(sortedDescs);
        }
        return new DataEntryResult(true);
    }

    @Override
    public boolean isDirty() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPanelContainer(IPanelContainer panelContainer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        Object src = dropTargetDragEvent.getSource();
        if (src == this.dropTargetAbove_) {
            ((DNDList)this.lstColumns_).autoScroll(true);
        }
        if (src == this.dropTargetBelow_) {
            ((DNDList)this.lstColumns_).autoScroll(false);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }
}

