/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.IMultipleAddPanel;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.coregui.command.prompt.IHasPromptSubCmds;
import com.harrand.coregui.dataEntry.IFocusable;
import com.harrand.coregui.display.BasicSizeStorable;
import com.harrand.coregui.display.ISizeStorable;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.listener.DataEditorVerifier;
import com.harrand.coregui.listener.EditSyncActionListener;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.db.SqlReservedWordGui;
import com.harrand.dbwrenchgui.item.column.IsArrayPanel;
import com.harrand.dbwrenchgui.panel.subpanel.DataTypePanel;
import com.harrand.dbwrenchgui.panel.subpanel.IDataTypeChangeListener;
import com.harrand.dbwrenchgui.panel.support.ColumnEditPanelPK_Support;
import com.harrand.util.FileHelper;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class ColumnEditPanel
extends JPanel
implements DataEditor,
IObserver,
ISizeStorable,
IFocusable,
ITitled,
IMultipleAddPanel,
IHasPromptSubCmds,
IDataTypeChangeListener {
    private Column origColumn_;
    private Column newColumn_ = null;
    private final Table table_;
    private DataTypePanel dataTypePanel;
    private final IsArrayPanel isArrayPanel = new IsArrayPanel(false);
    private final String className_;
    private JLabel lblName_;
    private final JTextField txtName_ = new JTextField("");
    private JLabel lblDefault_;
    private final JTextField txtDefault_ = new JTextField("");
    private JLabel lblComment_;
    private final JTextArea txtComment_ = new JTextArea();
    private JLabel lblEnum_;
    private final JTextField txtEnum_ = new JTextField("");
    private JCheckBox chkNullable_;
    private JCheckBox chkAutoNumber_;
    private JCheckBox chkPK;
    private JCheckBox chkUnique_;
    private static final ISizeStorable BASIC_SIZE_STORABLE = new BasicSizeStorable(new Dimension(425, 575));
    private boolean startedUpdate_ = false;
    private boolean syncOnEdit_ = false;
    private InputVerifier verifier_;
    private ActionListener editSyncActionListener_;
    private final SwingThemeCtrl themeCtrl_;
    private Command updatePK_SubCmd = null;
    private boolean selectAllName;
    private final DbUser user;
    private final IOptionMgr dbExplorerOptionMgr;

    public ColumnEditPanel(Column column, Table table) {
        this.table_ = table;
        this.origColumn_ = column;
        this.className_ = Column.getClassName();
        this.themeCtrl_ = App.getThemeCtrl();
        this.table_.addObserver(this);
        this.user = App.getUser();
        this.dbExplorerOptionMgr = this.user.getOptionMgr("db.explorer.option.mgr");
        this.setupGui();
        this.buildListeners();
    }

    @Override
    public void transferFocus() {
        this.txtName_.requestFocus();
    }

    private void setupGui() {
        this.initComponents();
        this.buildControls();
        this.setNames();
        this.layoutComponents();
        this.loadData();
        this.setCosmetics();
        this.updateDisplay();
    }

    private void buildControls() {
        String div = "";
        this.lblName_ = new JLabel(FileHelper.getResource("name.label") + div);
        this.lblDefault_ = new JLabel(FileHelper.getResource("default.label") + "    " + div);
        this.lblComment_ = new JLabel(ResMgr.getRes("comment") + div);
        this.lblEnum_ = new JLabel("ENUM/SET Values" + div);
        this.chkNullable_ = new JCheckBox(App.getResource("nullable.label"));
        this.chkPK = new JCheckBox("Primary Key");
        this.chkAutoNumber_ = new JCheckBox(App.getResource("auto.number.label"));
        this.chkUnique_ = new JCheckBox("Unique");
        this.dataTypePanel = new DataTypePanel(this.origColumn_);
        this.dataTypePanel.setDataTypeChangeListener(this);
    }

    private void setNames() {
        this.setName("ColumnEditPanel");
        this.lblName_.setName("lblName_");
        this.txtName_.setName("txtName_");
        this.txtDefault_.setName("txtDefault_");
        this.txtComment_.setName("txtComment_");
        this.txtEnum_.setName("txtEnum");
        this.chkNullable_.setName("chkNullable_");
        this.chkAutoNumber_.setName("chkAutoNumber_");
        this.chkUnique_.setName("chkUnique");
    }

    private void layoutComponents() {
        JTabbedPane tabPane = new JTabbedPane(3);
        tabPane.addTab("General", this.getGeneralPanel());
        tabPane.addTab("DBMS Specific", this.getDbmsSpecificPanel());
        this.setLayout(new BorderLayout());
        this.add((Component)tabPane, "Center");
        GuiHelper.addEmptyBorder(this);
    }

    private JPanel getGeneralPanel() {
        JPanel panel = new JPanel();
        GuiHelper.addEmptyBorder(panel);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.getNamingPanel());
        panel.add(this.dataTypePanel);
        panel.add(this.getDetailsPanel());
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private JPanel getDbmsSpecificPanel() {
        int strut = 16;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(this.getVenderPanel());
        panel.add(Box.createVerticalStrut(strut));
        panel.add(this.isArrayPanel);
        panel.add(Box.createVerticalStrut(350));
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private JPanel getNamingPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblName_, this.txtName_, gbc, panel, row++);
        GuiHelper.addTitledEmptyBorder(panel, "Naming");
        return panel;
    }

    private JPanel getDetailsPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(new JLabel(), this.getNullablePanel(), gbc, panel, row++);
        GuiHelper.addGridbagPair(this.lblDefault_, this.txtDefault_, gbc, panel, row++);
        GuiHelper.buildGridBagConstraints(gbc, 0, row, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 18;
        panel.add((Component)this.lblComment_, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 1, row++, 1, 1, 90.0, 0.0);
        gbc.fill = 1;
        gbc.anchor = 18;
        panel.add((Component)new JScrollPane(this.txtComment_), gbc);
        GuiHelper.addTitledEmptyBorder(panel, "Details");
        return panel;
    }

    private JPanel getNullablePanel() {
        JPanel panel = new JPanel(new GridLayout(2, 2));
        panel.add(this.chkNullable_);
        panel.add(this.chkAutoNumber_);
        panel.add(this.chkPK);
        return panel;
    }

    private JPanel getVenderPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(this.lblEnum_);
        panel.add(Box.createHorizontalStrut(4));
        panel.add(this.txtEnum_);
        GuiHelper.addTitledEmptyBorder(panel, "MySQL ENUM Types");
        return panel;
    }

    private void updateDisplay() {
        this.dataTypePanel.refresh();
        this.refreshTxtEnum();
    }

    public void refreshTxtEnum() {
        boolean used = this.getEnumUsed();
        this.txtEnum_.setEnabled(used);
        this.lblEnum_.setEnabled(used);
        if (!used) {
            this.txtEnum_.setText("");
        }
    }

    private boolean getEnumUsed() {
        IDataType dataType = this.getSelectedDataType();
        boolean used = false;
        if (dataType != null) {
            int typeId = dataType.getId();
            used = typeId == 706 || typeId == 740;
        }
        return used;
    }

    private IDataType getSelectedDataType() {
        return this.dataTypePanel.getDataType();
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
        this.syncOnEdit_ = sync;
        if (this.syncOnEdit_) {
            this.txtName_.setInputVerifier(this.verifier_);
            this.txtDefault_.setInputVerifier(this.verifier_);
            this.txtComment_.setInputVerifier(this.verifier_);
            this.txtEnum_.setInputVerifier(this.verifier_);
            this.txtName_.addActionListener(this.editSyncActionListener_);
            this.txtDefault_.addActionListener(this.editSyncActionListener_);
            this.txtComment_.setInputVerifier(this.verifier_);
            this.chkNullable_.addActionListener(this.editSyncActionListener_);
            this.chkAutoNumber_.addActionListener(this.editSyncActionListener_);
            this.chkPK.addActionListener(this.editSyncActionListener_);
        } else {
            this.txtName_.setInputVerifier(null);
            this.txtDefault_.setInputVerifier(null);
            this.txtComment_.setInputVerifier(null);
            this.txtEnum_.setInputVerifier(null);
            this.txtName_.removeActionListener(this.editSyncActionListener_);
            this.txtDefault_.removeActionListener(this.editSyncActionListener_);
            this.txtComment_.setInputVerifier(null);
            this.chkNullable_.removeActionListener(this.editSyncActionListener_);
            this.chkPK.removeActionListener(this.editSyncActionListener_);
            this.chkAutoNumber_.removeActionListener(this.editSyncActionListener_);
        }
    }

    private void buildListeners() {
        this.editSyncActionListener_ = new EditSyncActionListener(this);
        this.verifier_ = new DataEditorVerifier(this);
        this.txtName_.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ColumnEditPanel.this.selectAllName) {
                    ColumnEditPanel.this.txtName_.selectAll();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    private void loadData() {
        if (this.origColumn_ != null) {
            this.txtName_.setText(this.origColumn_.getName());
            this.txtDefault_.setText(this.origColumn_.getDefault());
            this.txtComment_.setText(this.origColumn_.getComment());
            this.txtEnum_.setText(this.origColumn_.getEnumCsv());
            this.chkNullable_.setSelected(this.origColumn_.getIsNullable());
            this.chkAutoNumber_.setSelected(this.origColumn_.getAutoNumber());
            this.loadPkData();
            this.dataTypePanel.loadData();
            this.chkUnique_.setSelected(this.origColumn_.getUnique());
            this.isArrayPanel.setIsArray(this.origColumn_.getIsArray());
        } else {
            this.reset();
        }
    }

    private void loadPkData() {
        boolean isInPk = false;
        PrimaryKey pk = this.table_.getPrimaryKey();
        if (pk != null) {
            isInPk = pk.containsColumnName(this.origColumn_.getName());
        }
        this.chkPK.setSelected(isInPk);
    }

    private void reset() {
        this.txtName_.setText("");
        this.txtDefault_.setText("");
        this.txtComment_.setText("");
        this.txtEnum_.setText("");
        boolean nullableDefault = this.dbExplorerOptionMgr.getBoolValue("db.explorer.default.columns.to.null");
        this.chkNullable_.setSelected(nullableDefault);
        this.chkAutoNumber_.setSelected(false);
        this.chkPK.setSelected(false);
        this.chkUnique_.setSelected(false);
        this.isArrayPanel.setIsArray(false);
    }

    private void setCosmetics() {
        this.txtComment_.setRows(4);
        this.txtComment_.setLineWrap(true);
        this.txtComment_.setWrapStyleWord(true);
        this.chkNullable_.setMnemonic(78);
        this.chkAutoNumber_.setMnemonic(85);
        this.chkPK.setMnemonic(80);
        this.chkUnique_.setMnemonic(81);
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.txtName_);
        this.themeCtrl_.process(this.txtDefault_);
        this.themeCtrl_.process(this.txtComment_);
        this.themeCtrl_.process(this.chkNullable_);
        this.themeCtrl_.process(this.chkUnique_);
        this.themeCtrl_.process(this.chkAutoNumber_);
        this.themeCtrl_.process(this.chkPK);
        this.themeCtrl_.process(this.lblName_);
        this.themeCtrl_.process(this.lblDefault_);
        if (this.selectAllName) {
            this.txtName_.selectAll();
        }
    }

    private void validateName() throws IllegalArgumentException {
        if (this.txtName_.getText().length() == 0) {
            throw new IllegalArgumentException(Column.getMsgInvalidName());
        }
    }

    @Override
    public ITestResult validateData() {
        DataEntryResult result;
        block2: {
            try {
                this.syncData();
                result = new DataEntryResult(true);
            }
            catch (Exception e) {
                result = new DataEntryResult(false, e.getMessage());
                if (this.origColumn_ == null) break block2;
                this.loadData();
            }
        }
        return result;
    }

    private void syncData() throws Exception {
        String oldName;
        this.validateName();
        String name = this.txtName_.getText();
        String string = oldName = this.origColumn_ != null ? this.origColumn_.getName() : "";
        if (!oldName.equals(name)) {
            boolean oldSyncValue = this.syncOnEdit_;
            this.setSyncOnEdit(false);
            SqlReservedWordGui.instance().warnIfReserved(name);
            this.setSyncOnEdit(oldSyncValue);
        }
        IDataType dataType = this.getSelectedDataType();
        int dataTypeID = dataType.getId();
        Integer length = this.dataTypePanel.getLength();
        Integer scale = this.dataTypePanel.getScale();
        boolean nullable = this.chkNullable_.isSelected();
        boolean unique = this.chkUnique_.isSelected();
        boolean isArray = this.isArrayPanel.getIsArray();
        boolean autoNumber = this.chkAutoNumber_.isSelected();
        boolean signed = this.dataTypePanel.getSigned();
        String defaultStr = this.txtDefault_.getText();
        String commentStr = this.txtComment_.getText();
        String enumStr = this.txtEnum_.getText();
        this.newColumn_ = new Column(name, dataTypeID, length, nullable, autoNumber, defaultStr, scale, commentStr, signed, enumStr);
        this.newColumn_.setUnique(unique);
        this.newColumn_.setIsArray(isArray);
        BasicCollector.verifyNoDups(this.table_, this.origColumn_, this.newColumn_);
        if (this.syncOnEdit_) {
            if (this.origColumn_ != null) {
                this.startedUpdate_ = true;
                this.updatePK_SubCmd(this.origColumn_, this.newColumn_);
                this.doCollectorUpdate(this.origColumn_, this.newColumn_);
                this.origColumn_ = (Column)this.table_.get(this.className_, name);
            }
        } else {
            this.updatePK_SubCmd(this.origColumn_, this.newColumn_);
        }
        this.startedUpdate_ = false;
    }

    private void updatePK_SubCmd(Column oldColumn, Column newColumn) {
        ColumnEditPanelPK_Support pkSupport = new ColumnEditPanelPK_Support();
        this.updatePK_SubCmd = pkSupport.getUpdatePK_SubCmd(this.table_, oldColumn, newColumn, this.chkPK.isSelected());
    }

    private void doCollectorUpdate(Column oldColumn, Column newColumn) {
        UpdateInCollector updateCmd = new UpdateInCollector(this.table_, oldColumn, newColumn);
        updateCmd.setCommandChain(App.getCommandChain());
        updateCmd.setRenameMgr(App.getDb().getRenameMgr());
        if (this.updatePK_SubCmd != null) {
            updateCmd.addSubCommand(this.updatePK_SubCmd);
        }
        updateCmd.actionPerformed(null);
    }

    public Column getColumn() {
        this.validateData();
        return this.newColumn_;
    }

    private void initComponents() {
        this.setLayout(null);
    }

    @Override
    public Identifiable getDataObject() {
        return this.getColumn();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(BASIC_SIZE_STORABLE.getSize());
    }

    @Override
    public void update(UpdateChain chain) {
        if (!this.startedUpdate_ && chain.hasClassName(this.className_) && this.origColumn_ != null) {
            this.origColumn_ = this.table_.getKeys(this.className_).contains(this.origColumn_.getName()) ? (Column)this.table_.get(this.className_, this.origColumn_.getName()) : null;
            this.loadData();
        }
    }

    @Override
    public String getTitle() {
        String title = this.origColumn_ == null ? FileHelper.getResource("add.label") : FileHelper.getResource("edit.label");
        return title + " " + App.getResource("column.label");
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.COLUMN;
    }

    @Override
    public Dimension getSize() {
        return BASIC_SIZE_STORABLE.getSize();
    }

    @Override
    public void setSize(Dimension size) {
        BASIC_SIZE_STORABLE.setSize(size);
    }

    @Override
    public Collector getCollector() {
        return this.table_;
    }

    @Override
    public void resetUI() {
        this.reset();
        this.txtName_.requestFocus();
        this.origColumn_ = null;
    }

    @Override
    public Command getAddSubCmd() {
        return this.updatePK_SubCmd;
    }

    @Override
    public Command getUpdateSubCmd() {
        return this.updatePK_SubCmd;
    }

    public void selectAllName() {
        this.selectAllName = true;
    }

    @Override
    public void notifyDataTypeChanged() {
        this.refreshTxtEnum();
    }
}

