/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.option;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.panel.AddRemovePanel;
import com.harrand.coregui.panel.HeaderPanel;
import com.harrand.dbwrench.element.schema.SchemaIgnoreCtrl;
import com.harrand.dbwrenchnb.nb.NbUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SchemaIgnorePanel
extends JPanel {
    private SchemaIgnoreCtrl ignoreCtrl;
    private AddRemovePanel addRemovePanel = new AddRemovePanel();
    private JLabel lblIgnoreSch = new JLabel("Ignore These Schemas");
    private DefaultListModel listModel = new DefaultListModel();
    private JList lstIgnoreSch = new JList(this.listModel);
    private HeaderPanel header = new HeaderPanel("Ignore These Schemas", 5, true);
    private JTextArea txtDesc = new JTextArea("DbWrench will ignore these schemas during reverse engineer, forward engineer and database compare.");

    public SchemaIgnorePanel(SchemaIgnoreCtrl ignoreCtrl) {
        this.ignoreCtrl = ignoreCtrl;
        this.init();
        this.refresh();
    }

    public SchemaIgnoreCtrl getSchemaIgnoreCtrl() {
        return this.ignoreCtrl;
    }

    public void syncData() {
        if (this.ignoreCtrl == null) {
            this.ignoreCtrl = new SchemaIgnoreCtrl();
        }
        this.ignoreCtrl.clearNms();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            this.ignoreCtrl.add((String)this.listModel.get(i));
        }
    }

    private void init() {
        this.setupGui();
        this.loadData();
        this.buildListeners();
    }

    private void refresh() {
        this.loadData();
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)this.header, "North");
        this.add(this.getCenterPanel(), "Center");
        this.add((Component)this.addRemovePanel, "East");
        this.add((Component)this.txtDesc, "South");
    }

    private void setCosmetics() {
        GuiHelper.addEmptyBorder(this);
        this.setAddRemoveBorder();
        GuiHelper.addEmptyBorder(this.addRemovePanel);
        this.lblIgnoreSch.setFont(GuiHelper.getBoldFont(this.lblIgnoreSch.getFont()));
        this.txtDesc.setBackground(this.getBackground());
        this.txtDesc.setRows(3);
        this.txtDesc.setLineWrap(true);
        this.txtDesc.setWrapStyleWord(true);
    }

    private Component getCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        panel.add((Component)new JScrollPane(this.lstIgnoreSch), "Center");
        GuiHelper.addEmptyBorder(panel);
        return panel;
    }

    private void buildListeners() {
        this.addRemovePanel.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaIgnorePanel.this.addSchNm();
            }
        });
        this.addRemovePanel.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchemaIgnorePanel.this.removeSchNms();
            }
        });
    }

    private void addSchNm() {
        String schNm = JOptionPane.showInputDialog(NbUtil.getMainWindow(), "Schema Name:", "Ignore Schema", 3);
        if (schNm != null) {
            this.ignoreCtrl.add(schNm);
            this.refresh();
        }
    }

    private void removeSchNms() {
        Object[] selectedValues = this.lstIgnoreSch.getSelectedValues();
        if (selectedValues.length > 0) {
            for (int i = 0; i < selectedValues.length; ++i) {
                String schNm = (String)selectedValues[i];
                this.ignoreCtrl.remove(schNm);
            }
            this.refresh();
        } else {
            GuiMessageHelper.showInputErrMsg(null, "No Schema Selected", "Please select at least one schema name to remove.");
        }
    }

    private void loadData() {
        this.listModel.clear();
        if (this.ignoreCtrl == null) {
            return;
        }
        for (String schNm : this.ignoreCtrl.getIgnoreNms()) {
            this.listModel.addElement(schNm);
        }
    }

    private void setAddRemoveBorder() {
        int th = 5;
        this.addRemovePanel.setBorder(BorderFactory.createEmptyBorder(25, th, th, th));
    }
}

