/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.option;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.IErgonomicPanel;
import com.harrand.coreclasses.interfaces.IStorable;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.AddRemoveContainer;
import com.harrand.coregui.Icons;
import com.harrand.coregui.option.FilePathPanel;
import com.harrand.coregui.option.OptionEditPanel;
import com.harrand.coregui.option.UserOptionMgr;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.coregui.table.AbbreviationTableDriver;
import com.harrand.coregui.table.TablePanel;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrench.template.ColumnTemplateSvr;
import com.harrand.dbwrenchgui.naming.DbwNameBldrSvrPanel;
import com.harrand.dbwrenchgui.option.DataTypePrefPanel;
import com.harrand.dbwrenchgui.security.SecurityPanel;
import com.harrand.dbwrenchgui.template.ColumnTemplateListPanel;
import com.harrand.sketch.prefs.diagram.DiagramPrefPanel;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class PreferencesPanel
extends JPanel
implements ISized,
IErgonomicPanel,
IStorable {
    private DbUser user_;
    private JList jlist_;
    private JPanel centerPanel_;
    private JLabel lblTitle_ = new JLabel();
    private DefaultListModel listModel_;
    private DataTypePrefPanel dataTypePrefPanel_;
    private DiagramPrefPanel diagramPrefsPanel;
    private Map panelsMap_ = new HashMap();
    public static final String TITLE = ResMgr.getRes("edit.preferences");
    public static final String CLAZZ = "PreferencesPanel";
    private static final String SECURITY_NM = "Security";
    private static final String FILE_PATH_NM = "File Paths";
    private static final String DATATYPE_NM = "Data Types";
    private static final String DIAGRAMS_NM = "Diagrams";
    private static final String ABBR_NM = "Abbreviations";
    private static final String NAME_CONVENT_NM = "Naming Conventions";
    private static final String COL_TEMPLATES_NM = "Column Templates";
    private static final String EDIT_OPT_NM = "Query Editor";
    private static final String GRID_OPT_NM = "Query Results";
    private static final String DB_EXPLORER_OPT_NM = "Database Explorer";
    private static final String FOR_ENG_OPT_NM = "Forward Engineering";
    private static final String TBL_DATA_VW_NM = "Table Data Viewer";
    private static final String PSQL_NM = "PostgreSQL";

    public PreferencesPanel(DbUser user) {
        this.user_ = user;
        this.buildPanel();
        this.addListeners();
        this.setNames();
        this.jlist_.setSelectedIndex(0);
    }

    private void buildPanel() {
        this.buildSubPanels();
        this.initList();
        this.centerPanel_ = new JPanel(new BorderLayout(4, 4));
        this.centerPanel_.add((Component)new JPanel(), "Center");
        this.setLayout(new BorderLayout(12, 4));
        this.add((Component)this.getHeaderPanel(), "North");
        this.add((Component)this.getMainPanel(), "Center");
    }

    private void buildSubPanels() {
        AbbreviationTableDriver abbrDriver = new AbbreviationTableDriver(this.user_);
        TablePanel abbrTablePanel = new TablePanel(abbrDriver);
        AddRemoveContainer abbrContainer = new AddRemoveContainer((JPanel)abbrTablePanel, 5);
        DbUser mgrSvr = this.user_;
        IOptionMgr editOptionMgr = mgrSvr.getOptionMgr("editor.option.mgr");
        IOptionMgr gridOptionmgr = mgrSvr.getOptionMgr("result.option.mgr");
        IOptionMgr dbExpOptMgr = mgrSvr.getOptionMgr("db.explorer.option.mgr");
        IOptionMgr forEngOptMgr = mgrSvr.getOptionMgr("forward.engineer.option.mgr");
        IOptionMgr dataTypeOptMgr = mgrSvr.getOptionMgr("data.type.opt.mgr");
        IOptionMgr tblDataVwOptMgr = mgrSvr.getOptionMgr("tbl.data.view.opt.mgr");
        IOptionMgr psqlOptMgr = mgrSvr.getOptionMgr("psql.opt.mgr");
        ColumnTemplateSvr colTemplateSvr = this.user_.getColumnTemplateSvr();
        this.dataTypePrefPanel_ = new DataTypePrefPanel((UserOptionMgr)dataTypeOptMgr);
        this.diagramPrefsPanel = new DiagramPrefPanel();
        this.panelsMap_.put(SECURITY_NM, new SecurityPanel(this.user_));
        this.panelsMap_.put(FILE_PATH_NM, new FilePathPanel(this.user_));
        this.panelsMap_.put(ABBR_NM, abbrContainer);
        this.panelsMap_.put(NAME_CONVENT_NM, new DbwNameBldrSvrPanel());
        this.panelsMap_.put(EDIT_OPT_NM, new OptionEditPanel(editOptionMgr));
        this.panelsMap_.put(GRID_OPT_NM, new OptionEditPanel(gridOptionmgr));
        this.panelsMap_.put(DB_EXPLORER_OPT_NM, new OptionEditPanel(dbExpOptMgr, true));
        this.panelsMap_.put(FOR_ENG_OPT_NM, new OptionEditPanel(forEngOptMgr, true));
        this.panelsMap_.put(DATATYPE_NM, this.dataTypePrefPanel_);
        this.panelsMap_.put(DIAGRAMS_NM, this.diagramPrefsPanel);
        this.panelsMap_.put(COL_TEMPLATES_NM, new ColumnTemplateListPanel(colTemplateSvr));
        this.panelsMap_.put(TBL_DATA_VW_NM, new OptionEditPanel(tblDataVwOptMgr));
        this.panelsMap_.put(PSQL_NM, new OptionEditPanel(psqlOptMgr));
    }

    private void initList() {
        this.listModel_ = new DefaultListModel();
        this.listModel_.addElement(COL_TEMPLATES_NM);
        this.listModel_.addElement(NAME_CONVENT_NM);
        this.listModel_.addElement(DATATYPE_NM);
        this.listModel_.addElement(FOR_ENG_OPT_NM);
        this.listModel_.addElement(DB_EXPLORER_OPT_NM);
        this.listModel_.addElement(DIAGRAMS_NM);
        this.listModel_.addElement(ABBR_NM);
        this.listModel_.addElement(GRID_OPT_NM);
        this.listModel_.addElement(EDIT_OPT_NM);
        this.listModel_.addElement(TBL_DATA_VW_NM);
        this.listModel_.addElement(PSQL_NM);
        this.listModel_.addElement(FILE_PATH_NM);
        this.listModel_.addElement(SECURITY_NM);
        this.jlist_ = new JList(this.listModel_);
        this.jlist_.setPrototypeCellValue("Forward Engineering    ");
        this.jlist_.setSelectionMode(0);
    }

    private JPanel getMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(new JScrollPane(this.jlist_));
        panel.add(this.centerPanel_);
        return panel;
    }

    private XpHeaderPanel getHeaderPanel() {
        XpHeaderPanel panel = new XpHeaderPanel("User Preferences", "Preferences and options for DbWrench");
        return panel;
    }

    private void addListeners() {
        this.jlist_.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PreferencesPanel.this.setSubPanel();
            }
        });
    }

    private void setSubPanel() {
        String panelName = (String)this.jlist_.getSelectedValue();
        JPanel subPanel = (JPanel)this.panelsMap_.get(panelName);
        this.lblTitle_.setText(panelName);
        this.centerPanel_.removeAll();
        this.centerPanel_.add((Component)subPanel, "Center");
        this.centerPanel_.invalidate();
        this.centerPanel_.revalidate();
        this.centerPanel_.repaint();
    }

    private void setNames() {
        this.setName(TITLE);
        this.jlist_.setName("jlist");
        this.lblTitle_.setName("lblTitle");
    }

    @Override
    public JButton getDefaultButton() {
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.PREFERENCES;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(200, 200, 300, 250);
    }

    @Override
    public String getStorageName() {
        return CLAZZ;
    }
}

