/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.option;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.list.DualListPanel;
import com.harrand.coregui.option.UserOptionMgr;
import com.harrand.coregui.panel.HeaderPanel;
import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.DataType;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class DataTypePrefPanel
extends JPanel
implements IObserver {
    private UserOptionMgr dtOptMgr_;
    private DataTypeSvr dataTypeSvr_;
    private Database db_ = null;
    private CentralLookup centralLookup_ = CentralLookup.getDefault();
    private DualListPanel dualListPanel_;
    private HeaderPanel header_;
    private JTextPane txtDesc_ = new JTextPane();
    private int gap_ = 5;
    private JButton btnRefresh_;
    private ActionListener lisEnable_;
    private ActionListener lisDisable_;
    private MouseListener lisMouseEnable_;
    private MouseListener lisMouseDisable_;
    private SwingThemeCtrl ctrl_;

    public DataTypePrefPanel(UserOptionMgr dtOptMgr) {
        this.dtOptMgr_ = dtOptMgr;
        this.dataTypeSvr_ = new DataTypeSvr(this.dtOptMgr_);
        this.ctrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.btnRefresh_ = GuiHelper.getRefreshBtn();
        this.setupGui();
        this.centralLookup_.addObserver(this);
        this.updateDb();
    }

    private void setupGui() {
        this.buildControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.loadData();
        this.addListeners();
    }

    private void buildControls() {
        this.dualListPanel_ = new DualListPanel(new ArrayList().toArray(), new ArrayList().toArray());
        this.header_ = new HeaderPanel("Data Types", 5, false);
        this.txtDesc_.setText("Enable or disable standard data types based on your database system's level of support. Only enabled datatypes are displayed in data type combo boxes.");
        Color panColor = this.getBackground();
        Color panColorDup = new Color(panColor.getRed(), panColor.getGreen(), panColor.getBlue());
        this.txtDesc_.setBackground(panColorDup);
        this.txtDesc_.setEditable(false);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(5 * this.gap_, this.gap_));
        this.add((Component)this.header_, "North");
        this.add((Component)this.getMainPanel(), "Center");
        this.add((Component)this.getBtnPanel(), "South");
    }

    private JPanel getMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(this.gap_, this.gap_));
        panel.add((Component)this.txtDesc_, "North");
        panel.add((Component)this.dualListPanel_, "Center");
        this.ctrl_.process(panel);
        return panel;
    }

    private JPanel getBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(this.btnRefresh_);
        panel.add(Box.createHorizontalGlue());
        this.ctrl_.process(panel);
        return panel;
    }

    private void setCosmetics() {
        this.ctrl_.process(this.txtDesc_);
        this.ctrl_.process(this);
        this.dualListPanel_.setLeftLabel("Enabled Data Types");
        this.dualListPanel_.setRightLabel("Disabled Data Types");
        this.txtDesc_.setForeground(Color.BLACK);
    }

    private void setNames() {
        this.dualListPanel_.setName("dualListPanel");
    }

    private void loadData() {
        ArrayList<DataType> enabledTypes = new ArrayList<DataType>();
        ArrayList<DataType> disabledTypes = new ArrayList<DataType>();
        for (DataType dt : BasicTypesSvr.instance().getList()) {
            boolean enabled = this.dtOptMgr_.getBoolValue(dt.getIdStr());
            if (enabled) {
                enabledTypes.add(dt);
                continue;
            }
            disabledTypes.add(dt);
        }
        this.dualListPanel_.setData(enabledTypes.toArray(), disabledTypes.toArray());
    }

    private void addListeners() {
        this.btnRefresh_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTypePrefPanel.this.loadData();
            }
        });
        this.lisEnable_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTypePrefPanel.this.enableSelected();
            }
        };
        this.lisDisable_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTypePrefPanel.this.disableSelected();
            }
        };
        this.lisMouseEnable_ = new MyMouseListener(true);
        this.lisMouseDisable_ = new MyMouseListener(false);
        this.dualListPanel_.addToLeftListener(this.lisEnable_);
        this.dualListPanel_.addToRightListener(this.lisDisable_);
        this.dualListPanel_.addToLeftMouseListener(this.lisMouseEnable_);
        this.dualListPanel_.addToRightMouseListener(this.lisMouseDisable_);
    }

    private void enableSelected() {
        List selItems = this.dualListPanel_.getSelectedItems(1);
        for (Object obj : selItems) {
            DataType dt = (DataType)obj;
            String idStr = Integer.toString(dt.getId());
            this.dtOptMgr_.setBoolValue(idStr, true);
        }
        this.loadData();
    }

    private void disableSelected() {
        List selItems = this.dualListPanel_.getSelectedItems(0);
        for (DataType dt : selItems) {
            boolean ok = this.okToDisable(dt);
            if (!ok) continue;
            String idStr = Integer.toString(dt.getId());
            this.dtOptMgr_.setBoolValue(idStr, false);
        }
        this.loadData();
    }

    private boolean okToDisable(DataType dt) {
        boolean ok = true;
        if (this.db_ != null) {
            ITestResult result = DataTypeSvr.getIsDataTypeUsed(this.db_, dt, true);
            if (result.getPassed()) {
                GuiMessageHelper.showInputErrMsg(null, result.getSummary(), result.getDetail() + "\nIt can not be disabled.");
                ok = false;
            }
        }
        return ok;
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasClassName(CentralLookup.class.getName()) || chain.hasClassName(Database.class.getName())) {
            this.updateDb();
        }
    }

    private void updateDb() {
        this.db_ = LookupUtil.findDb();
        this.loadData();
    }

    private class MyMouseListener
    extends MouseAdapter {
        private boolean isEnabler_ = false;

        public MyMouseListener(boolean isEnabler) {
            this.isEnabler_ = isEnabler;
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if ((evt.getModifiers() & 0x10) != 0 && evt.getClickCount() == 2) {
                JList list = (JList)evt.getSource();
                int idx = list.locationToIndex(evt.getPoint());
                list.setSelectedIndex(idx);
                if (this.isEnabler_) {
                    DataTypePrefPanel.this.enableSelected();
                } else {
                    DataTypePrefPanel.this.disableSelected();
                }
            }
        }
    }
}

