/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.option;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.text.Abbreviation;
import com.harrand.coreclasses.text.IAbbreviationSrv;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.undo.BasicUndoEditListener;
import com.harrand.coregui.undo.InsertAbbrUndoableEdit;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.sub.editor.key.KeyStrokeActionCtrl;
import java.awt.event.KeyEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class AbbreviationCtrl {
    private JTextComponent txtComp_;
    private DbUser user_ = App.getUser();
    private BasicUndoEditListener editListener_ = new BasicUndoEditListener();
    private IAbbreviationSrv abbreviationSvr_ = this.user_;
    private long lastKeyHitTime_;
    private long abbrDelay_;
    private IOptionMgr editOptMgr_;

    public AbbreviationCtrl(JTextComponent txtComp) {
        this.txtComp_ = txtComp;
        this.updateOptions();
    }

    public void checkAbbreviationHit(KeyEvent keyEvent) {
        long currentTime;
        long elapsedTime;
        this.displayIndentInfo();
        boolean isSpaceHit = KeyStrokeActionCtrl.matches(keyEvent, 32, false, false, false);
        if (this.abbreviationSvr_ != null && isSpaceHit && (elapsedTime = (currentTime = System.currentTimeMillis()) - this.lastKeyHitTime_) < this.abbrDelay_) {
            int cursorPos = this.txtComp_.getCaretPosition() - 1;
            String shortText = StrHelper.getWordAtPos(this.getText(), cursorPos);
            Abbreviation abbr = this.abbreviationSvr_.getAbbreviation(shortText);
            if (abbr != null) {
                int abbrStart = cursorPos - abbr.getShortText().length();
                InsertAbbrUndoableEdit undoableEdit = new InsertAbbrUndoableEdit(this.txtComp_, this.editListener_, abbr, abbrStart);
                undoableEdit.exec();
            }
        }
        this.lastKeyHitTime_ = System.currentTimeMillis();
    }

    private void displayIndentInfo() {
        Document doc = this.txtComp_.getDocument();
    }

    private void updateOptions() {
        this.editOptMgr_ = this.user_.getOptionMgr("editor.option.mgr");
        if (this.editOptMgr_ != null) {
            this.abbrDelay_ = this.editOptMgr_.getIntValue("abbr.time.delay");
        }
    }

    private String getText() {
        return GuiHelper.getTextDocumentText(this.txtComp_.getDocument());
    }
}

