/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.naming;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.text.PreviewPanel;
import com.harrand.dbwrench.naming.DbNameProps;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.IDbNameProps;
import com.harrand.dbwrench.naming.IndexNameBldr;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.testData.NamingTestData;
import com.harrand.dbwrenchgui.naming.DbNamePropsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class IndexNamingPanel
extends JPanel
implements IObserver,
ISized {
    private DbwNameBldrSvr nameBldrSvr_ = DbwNameBldrSvr.instance();
    private IndexNameBldr nameBldr_;
    private DbNamePropsPanel dbNamePropsPanel_;
    private NamingTestData nd_ = new NamingTestData();
    private PreviewPanel previewPanel_ = new PreviewPanel();
    private JTextField txtUnique_ = new JTextField(5);
    private JTextField txtNonUnique_ = new JTextField(5);
    private JTextField txtClustered_ = new JTextField(5);
    private JLabel lblClustered_;
    private JLabel lblNonUnique_;
    private JLabel lblUnique_;
    private SwingThemeCtrl themeCtrl_;

    public IndexNamingPanel() {
        this.nameBldr_ = (IndexNameBldr)this.nameBldrSvr_.getNameBldr("IndexNameBldr");
        DbNameProps props = new DbNameProps(this.nameBldr_.getPrefix(), this.nameBldr_.getSeparator(), this.nameBldr_.getSuffix(), this.nameBldr_.getUseTableName(), this.nameBldr_.getUseColumnNames());
        this.dbNamePropsPanel_ = new DbNamePropsPanel(props);
        this.dbNamePropsPanel_.addObserver(this);
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
        this.refreshPreview();
    }

    private void setupGui() {
        this.buildControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.loadData();
        this.addListeners();
    }

    private void buildControls() {
        String div = "";
        this.lblClustered_ = new JLabel("Clustered String" + div);
        this.lblNonUnique_ = new JLabel("Non Unique String" + div);
        this.lblUnique_ = new JLabel("Unique String" + div);
    }

    private void setCosmetics() {
    }

    private void loadData() {
        this.txtClustered_.setText(this.nameBldr_.getClusteredStr());
        this.txtNonUnique_.setText(this.nameBldr_.getNonUniqueStr());
        this.txtUnique_.setText(this.nameBldr_.getUniqueStr());
    }

    private void layoutComponents() {
        this.setBorder(GuiHelper.getEmptyBorder());
        JPanel centerPanel = this.getCenterPanel();
        this.themeCtrl_.process(centerPanel);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.dbNamePropsPanel_, "North");
        this.add((Component)centerPanel, "Center");
        this.add((Component)this.previewPanel_, "South");
    }

    private JPanel getCenterPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPairFixed(this.lblUnique_, this.txtUnique_, gbc, panel, row++);
        GuiHelper.addGridbagPairFixed(this.lblNonUnique_, this.txtNonUnique_, gbc, panel, row++);
        GuiHelper.addGridbagPairFixed(this.lblClustered_, this.txtClustered_, gbc, panel, row++);
        return panel;
    }

    private void setNames() {
        this.lblClustered_.setName("lblClustered");
        this.txtClustered_.setName("txtClustered");
        this.txtNonUnique_.setName("txtNonUnique");
        this.lblUnique_.setName("lblUnique");
        this.txtUnique_.setName("txtUnique");
    }

    private void addListeners() {
        this.addListenersGetFocus();
        this.addKeyListeners();
    }

    private void addListenersGetFocus() {
        this.txtClustered_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                IndexNamingPanel.this.txtClustered_.selectAll();
            }
        });
        this.txtNonUnique_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                IndexNamingPanel.this.txtNonUnique_.selectAll();
            }
        });
        this.txtUnique_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                IndexNamingPanel.this.txtUnique_.selectAll();
            }
        });
    }

    private void addKeyListeners() {
        KeyListener lisTyped = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                IndexNamingPanel.this.syncData();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        this.txtClustered_.addKeyListener(lisTyped);
        this.txtNonUnique_.addKeyListener(lisTyped);
        this.txtUnique_.addKeyListener(lisTyped);
    }

    private void refreshPreview() {
        IndexNamingPanel indexNamingPanel = this;
        Table testTable = indexNamingPanel.nd_.getTestDb().getSchema("schemaA").getTable("TableName");
        Index testIndex = testTable.getIndex("TestIndex");
        String formedName = this.nameBldr_.getFormedName(testTable, testIndex);
        this.previewPanel_.setPreviewText(formedName);
    }

    public IndexNameBldr getNameBldr() {
        this.syncData();
        return this.nameBldr_;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 390, 250);
    }

    private void syncData() {
        IDbNameProps props = this.dbNamePropsPanel_.getDbNameProps();
        IndexNameBldr newBldr = new IndexNameBldr(props.getPrefix(), props.getSeparator(), props.getSuffix(), props.getUseTableName(), props.getUseColumnNames());
        newBldr.setUniqueStr(this.txtUnique_.getText());
        newBldr.setNonUniqueStr(this.txtNonUnique_.getText());
        newBldr.setClusterdStr(this.txtClustered_.getText());
        this.nameBldr_ = newBldr;
        this.refreshPreview();
        this.nameBldrSvr_.addNameBldr(this.nameBldr_);
    }

    @Override
    public void update(UpdateChain chain) {
        this.syncData();
    }
}

