/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.naming;

import com.harrand.coreclasses.naming.INameProps;
import com.harrand.coreclasses.naming.NameProps;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.naming.SuffixPrefixPanel;
import com.harrand.dbwrench.naming.DbNameProps;
import com.harrand.dbwrench.naming.IDbNameProps;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public final class DbNamePropsPanel
extends JPanel
implements IObservable,
IObserver {
    private IDbNameProps dbNameProps_ = null;
    private BasicObservable observable_ = new BasicObservable();
    private SuffixPrefixPanel suffixPrefixPanel_;
    private JCheckBox chkUseTableName_ = new JCheckBox("Use Table Name");
    private JCheckBox chkUseColumnNames_ = new JCheckBox("Use Column Names");
    private SwingThemeCtrl themeCtrl_;

    public DbNamePropsPanel(IDbNameProps dbNameProps) {
        this.dbNameProps_ = dbNameProps;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
        this.loadData();
    }

    private void setupGui() {
        this.buildControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void buildControls() {
        this.buildSubPanel();
    }

    private void buildSubPanel() {
        NameProps nameProps = null;
        if (this.dbNameProps_ != null) {
            nameProps = new NameProps(this.dbNameProps_.getPrefix(), this.dbNameProps_.getSeparator(), this.dbNameProps_.getSuffix());
        }
        this.suffixPrefixPanel_ = new SuffixPrefixPanel(nameProps);
        this.suffixPrefixPanel_.addObserver(this);
    }

    private void setCosmetics() {
    }

    private void loadData() {
        if (this.dbNameProps_ != null) {
            this.chkUseTableName_.setSelected(this.dbNameProps_.getUseTableName());
            this.chkUseColumnNames_.setSelected(this.dbNameProps_.getUseColumnNames());
        } else {
            this.chkUseTableName_.setSelected(false);
            this.chkUseColumnNames_.setSelected(false);
        }
    }

    private void layoutComponents() {
        this.setLayout(new BoxLayout(this, 2));
        JPanel eastPanel = this.getEastPanel();
        this.themeCtrl_.process(eastPanel);
        this.add(this.suffixPrefixPanel_);
        this.add(Box.createHorizontalStrut(5));
        this.add(eastPanel);
        this.add(Box.createGlue());
    }

    private JPanel getEastPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(this.chkUseTableName_);
        panel.add(Box.createVerticalStrut(5));
        panel.add(this.chkUseColumnNames_);
        panel.add(Box.createGlue());
        return panel;
    }

    private void setNames() {
        this.chkUseTableName_.setName("chkUseTableName");
        this.chkUseColumnNames_.setName("chkUseColumnNames");
    }

    private void addListeners() {
        this.addActionListeners();
    }

    private void addActionListeners() {
        ActionListener lisHit = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbNamePropsPanel.this.syncData();
                DbNamePropsPanel.this.notifyObservers(new UpdateChain(DbNamePropsPanel.this.dbNameProps_));
            }
        };
        this.chkUseTableName_.addActionListener(lisHit);
        this.chkUseColumnNames_.addActionListener(lisHit);
    }

    public IDbNameProps getDbNameProps() {
        this.syncData();
        return this.dbNameProps_;
    }

    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 350, 160);
    }

    private void syncData() {
        INameProps nameProps = this.suffixPrefixPanel_.getNameProps();
        DbNameProps newDbNameProps = new DbNameProps(nameProps.getPrefix(), nameProps.getSeparator(), nameProps.getSuffix(), this.chkUseTableName_.isSelected(), this.chkUseColumnNames_.isSelected());
        this.dbNameProps_ = newDbNameProps;
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void update(UpdateChain chain) {
        this.syncData();
        this.notifyObservers(chain);
    }
}

