/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrenchgui.diagram.svg.elmBldr;

import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.xml.svg.bldr.basic.SvgGradientBldr;
import com.harrand.sketch.xml.svg.bldr.basic.SvgRectBldr;
import com.harrand.sketch.xml.svg.common.SvgUtil;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgFrameBldr {
    private Document doc;
    private Dimension finalDiagramSz;
    public static final int ORIGIN_X = 2;
    public static final int ORIGIN_Y = 2;
    public static final Color LINE_COLOR = Color.GRAY;
    public static final String FRAME_NM = "frame";
    public static final String ANNOTATION_GRADIENT_ID = "annotation_gradient";

    public SvgFrameBldr(Document doc) {
        this.doc = doc;
    }

    public Element buildElm(Dimension finalDiagramSz) {
        this.finalDiagramSz = finalDiagramSz;
        Element elm = XmlHelper.createElementSimple(this.doc, "g", "");
        elm.setAttribute("class", FRAME_NM);
        elm.setAttribute("style", this.getStyleText());
        elm.appendChild(this.getFrameRectElm());
        this.addLineElms(elm);
        return elm;
    }

    private Element getFrameRectElm() {
        Element elm = XmlHelper.createElementSimple(this.doc, "rect", "");
        XmlHelper.setAttr(elm, "x", 2);
        XmlHelper.setAttr(elm, "y", 2);
        XmlHelper.setAttr(elm, "width", this.finalDiagramSz.width);
        XmlHelper.setAttr(elm, "height", this.finalDiagramSz.height + 26);
        return elm;
    }

    private String getStyleText() {
        return "fill:none;" + SvgUtil.getStrokeColorStr(LINE_COLOR) + "stroke-width:.5;";
    }

    public static Element getGradientElm(Document doc) {
        SvgGradientBldr gradientBldr = new SvgGradientBldr(doc);
        return gradientBldr.buildElm(Color.WHITE, new Color(223, 223, 223), false, ANNOTATION_GRADIENT_ID);
    }

    private void addLineElms(Element elm) {
        int yTop = this.finalDiagramSz.height + 2;
        int yBottom = yTop + 26;
        int xLineA = 200;
        int xLineB = 400;
        elm.appendChild(this.getTextRectElm(yTop));
        Element elmVertLineA = this.createLineElm(xLineA, yTop, xLineA, yBottom);
        elm.appendChild(elmVertLineA);
        Element elmVertLineB = this.createLineElm(xLineB, yTop, xLineB, yBottom);
        elm.appendChild(elmVertLineB);
    }

    private Element getTextRectElm(int yTop) {
        SvgRectBldr rectBldr = new SvgRectBldr(this.doc);
        rectBldr.setStrokeWidth(0.25);
        Rectangle2D.Double rect = new Rectangle2D.Double(2.0, yTop, this.finalDiagramSz.width, 26.0);
        EnhancedShape eShape = new EnhancedShape(rect, LINE_COLOR);
        Element elmTextRect = rectBldr.buildElmFromSquaredRect(eShape, ANNOTATION_GRADIENT_ID);
        return elmTextRect;
    }

    private Element createLineElm(int x1, int y1, int x2, int y2) {
        Element elm = XmlHelper.createElementSimple(this.doc, "line", "");
        XmlHelper.setAttr(elm, "x1", x1);
        XmlHelper.setAttr(elm, "y1", y1);
        XmlHelper.setAttr(elm, "x2", x2);
        XmlHelper.setAttr(elm, "y2", y2);
        return elm;
    }
}

